/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.SkriptConfig;
import ch.njol.skript.SkriptEventHandler;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEventInfo;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.eclipse.jdt.annotation.Nullable;
import org.skriptlang.skript.lang.entry.EntryContainer;
import org.skriptlang.skript.lang.script.Script;
import org.skriptlang.skript.lang.structure.Structure;
import org.skriptlang.skript.lang.structure.StructureInfo;

public abstract class SkriptEvent
extends Structure {
    public static final Structure.Priority PRIORITY = new Structure.Priority(600);
    private String expr;
    protected @Nullable EventPriority eventPriority;
    private SkriptEventInfo<?> skriptEventInfo;
    protected Trigger trigger;

    @Override
    public final boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parseResult, EntryContainer entryContainer) {
        String[] split;
        String expr = parseResult.expr;
        if (StringUtils.startsWithIgnoreCase(expr, "on ")) {
            expr = expr.substring("on ".length());
        }
        if ((split = expr.split(" with priority ")).length != 1) {
            if (!this.isEventPrioritySupported()) {
                Skript.error("This event doesn't support event priority");
                return false;
            }
            expr = String.join((CharSequence)" with priority ", Arrays.copyOfRange(split, 0, split.length - 1));
            String priorityString = split[split.length - 1];
            try {
                this.eventPriority = EventPriority.valueOf((String)priorityString.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalStateException(e);
            }
        } else {
            this.eventPriority = null;
        }
        this.expr = parseResult.expr = expr;
        StructureInfo<? extends Structure> syntaxElementInfo = this.getParser().getData(Structure.StructureData.class).getStructureInfo();
        if (!(syntaxElementInfo instanceof SkriptEventInfo)) {
            throw new IllegalStateException();
        }
        this.skriptEventInfo = (SkriptEventInfo)syntaxElementInfo;
        return this.init(args, matchedPattern, parseResult);
    }

    public abstract boolean init(Literal<?>[] var1, int var2, SkriptParser.ParseResult var3);

    @Override
    public boolean preLoad() {
        return super.preLoad();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean load() {
        if (!this.shouldLoadEvent()) {
            return false;
        }
        SectionNode source = this.getEntryContainer().getSource();
        if (Skript.debug() || source.debug()) {
            Skript.debug(this.expr + " (" + this + "):");
        }
        Class<? extends Event>[] eventClasses = this.getEventClasses();
        try {
            this.getParser().setCurrentEvent(this.skriptEventInfo.getName().toLowerCase(Locale.ENGLISH), eventClasses);
            @Nullable ArrayList<TriggerItem> items = ScriptLoader.loadItems(source);
            Script script = this.getParser().getCurrentScript();
            this.trigger = new Trigger(script, this.expr, this, items);
            int lineNumber = this.getEntryContainer().getSource().getLine();
            this.trigger.setLineNumber(lineNumber);
            this.trigger.setDebugLabel(script + ": line " + lineNumber);
        }
        finally {
            this.getParser().deleteCurrentEvent();
        }
        return true;
    }

    @Override
    public boolean postLoad() {
        SkriptEventHandler.registerBukkitEvents(this.trigger, this.getEventClasses());
        return true;
    }

    @Override
    public void unload() {
        SkriptEventHandler.unregisterBukkitEvents(this.trigger);
    }

    @Override
    public void postUnload() {
        super.postUnload();
    }

    @Override
    public Structure.Priority getPriority() {
        return PRIORITY;
    }

    public abstract boolean check(Event var1);

    public boolean shouldLoadEvent() {
        return true;
    }

    public Class<? extends Event>[] getEventClasses() {
        return this.skriptEventInfo.events;
    }

    public EventPriority getEventPriority() {
        return this.eventPriority != null ? this.eventPriority : SkriptConfig.defaultEventPriority.value();
    }

    public boolean isEventPrioritySupported() {
        return true;
    }

    public boolean canExecuteAsynchronously() {
        return false;
    }

    public static String fixPattern(String pattern) {
        char[] chars = pattern.toCharArray();
        StringBuilder stringBuilder = new StringBuilder();
        boolean inType = false;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            stringBuilder.append(c);
            if (c == '%') {
                boolean bl = inType = !inType;
                if (!inType || i + 2 >= chars.length || chars[i + 1] == '-' || chars[i + 2] == '-') continue;
                stringBuilder.append('-');
                continue;
            }
            if (c != '\\' || i + 1 >= chars.length) continue;
            stringBuilder.append(chars[i + 1]);
            ++i;
        }
        return stringBuilder.toString();
    }
}

