/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Debuggable;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.TriggerSection;
import ch.njol.skript.util.SkriptColor;
import ch.njol.util.StringUtils;
import java.io.File;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;
import org.skriptlang.skript.lang.script.Script;

public abstract class TriggerItem
implements Debuggable {
    protected @Nullable TriggerSection parent = null;
    private @Nullable TriggerItem next = null;
    private static final String indent = "  ";
    private @Nullable String indentation = null;

    protected TriggerItem() {
    }

    protected TriggerItem(TriggerSection parent) {
        this.parent = parent;
    }

    protected @Nullable TriggerItem walk(Event e) {
        if (this.run(e)) {
            this.debug(e, true);
            return this.next;
        }
        this.debug(e, false);
        TriggerSection parent = this.parent;
        return parent == null ? null : parent.getNext();
    }

    protected abstract boolean run(Event var1);

    public static boolean walk(TriggerItem start, Event e) {
        TriggerItem i;
        assert (start != null && e != null);
        try {
            for (i = start; i != null; i = i.walk(e)) {
            }
            return true;
        }
        catch (StackOverflowError err) {
            File scriptFile;
            Script script;
            Trigger t = start.getTrigger();
            String scriptName = "<unknown>";
            if (t != null && (script = t.getScript()) != null && (scriptFile = script.getConfig().getFile()) != null) {
                scriptName = scriptFile.getName();
            }
            Skript.adminBroadcast("<red>The script '<gold>" + scriptName + "<red>' infinitely (or excessively) repeated itself!");
            if (Skript.debug()) {
                err.printStackTrace();
            }
        }
        catch (Exception ex) {
            if (ex.getStackTrace().length != 0) {
                Skript.exception((Throwable)ex, i, new String[0]);
            }
        }
        catch (Throwable throwable) {
            Skript.markErrored();
            throw throwable;
        }
        return false;
    }

    public String getIndentation() {
        String ind = this.indentation;
        if (ind == null) {
            int level = 0;
            TriggerItem i = this;
            while ((i = i.parent) != null) {
                ++level;
            }
            this.indentation = ind = StringUtils.multiply(indent, level);
        }
        return ind;
    }

    protected final void debug(Event e, boolean run) {
        if (!Skript.debug()) {
            return;
        }
        Skript.debug(SkriptColor.replaceColorChar(this.getIndentation() + (run ? "" : "-") + this.toString(e, true)));
    }

    @Override
    public final String toString() {
        return this.toString(null, false);
    }

    public TriggerItem setParent(@Nullable TriggerSection parent) {
        this.parent = parent;
        return this;
    }

    public final @Nullable TriggerSection getParent() {
        return this.parent;
    }

    public final @Nullable Trigger getTrigger() {
        TriggerItem i;
        for (i = this; i != null && !(i instanceof Trigger); i = i.getParent()) {
        }
        return (Trigger)i;
    }

    public TriggerItem setNext(@Nullable TriggerItem next) {
        this.next = next;
        return this;
    }

    public @Nullable TriggerItem getNext() {
        return this.next;
    }
}

