/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAPIException;
import ch.njol.skript.SkriptConfig;
import ch.njol.skript.classes.Arithmetic;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.VariableString;
import ch.njol.skript.lang.parser.ParserInstance;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.structures.StructVariables;
import ch.njol.skript.util.StringMode;
import ch.njol.skript.util.Utils;
import ch.njol.skript.variables.TypeHints;
import ch.njol.skript.variables.Variables;
import ch.njol.util.Checker;
import ch.njol.util.Kleenean;
import ch.njol.util.Pair;
import ch.njol.util.StringUtils;
import ch.njol.util.coll.CollectionUtils;
import ch.njol.util.coll.iterator.EmptyIterator;
import ch.njol.util.coll.iterator.SingleItemIterator;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;
import org.skriptlang.skript.lang.comparator.Comparators;
import org.skriptlang.skript.lang.comparator.Relation;
import org.skriptlang.skript.lang.converter.Converters;
import org.skriptlang.skript.lang.script.Script;
import org.skriptlang.skript.lang.script.ScriptWarning;

public class Variable<T>
implements Expression<T> {
    private static final String SINGLE_SEPARATOR_CHAR = ":";
    public static final String SEPARATOR = "::";
    public static final String LOCAL_VARIABLE_TOKEN = "_";
    private final @Nullable Script script;
    private final VariableString name;
    private final Class<T> superType;
    final Class<? extends T>[] types;
    final boolean local;
    private final boolean list;
    private final @Nullable Variable<?> source;

    private Variable(VariableString name, Class<? extends T>[] types, boolean local, boolean list, @Nullable Variable<?> source) {
        assert (name != null);
        assert (types != null && types.length > 0);
        assert (name.isSimple() || name.getMode() == StringMode.VARIABLE_NAME);
        ParserInstance parser = this.getParser();
        this.script = parser.isActive() ? parser.getCurrentScript() : null;
        this.local = local;
        this.list = list;
        this.name = name;
        this.types = types;
        this.superType = Utils.getSuperType(types);
        this.source = source;
    }

    public static boolean isValidVariableName(String name, boolean allowListVariable, boolean printErrors) {
        String string = name = name.startsWith(LOCAL_VARIABLE_TOKEN) ? "" + name.substring(LOCAL_VARIABLE_TOKEN.length()).trim() : "" + name.trim();
        if (!allowListVariable && name.contains(SEPARATOR)) {
            if (printErrors) {
                Skript.error("List variables are not allowed here (error in variable {" + name + "})");
            }
            return false;
        }
        if (name.startsWith(SEPARATOR) || name.endsWith(SEPARATOR)) {
            if (printErrors) {
                Skript.error("A variable's name must neither start nor end with the separator '::' (error in variable {" + name + "})");
            }
            return false;
        }
        if (!(!name.contains("*") || allowListVariable && name.indexOf("*") == name.length() - 1 && name.endsWith("::*"))) {
            ArrayList<Integer> asterisks = new ArrayList<Integer>();
            ArrayList<Integer> percents = new ArrayList<Integer>();
            for (int i = 0; i < name.length(); ++i) {
                char c = name.charAt(i);
                if (c == '*') {
                    asterisks.add(i);
                    continue;
                }
                if (c != '%') continue;
                percents.add(i);
            }
            int count = asterisks.size();
            int index = 0;
            for (int i = 0; i < percents.size() && index != asterisks.size() && i + 1 != percents.size(); i += 2) {
                int lb = (Integer)percents.get(i);
                int ub = (Integer)percents.get(i + 1);
                while (index < asterisks.size() && lb < (Integer)asterisks.get(index) && (Integer)asterisks.get(index) < ub) {
                    --count;
                    ++index;
                }
            }
            if (!(count == 0 || count == 1 && name.endsWith("::*"))) {
                if (printErrors) {
                    if (name.indexOf("*") == 0) {
                        Skript.error("[2.0] Local variables now start with an underscore, e.g. {_local variable}. The asterisk is reserved for list variables. (error in variable {" + name + "})");
                    } else {
                        Skript.error("A variable's name must not contain any asterisks except at the end after '::' to denote a list variable, e.g. {variable::*} (error in variable {" + name + "})");
                    }
                }
                return false;
            }
        } else {
            if (name.contains("::::")) {
                if (printErrors) {
                    Skript.error("A variable's name must not contain the separator '::' multiple times in a row (error in variable {" + name + "})");
                }
                return false;
            }
            if (name.replace(SEPARATOR, "").contains(SINGLE_SEPARATOR_CHAR) && printErrors) {
                Skript.warning("If you meant to make the variable {" + name + "} a list, its name should contain '" + SEPARATOR + "'. Having a single '" + SINGLE_SEPARATOR_CHAR + "' does nothing!");
            }
        }
        return true;
    }

    public static <T> @Nullable Variable<T> newInstance(String name, Class<? extends T>[] types) {
        Class<String> hint;
        Script currentScript;
        name = "" + name.trim();
        if (!Variable.isValidVariableName(name, true, true)) {
            return null;
        }
        VariableString vs = VariableString.newInstance(name.startsWith(LOCAL_VARIABLE_TOKEN) ? name.substring(LOCAL_VARIABLE_TOKEN.length()).trim() : name, StringMode.VARIABLE_NAME);
        if (vs == null) {
            return null;
        }
        boolean isLocal = name.startsWith(LOCAL_VARIABLE_TOKEN);
        boolean isPlural = name.endsWith("::*");
        ParserInstance parser = ParserInstance.get();
        Script script = currentScript = parser.isActive() ? parser.getCurrentScript() : null;
        if (currentScript != null && !SkriptConfig.disableVariableStartingWithExpressionWarnings.value().booleanValue() && !currentScript.suppressesWarning(ScriptWarning.VARIABLE_STARTS_WITH_EXPRESSION) && (isLocal ? name.substring(LOCAL_VARIABLE_TOKEN.length()) : name).startsWith("%")) {
            Skript.warning("Starting a variable's name with an expression is discouraged ({" + name + "}). You could prefix it with the script's name: {" + StringUtils.substring(currentScript.getConfig().getFileName(), 0, -3) + SEPARATOR + name + "}");
        }
        if (isLocal && vs.isSimple() && (hint = TypeHints.get(vs.toString())) != null && !hint.equals(Object.class)) {
            for (Class<T> clazz : types) {
                assert (clazz != null);
                if (!clazz.isAssignableFrom(hint)) continue;
                return new Variable<T>(vs, CollectionUtils.array(clazz), true, isPlural, null);
            }
            for (Class<T> clazz : types) {
                if (Converters.converterExists(hint, clazz)) {
                    return new Variable<T>(vs, CollectionUtils.array(clazz), true, isPlural, null);
                }
                if (clazz.isAssignableFrom(World.class) && hint.isAssignableFrom(String.class)) {
                    return new Variable<T>(vs, types, true, isPlural, null);
                }
                if (!clazz.isAssignableFrom(Player.class) || !hint.isAssignableFrom(String.class)) continue;
                return new Variable<T>(vs, types, true, isPlural, null);
            }
            Object[] infos = new ClassInfo[types.length];
            for (int i = 0; i < types.length; ++i) {
                infos[i] = Classes.getExactClassInfo(types[i]);
            }
            Skript.warning("Variable '{_" + name + "}' is " + Classes.toString(Classes.getExactClassInfo(hint)) + ", not " + Classes.toString(infos, false));
        }
        return new Variable<T>(vs, types, isLocal, isPlural, null);
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        throw new UnsupportedOperationException();
    }

    public boolean isLocal() {
        return this.local;
    }

    public boolean isList() {
        return this.list;
    }

    @Override
    public boolean isSingle() {
        return !this.list;
    }

    @Override
    public Class<? extends T> getReturnType() {
        return this.superType;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        StringBuilder stringBuilder = new StringBuilder().append("{");
        if (this.local) {
            stringBuilder.append(LOCAL_VARIABLE_TOKEN);
        }
        stringBuilder.append(StringUtils.substring(this.name.toString(e, debug), 1, -1)).append("}");
        if (debug) {
            stringBuilder.append(" (");
            if (e != null) {
                stringBuilder.append(Classes.toString(this.get(e))).append(", ");
            }
            stringBuilder.append("as ").append(this.superType.getName()).append(")");
        }
        return stringBuilder.toString();
    }

    @Override
    public String toString() {
        return this.toString(null, false);
    }

    @Override
    public <R> Variable<R> getConvertedExpression(Class<R> ... to) {
        return new Variable<R>(this.name, to, this.local, this.list, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable Object getRaw(Event event) {
        StructVariables.DefaultVariables data;
        StructVariables.DefaultVariables defaultVariables = data = this.script == null ? null : this.script.getData(StructVariables.DefaultVariables.class);
        if (data != null) {
            data.enterScope();
        }
        try {
            Object value;
            String name = this.name.toString(event);
            if (name.endsWith("::*") != this.list) {
                Object var4_4 = null;
                return var4_4;
            }
            Object object = value = !this.list ? this.convertIfOldPlayer(name, event, Variables.getVariable(name, event, this.local)) : Variables.getVariable(name, event, this.local);
            if (value != null) {
                Object object2 = value;
                return object2;
            }
            if (data == null || !data.hasDefaultVariables()) {
                Object var5_7 = null;
                return var5_7;
            }
            for (String typeHint : this.name.getDefaultVariableNames(name, event)) {
                value = Variables.getVariable(typeHint, event, false);
                if (value == null) continue;
                Object object3 = value;
                return object3;
            }
        }
        finally {
            if (data != null) {
                data.exitScope();
            }
        }
        return null;
    }

    private @Nullable Object get(Event event) {
        Object val = this.getRaw(event);
        if (!this.list) {
            return val;
        }
        if (val == null) {
            return Array.newInstance(this.types[0], 0);
        }
        ArrayList<Object> l = new ArrayList<Object>();
        String name = StringUtils.substring(this.name.toString(event), 0, -1);
        for (Map.Entry v : ((Map)val).entrySet()) {
            Object o;
            if (v.getKey() == null || v.getValue() == null || (o = v.getValue() instanceof Map ? ((Map)v.getValue()).get(null) : v.getValue()) == null) continue;
            l.add(this.convertIfOldPlayer(name + (String)v.getKey(), event, o));
        }
        return l.toArray();
    }

    @Nullable Object convertIfOldPlayer(String key, Event event, @Nullable Object object) {
        Player p;
        if (SkriptConfig.enablePlayerVariableFix.value().booleanValue() && object != null && object instanceof Player && !(p = (Player)object).isValid() && p.isOnline()) {
            Player player = Bukkit.getPlayer((UUID)p.getUniqueId());
            Variables.setVariable(key, player, event, this.local);
            return player;
        }
        return object;
    }

    public Iterator<Pair<String, Object>> variablesIterator(final Event e) {
        if (!this.list) {
            throw new SkriptAPIException("Looping a non-list variable");
        }
        final String name = StringUtils.substring(this.name.toString(e), 0, -1);
        Object val = Variables.getVariable(name + "*", e, this.local);
        if (val == null) {
            return new EmptyIterator<Pair<String, Object>>();
        }
        assert (val instanceof TreeMap);
        final Iterator keys = new ArrayList(((Map)val).keySet()).iterator();
        return new Iterator<Pair<String, Object>>(){
            private @Nullable String key;
            private @Nullable Object next = null;

            @Override
            public boolean hasNext() {
                if (this.next != null) {
                    return true;
                }
                while (keys.hasNext()) {
                    this.key = (String)keys.next();
                    if (this.key == null) continue;
                    this.next = Variable.this.convertIfOldPlayer(name + this.key, e, Variables.getVariable(name + this.key, e, Variable.this.local));
                    if (this.next == null || this.next instanceof TreeMap) continue;
                    return true;
                }
                this.next = null;
                return false;
            }

            @Override
            public Pair<String, Object> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Pair<String, Object> n = new Pair<String, Object>(this.key, this.next);
                this.next = null;
                return n;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public @Nullable Iterator<T> iterator(final Event e) {
        if (!this.list) {
            T item = this.getSingle(e);
            return item != null ? new SingleItemIterator<T>(item) : null;
        }
        final String name = StringUtils.substring(this.name.toString(e), 0, -1);
        Object val = Variables.getVariable(name + "*", e, this.local);
        if (val == null) {
            return new EmptyIterator();
        }
        assert (val instanceof TreeMap);
        final Iterator keys = new ArrayList(((Map)val).keySet()).iterator();
        return new Iterator<T>(){
            private @Nullable String key;
            private @Nullable T next = null;

            @Override
            public boolean hasNext() {
                if (this.next != null) {
                    return true;
                }
                while (keys.hasNext()) {
                    this.key = (String)keys.next();
                    if (this.key == null) continue;
                    this.next = Converters.convert(Variables.getVariable(name + this.key, e, Variable.this.local), Variable.this.types);
                    this.next = Variable.this.convertIfOldPlayer(name + this.key, e, this.next);
                    if (this.next == null || this.next instanceof TreeMap) continue;
                    return true;
                }
                this.next = null;
                return false;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object n = this.next;
                assert (n != null);
                this.next = null;
                return n;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private @Nullable T getConverted(Event e) {
        assert (!this.list);
        return Converters.convert(this.get(e), this.types);
    }

    private T[] getConvertedArray(Event e) {
        assert (this.list);
        return Converters.convert((Object[])this.get(e), this.types, this.superType);
    }

    private void set(Event e, @Nullable Object value) {
        Variables.setVariable("" + this.name.toString(e), value, e, this.local);
    }

    private void setIndex(Event e, String index, @Nullable Object value) {
        assert (this.list);
        String s = this.name.toString(e);
        assert (s.endsWith("::*")) : s + "; " + this.name;
        Variables.setVariable(s.substring(0, s.length() - 1) + index, value, e, this.local);
    }

    @Override
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (!this.list && mode == Changer.ChangeMode.SET) {
            return CollectionUtils.array(Object.class);
        }
        return CollectionUtils.array(Object[].class);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) throws UnsupportedOperationException {
        switch (mode) {
            case DELETE: {
                if (this.list) {
                    ArrayList<String> rem = new ArrayList<String>();
                    Map o = (Map)this.getRaw(e);
                    if (o == null) {
                        return;
                    }
                    for (Map.Entry i : o.entrySet()) {
                        if (i.getKey() == null) continue;
                        rem.add((String)i.getKey());
                    }
                    for (String r : rem) {
                        assert (r != null);
                        this.setIndex(e, r, null);
                    }
                }
                this.set(e, null);
                break;
            }
            case SET: {
                assert (delta != null);
                if (this.list) {
                    this.set(e, null);
                    int i = 1;
                    for (Object d : delta) {
                        if (d instanceof Object[]) {
                            for (int j = 0; j < ((Object[])d).length; ++j) {
                                this.setIndex(e, "" + i + SEPARATOR + j, ((Object[])d)[j]);
                            }
                        } else {
                            this.setIndex(e, "" + i, d);
                        }
                        ++i;
                    }
                    break;
                }
                this.set(e, delta[0]);
                break;
            }
            case RESET: {
                Object x = this.getRaw(e);
                if (x == null) {
                    return;
                }
                for (Object v : x instanceof Map ? ((Map)x).values() : Arrays.asList(x)) {
                    Class<?> c = v.getClass();
                    assert (c != null);
                    ClassInfo<?> ci = Classes.getSuperClassInfo(c);
                    Changer<?> changer = ci.getChanger();
                    if (changer == null || changer.acceptChange(Changer.ChangeMode.RESET) == null) continue;
                    Object[] one = (Object[])Array.newInstance(v.getClass(), 1);
                    one[0] = v;
                    changer.change(one, null, Changer.ChangeMode.RESET);
                }
                break;
            }
            case ADD: 
            case REMOVE: 
            case REMOVE_ALL: {
                Class<?>[] cs;
                void var6_22;
                assert (delta != null);
                if (this.list) {
                    Map o = (Map)this.getRaw(e);
                    if (mode == Changer.ChangeMode.REMOVE) {
                        if (o == null) {
                            return;
                        }
                        ArrayList<String> arrayList = new ArrayList<String>();
                        block11: for (Object d : delta) {
                            for (Map.Entry i : o.entrySet()) {
                                String key;
                                if (!Relation.EQUAL.isImpliedBy(Comparators.compare(i.getValue(), d)) || (key = (String)i.getKey()) == null) continue;
                                arrayList.add(key);
                                continue block11;
                            }
                        }
                        for (String r : arrayList) {
                            assert (r != null);
                            this.setIndex(e, r, null);
                        }
                    } else if (mode == Changer.ChangeMode.REMOVE_ALL) {
                        if (o == null) {
                            return;
                        }
                        ArrayList<String> arrayList = new ArrayList<String>();
                        for (Map.Entry i : o.entrySet()) {
                            for (Object d : delta) {
                                if (!Relation.EQUAL.isImpliedBy(Comparators.compare(i.getValue(), d))) continue;
                                arrayList.add((String)i.getKey());
                            }
                        }
                        for (String r : arrayList) {
                            assert (r != null);
                            this.setIndex(e, r, null);
                        }
                    } else {
                        assert (mode == Changer.ChangeMode.ADD);
                        boolean bl = true;
                        for (Object d : delta) {
                            void var6_19;
                            if (o != null) {
                                while (o.containsKey("" + (int)var6_19)) {
                                    ++var6_19;
                                }
                            }
                            this.setIndex(e, "" + (int)var6_19, d);
                            ++var6_19;
                        }
                    }
                    break;
                }
                Object o = this.get(e);
                if (o == null) {
                    Object var6_20 = null;
                } else {
                    Class<?> c = o.getClass();
                    assert (c != null);
                    ClassInfo<?> classInfo = Classes.getSuperClassInfo(c);
                }
                Arithmetic<Object, ?> a = null;
                if (o == null || var6_22 == null || (a = var6_22.getMath()) != null) {
                    boolean changed = false;
                    for (Object d : delta) {
                        void var6_23;
                        if (o == null || var6_23 == null) {
                            Class<?> c = d.getClass();
                            assert (c != null);
                            ClassInfo<?> classInfo = Classes.getSuperClassInfo(c);
                            a = classInfo.getMath();
                            if (a != null) {
                                o = d;
                            }
                            if (d instanceof Number) {
                                o = mode == Changer.ChangeMode.REMOVE ? Double.valueOf(-((Number)d).doubleValue()) : d;
                            }
                            changed = true;
                            continue;
                        }
                        Class<?> r = var6_23.getMathRelativeType();
                        assert (a != null && r != null) : var6_23;
                        Object diff = Converters.convert(d, r);
                        if (diff == null) continue;
                        o = mode == Changer.ChangeMode.ADD ? a.add(o, diff) : a.subtract(o, diff);
                        changed = true;
                    }
                    if (!changed) break;
                    this.set(e, o);
                    break;
                }
                Changer changer = var6_22.getChanger();
                if (changer == null || (cs = changer.acceptChange(mode)) == null) break;
                Object[] one = (Object[])Array.newInstance(o.getClass(), 1);
                one[0] = o;
                Class[] cs2 = new Class[cs.length];
                for (int i = 0; i < cs.length; ++i) {
                    cs2[i] = cs[i].isArray() ? cs[i].getComponentType() : cs[i];
                }
                ArrayList l = new ArrayList();
                for (Object d : delta) {
                    Object d2 = Converters.convert(d, cs2);
                    if (d2 == null) continue;
                    l.add(d2);
                }
                Changer.ChangerUtils.change(changer, one, l.toArray(), mode);
            }
        }
    }

    @Override
    public @Nullable T getSingle(Event e) {
        if (this.list) {
            throw new SkriptAPIException("Invalid call to getSingle");
        }
        return this.getConverted(e);
    }

    @Override
    public T[] getArray(Event e) {
        return this.getAll(e);
    }

    @Override
    public T[] getAll(Event e) {
        if (this.list) {
            return this.getConvertedArray(e);
        }
        T o = this.getConverted(e);
        if (o == null) {
            Object[] r = (Object[])Array.newInstance(this.superType, 0);
            assert (r != null);
            return r;
        }
        Object[] one = (Object[])Array.newInstance(this.superType, 1);
        one[0] = o;
        return one;
    }

    @Override
    public boolean isLoopOf(String s) {
        return s.equalsIgnoreCase("var") || s.equalsIgnoreCase("variable") || s.equalsIgnoreCase("value") || s.equalsIgnoreCase("index");
    }

    public boolean isIndexLoop(String s) {
        return s.equalsIgnoreCase("index");
    }

    @Override
    public boolean check(Event e, Checker<? super T> c, boolean negated) {
        return SimpleExpression.check(this.getAll(e), c, negated, this.getAnd());
    }

    @Override
    public boolean check(Event e, Checker<? super T> c) {
        return SimpleExpression.check(this.getAll(e), c, false, this.getAnd());
    }

    public VariableString getName() {
        return this.name;
    }

    @Override
    public boolean getAnd() {
        return true;
    }

    @Override
    public boolean setTime(int time) {
        return false;
    }

    @Override
    public int getTime() {
        return 0;
    }

    @Override
    public boolean isDefault() {
        return false;
    }

    @Override
    public Expression<?> getSource() {
        Variable<?> s = this.source;
        return s == null ? this : s;
    }

    @Override
    public Expression<? extends T> simplify() {
        return this;
    }
}

