/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang.function;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAPIException;
import ch.njol.skript.SkriptAddon;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.lang.function.Function;
import ch.njol.skript.lang.function.FunctionReference;
import ch.njol.skript.lang.function.JavaFunction;
import ch.njol.skript.lang.function.Namespace;
import ch.njol.skript.lang.function.Parameter;
import ch.njol.skript.lang.function.ScriptFunction;
import ch.njol.skript.lang.function.Signature;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.Utils;
import ch.njol.util.NonNullPair;
import ch.njol.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.skriptlang.skript.lang.script.Script;

public abstract class Functions {
    private static final String INVALID_FUNCTION_DEFINITION = "Invalid function definition. Please check for typos and make sure that the function's name only contains letters and underscores. Refer to the documentation for more information.";
    public static @Nullable ScriptFunction<?> currentFunction = null;
    private static final Map<Namespace.Key, Namespace> namespaces = new HashMap<Namespace.Key, Namespace>();
    private static final Namespace javaNamespace = new Namespace();
    private static final Map<String, Namespace> globalFunctions;
    static boolean callFunctionEvents;
    public static final String functionNamePattern = "[\\p{IsAlphabetic}][\\p{IsAlphabetic}\\p{IsDigit}_]*";
    private static final Collection<FunctionReference<?>> toValidate;

    private Functions() {
    }

    public static JavaFunction<?> registerFunction(JavaFunction<?> function) {
        Skript.checkAcceptRegistrations();
        String name = function.getName();
        if (!name.matches(functionNamePattern)) {
            throw new SkriptAPIException("Invalid function name '" + name + "'");
        }
        javaNamespace.addSignature(function.getSignature());
        javaNamespace.addFunction(function);
        globalFunctions.put(function.getName(), javaNamespace);
        return function;
    }

    public static @Nullable Function<?> loadFunction(Script script, SectionNode node, Signature<?> signature) {
        String name = signature.name;
        Namespace namespace = Functions.getScriptNamespace(script.getConfig().getFileName());
        if (namespace == null && (namespace = globalFunctions.get(name)) == null) {
            return null;
        }
        Object[] params = signature.parameters;
        ClassInfo c = signature.returnType;
        if (Skript.debug() || node.debug()) {
            Skript.debug((signature.local ? "local " : "") + "function " + name + "(" + StringUtils.join(params, ", ") + ")" + (c != null ? " :: " + (signature.isSingle() ? c.getName().getSingular() : c.getName().getPlural()) : "") + ":");
        }
        ScriptFunction f = new ScriptFunction(signature, script, node);
        namespace.addFunction(f);
        return f;
    }

    public static @Nullable Signature<?> parseSignature(String script, String name, String args, @Nullable String returnType, boolean local) {
        boolean singleReturn;
        ClassInfo<?> returnClass;
        List<Parameter<?>> parameters = Parameter.parse(args);
        if (parameters == null) {
            return null;
        }
        if (returnType == null) {
            returnClass = null;
            singleReturn = false;
        } else {
            returnClass = Classes.getClassInfoFromUserInput(returnType);
            NonNullPair<String, Boolean> p = Utils.getEnglishPlural(returnType);
            boolean bl = singleReturn = p.getSecond() == false;
            if (returnClass == null) {
                returnClass = Classes.getClassInfoFromUserInput(p.getFirst());
            }
            if (returnClass == null) {
                return Functions.signError("Cannot recognise the type '" + returnType + "'");
            }
        }
        return new Signature(script, name, parameters.toArray(new Parameter[0]), local, returnClass, singleReturn, null);
    }

    public static @Nullable Signature<?> registerSignature(Signature<?> signature) {
        if (signature.local) {
            Namespace namespace = Functions.getScriptNamespace(signature.script);
            if (namespace != null && namespace.getSignature(signature.name, true) != null) {
                return Functions.signError("A local function named '" + signature.name + "' already exists in the script");
            }
        } else if (globalFunctions.containsKey(signature.name)) {
            Namespace namespace = globalFunctions.get(signature.name);
            if (namespace == javaNamespace) {
                return Functions.signError("Function name '" + signature.name + "' is reserved by Skript");
            }
            Signature<?> sign = namespace.getSignature(signature.name, false);
            assert (sign != null) : "globalFunctions points to a wrong namespace";
            return Functions.signError("A global function named '" + signature.name + "' already exists in script '" + sign.script + "'");
        }
        Namespace.Key namespaceKey = new Namespace.Key(Namespace.Origin.SCRIPT, signature.script);
        Namespace namespace = namespaces.computeIfAbsent(namespaceKey, k -> new Namespace());
        namespace.addSignature(signature);
        if (!signature.local) {
            globalFunctions.put(signature.name, namespace);
        }
        Skript.debug("Registered function signature: " + signature.name);
        return signature;
    }

    private static @Nullable Function<?> error(String error) {
        Skript.error(error);
        return null;
    }

    private static @Nullable Signature<?> signError(String error) {
        Skript.error(error);
        return null;
    }

    @Deprecated
    public static @Nullable Function<?> getFunction(String name) {
        return Functions.getGlobalFunction(name);
    }

    public static @Nullable Function<?> getGlobalFunction(String name) {
        Namespace namespace = globalFunctions.get(name);
        if (namespace == null) {
            return null;
        }
        return namespace.getFunction(name, false);
    }

    public static @Nullable Function<?> getLocalFunction(String name, String script) {
        Namespace namespace = null;
        Function<?> function = null;
        namespace = Functions.getScriptNamespace(script);
        if (namespace != null) {
            function = namespace.getFunction(name);
        }
        return function;
    }

    public static @Nullable Function<?> getFunction(String name, @Nullable String script) {
        if (script == null) {
            return Functions.getGlobalFunction(name);
        }
        Function<?> function = Functions.getLocalFunction(name, script);
        if (function == null) {
            return Functions.getGlobalFunction(name);
        }
        return function;
    }

    @Deprecated
    public static @Nullable Signature<?> getSignature(String name) {
        return Functions.getGlobalSignature(name);
    }

    public static @Nullable Signature<?> getGlobalSignature(String name) {
        Namespace namespace = globalFunctions.get(name);
        if (namespace == null) {
            return null;
        }
        return namespace.getSignature(name, false);
    }

    public static @Nullable Signature<?> getLocalSignature(String name, String script) {
        Namespace namespace = null;
        Signature<?> signature = null;
        namespace = Functions.getScriptNamespace(script);
        if (namespace != null) {
            signature = namespace.getSignature(name);
        }
        return signature;
    }

    public static @Nullable Signature<?> getSignature(String name, @Nullable String script) {
        if (script == null) {
            return Functions.getGlobalSignature(name);
        }
        Signature<?> signature = Functions.getLocalSignature(name, script);
        if (signature == null) {
            return Functions.getGlobalSignature(name);
        }
        return signature;
    }

    public static @Nullable Namespace getScriptNamespace(String script) {
        return namespaces.get(new Namespace.Key(Namespace.Origin.SCRIPT, script));
    }

    @Deprecated
    public static int clearFunctions(String script) {
        Namespace namespace = namespaces.remove(new Namespace.Key(Namespace.Origin.SCRIPT, script));
        if (namespace == null) {
            return 0;
        }
        globalFunctions.values().removeIf(loopedNamespaced -> loopedNamespaced == namespace);
        for (Signature<?> sign : namespace.getSignatures()) {
            for (FunctionReference<?> ref : sign.calls) {
                if (script.equals(ref.script)) continue;
                toValidate.add(ref);
            }
        }
        return namespace.getSignatures().size();
    }

    public static void unregisterFunction(Signature<?> signature) {
        Iterator<Namespace> namespaceIterator = namespaces.values().iterator();
        while (namespaceIterator.hasNext()) {
            Namespace namespace = namespaceIterator.next();
            if (!namespace.removeSignature(signature)) continue;
            if (!signature.local) {
                globalFunctions.remove(signature.getName());
            }
            if (!namespace.getSignatures().isEmpty()) break;
            namespaceIterator.remove();
            break;
        }
        for (FunctionReference<?> ref : signature.calls) {
            if (signature.script.equals(ref.script)) continue;
            toValidate.add(ref);
        }
    }

    public static void validateFunctions() {
        for (FunctionReference<?> c : toValidate) {
            c.validateFunction(false);
        }
        toValidate.clear();
    }

    @Deprecated
    public static void clearFunctions() {
        globalFunctions.values().removeIf(namespace -> namespace != javaNamespace);
        namespaces.clear();
        assert (toValidate.isEmpty()) : toValidate;
        toValidate.clear();
    }

    public static Collection<JavaFunction<?>> getJavaFunctions() {
        return javaNamespace.getFunctions();
    }

    public static void enableFunctionEvents(SkriptAddon addon) {
        if (addon == null) {
            throw new SkriptAPIException("enabling function events requires addon instance");
        }
        callFunctionEvents = true;
    }

    static {
        namespaces.put(new Namespace.Key(Namespace.Origin.JAVA, "unknown"), javaNamespace);
        globalFunctions = new HashMap<String, Namespace>();
        callFunctionEvents = false;
        toValidate = new ArrayList();
    }
}

