/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util;

import ch.njol.skript.Skript;
import ch.njol.skript.localization.Language;
import ch.njol.skript.localization.Noun;
import ch.njol.util.NonNullPair;
import ch.njol.util.StringUtils;
import java.util.HashMap;
import java.util.Locale;
import org.eclipse.jdt.annotation.Nullable;

public final class EnumUtils<E extends Enum<E>> {
    private final Class<E> c;
    private final String languageNode;
    private String[] names;
    private final HashMap<String, E> parseMap = new HashMap();

    public EnumUtils(Class<E> c, String languageNode) {
        assert (c != null && c.isEnum()) : c;
        assert (languageNode != null && !languageNode.isEmpty() && !languageNode.endsWith(".")) : languageNode;
        this.c = c;
        this.languageNode = languageNode;
        this.names = new String[((Enum[])c.getEnumConstants()).length];
        Language.addListener(() -> this.validate(true));
    }

    void validate(boolean force) {
        boolean update = force;
        Enum[] constants = (Enum[])this.c.getEnumConstants();
        if (constants.length != this.names.length) {
            this.names = new String[constants.length];
            update = true;
        } else {
            for (Enum constant : constants) {
                if (this.parseMap.containsValue(constant)) continue;
                update = true;
                break;
            }
        }
        if (update) {
            this.parseMap.clear();
            for (Enum e : constants) {
                String[] values;
                String key = this.languageNode + "." + e.name();
                int ordinal = e.ordinal();
                for (String option : values = Language.getList(key)) {
                    option = option.toLowerCase(Locale.ENGLISH);
                    if (values.length == 1 && option.equals(key.toLowerCase(Locale.ENGLISH))) {
                        Skript.warning("Missing lang enum constant for '" + key + "'");
                        continue;
                    }
                    NonNullPair<String, Integer> strippedOption = Noun.stripGender(option, key);
                    String first = strippedOption.getFirst();
                    Integer second = strippedOption.getSecond();
                    if (this.names[ordinal] == null) {
                        this.names[ordinal] = first;
                    }
                    this.parseMap.put(first, e);
                    if (second == -1) continue;
                    this.parseMap.put(Noun.getArticleWithSpace(second, 4) + first, e);
                }
            }
        }
    }

    public @Nullable E parse(String s) {
        this.validate(false);
        return (E)((Enum)this.parseMap.get(s.toLowerCase(Locale.ENGLISH)));
    }

    public String toString(E e, int flags) {
        this.validate(false);
        return this.names[((Enum)e).ordinal()];
    }

    public String getAllNames() {
        this.validate(false);
        return StringUtils.join(this.parseMap.keySet(), ", ");
    }
}

