/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util.chat;

import ch.njol.skript.Skript;
import ch.njol.skript.util.chat.ChatMessages;
import ch.njol.skript.util.chat.MessageComponent;
import java.util.Arrays;
import java.util.List;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.TranslatableComponent;

public class BungeeConverter {
    private static boolean HAS_FONT_SUPPORT = Skript.methodExists(BaseComponent.class, "setFont", String.class);

    public static BaseComponent convert(MessageComponent origin) {
        TextComponent base;
        if (origin.translation != null) {
            String[] strings = origin.translation.split(":");
            String key = strings[0];
            base = strings.length > 1 ? new TranslatableComponent(key, (Object[])Arrays.copyOfRange(strings, 1, strings.length, Object[].class)) : new TranslatableComponent(key, new Object[0]);
            base.addExtra((BaseComponent)new TextComponent(origin.text));
        } else {
            base = new TextComponent(origin.text);
        }
        base.setBold(Boolean.valueOf(origin.bold));
        base.setItalic(Boolean.valueOf(origin.italic));
        base.setUnderlined(Boolean.valueOf(origin.underlined));
        base.setStrikethrough(Boolean.valueOf(origin.strikethrough));
        base.setObfuscated(Boolean.valueOf(origin.obfuscated));
        if (origin.color != null) {
            base.setColor(origin.color);
        }
        base.setInsertion(origin.insertion);
        if (origin.clickEvent != null) {
            base.setClickEvent(new ClickEvent(ClickEvent.Action.valueOf((String)origin.clickEvent.action.spigotName), origin.clickEvent.value));
        }
        if (origin.hoverEvent != null) {
            base.setHoverEvent(new HoverEvent(HoverEvent.Action.valueOf((String)origin.hoverEvent.action.spigotName), BungeeConverter.convert(ChatMessages.parse(origin.hoverEvent.value))));
        }
        if (origin.font != null && HAS_FONT_SUPPORT) {
            base.setFont(origin.font);
        }
        return base;
    }

    public static BaseComponent[] convert(List<MessageComponent> origins) {
        return BungeeConverter.convert(origins.toArray(new MessageComponent[0]));
    }

    public static BaseComponent[] convert(MessageComponent[] origins) {
        BaseComponent[] bases = new BaseComponent[origins.length];
        for (int i = 0; i < origins.length; ++i) {
            bases[i] = BungeeConverter.convert(origins[i]);
        }
        return bases;
    }
}

