/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.yggdrasil;

import ch.njol.yggdrasil.Tag;
import ch.njol.yggdrasil.Yggdrasil;
import ch.njol.yggdrasil.YggdrasilException;
import ch.njol.yggdrasil.YggdrasilSerializable;
import java.io.NotSerializableException;
import java.io.StreamCorruptedException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.jdt.annotation.Nullable;

@NotThreadSafe
public final class Fields
implements Iterable<FieldContext> {
    private final @Nullable Yggdrasil yggdrasil;
    private final Map<String, FieldContext> fields = new HashMap<String, FieldContext>();
    private static final Map<Class<?>, Collection<Field>> cache = new HashMap();

    public Fields() {
        this.yggdrasil = null;
    }

    public Fields(Yggdrasil yggdrasil) {
        this.yggdrasil = yggdrasil;
    }

    public Fields(Class<?> c, Yggdrasil yggdrasil) throws NotSerializableException {
        this.yggdrasil = yggdrasil;
        for (Field f : Fields.getFields(c)) {
            assert (f != null);
            String id = Yggdrasil.getID(f);
            this.fields.put(id, new FieldContext(id));
        }
    }

    public Fields(Object o) throws NotSerializableException {
        this(o, null);
    }

    public Fields(Object o, @Nullable Yggdrasil yggdrasil) throws NotSerializableException {
        this.yggdrasil = yggdrasil;
        Class<?> c = o.getClass();
        assert (c != null);
        for (Field f : Fields.getFields(c)) {
            assert (f != null);
            try {
                this.fields.put(Yggdrasil.getID(f), new FieldContext(f, o));
            }
            catch (IllegalArgumentException e) {
                assert (false);
            }
            catch (IllegalAccessException e) {
                assert (false);
            }
        }
    }

    public static Collection<Field> getFields(Class<?> c) throws NotSerializableException {
        Collection<Field> fields = cache.get(c);
        if (fields != null) {
            return fields;
        }
        fields = new ArrayList<Field>();
        HashSet<String> ids = new HashSet<String>();
        for (Class<?> sc = c; sc != null; sc = sc.getSuperclass()) {
            Field[] fs;
            for (Field f : fs = sc.getDeclaredFields()) {
                int m = f.getModifiers();
                if (Modifier.isStatic(m) || Modifier.isTransient(m)) continue;
                String id = Yggdrasil.getID(f);
                if (ids.contains(id)) {
                    throw new NotSerializableException(c + "/" + sc + ": duplicate field id '" + id + "'");
                }
                f.setAccessible(true);
                fields.add(f);
                ids.add(id);
            }
        }
        fields = Collections.unmodifiableCollection(fields);
        assert (fields != null);
        cache.put(c, fields);
        return fields;
    }

    public void setFields(Object o) throws StreamCorruptedException, NotSerializableException {
        Yggdrasil y = this.yggdrasil;
        if (y == null) {
            throw new YggdrasilException("");
        }
        HashSet<FieldContext> excessive = new HashSet<FieldContext>(this.fields.values());
        Class<?> oc = o.getClass();
        assert (oc != null);
        for (Field field : Fields.getFields(oc)) {
            assert (field != null);
            String id = Yggdrasil.getID(field);
            FieldContext c = this.fields.get(id);
            if (c == null) {
                if (!(o instanceof YggdrasilSerializable.YggdrasilRobustSerializable) || !((YggdrasilSerializable.YggdrasilRobustSerializable)o).missingField(field)) {
                    y.missingField(o, field);
                }
            } else {
                c.setField(o, field, y);
            }
            excessive.remove(c);
        }
        for (FieldContext fieldContext : excessive) {
            assert (fieldContext != null);
            if (o instanceof YggdrasilSerializable.YggdrasilRobustSerializable && ((YggdrasilSerializable.YggdrasilRobustSerializable)o).excessiveField(fieldContext)) continue;
            y.excessiveField(o, fieldContext);
        }
    }

    @Deprecated
    public void setFields(Object o, Yggdrasil y) throws StreamCorruptedException, NotSerializableException {
        assert (this.yggdrasil == y);
        this.setFields(o);
    }

    public int size() {
        return this.fields.size();
    }

    public void putObject(String fieldID, @Nullable Object value) {
        FieldContext c = this.fields.get(fieldID);
        if (c == null) {
            c = new FieldContext(fieldID);
            this.fields.put(fieldID, c);
        }
        c.setObject(value);
    }

    public void putPrimitive(String fieldID, Object value) {
        FieldContext c = this.fields.get(fieldID);
        if (c == null) {
            c = new FieldContext(fieldID);
            this.fields.put(fieldID, c);
        }
        c.setPrimitive(value);
    }

    public boolean contains(String fieldID) {
        return this.fields.containsKey(fieldID);
    }

    public boolean hasField(String fieldID) {
        return this.fields.containsKey(fieldID);
    }

    public @Nullable Object getObject(String field) throws StreamCorruptedException {
        FieldContext c = this.fields.get(field);
        if (c == null) {
            throw new StreamCorruptedException("Nonexistent field " + field);
        }
        return c.getObject();
    }

    public <T> @Nullable T getObject(String fieldID, Class<T> expectedType) throws StreamCorruptedException {
        assert (!expectedType.isPrimitive());
        FieldContext c = this.fields.get(fieldID);
        if (c == null) {
            throw new StreamCorruptedException("Nonexistent field " + fieldID);
        }
        return c.getObject(expectedType);
    }

    public Object getPrimitive(String fieldID) throws StreamCorruptedException {
        FieldContext c = this.fields.get(fieldID);
        if (c == null) {
            throw new StreamCorruptedException("Nonexistent field " + fieldID);
        }
        return c.getPrimitive();
    }

    public <T> T getPrimitive(String fieldID, Class<T> expectedType) throws StreamCorruptedException {
        assert (expectedType.isPrimitive() || Tag.getPrimitiveFromWrapper(expectedType).isPrimitive());
        FieldContext c = this.fields.get(fieldID);
        if (c == null) {
            throw new StreamCorruptedException("Nonexistent field " + fieldID);
        }
        return c.getPrimitive(expectedType);
    }

    public <T> @Nullable T getAndRemoveObject(String field, Class<T> expectedType) throws StreamCorruptedException {
        T t = this.getObject(field, expectedType);
        this.removeField(field);
        return t;
    }

    public <T> T getAndRemovePrimitive(String field, Class<T> expectedType) throws StreamCorruptedException {
        T t = this.getPrimitive(field, expectedType);
        this.removeField(field);
        return t;
    }

    public boolean removeField(String fieldID) {
        return this.fields.remove(fieldID) != null;
    }

    @Override
    public Iterator<FieldContext> iterator() {
        return this.fields.values().iterator();
    }

    @NotThreadSafe
    public static final class FieldContext {
        final String id;
        private @Nullable Object value;
        private boolean isPrimitiveValue;

        FieldContext(String id) {
            this.id = id;
        }

        FieldContext(Field f, Object o) throws IllegalArgumentException, IllegalAccessException {
            this.id = Yggdrasil.getID(f);
            this.value = f.get(o);
            this.isPrimitiveValue = f.getType().isPrimitive();
        }

        public String getID() {
            return this.id;
        }

        public boolean isPrimitive() {
            return this.isPrimitiveValue;
        }

        public @Nullable Class<?> getType() {
            Object value = this.value;
            if (value == null) {
                return null;
            }
            Class<?> c = value.getClass();
            assert (c != null);
            return this.isPrimitiveValue ? Tag.getPrimitiveFromWrapper(c).c : c;
        }

        public @Nullable Object getObject() throws StreamCorruptedException {
            if (this.isPrimitiveValue) {
                throw new StreamCorruptedException("field " + this.id + " is a primitive, but expected an object");
            }
            return this.value;
        }

        public <T> @Nullable T getObject(Class<T> expectedType) throws StreamCorruptedException {
            if (this.isPrimitiveValue) {
                throw new StreamCorruptedException("field " + this.id + " is a primitive, but expected " + expectedType);
            }
            Object value = this.value;
            if (value != null && !expectedType.isInstance(value)) {
                throw new StreamCorruptedException("Field " + this.id + " of " + value.getClass() + ", but expected " + expectedType);
            }
            return (T)value;
        }

        public Object getPrimitive() throws StreamCorruptedException {
            if (!this.isPrimitiveValue) {
                throw new StreamCorruptedException("field " + this.id + " is not a primitive, but expected one");
            }
            assert (this.value != null);
            return this.value;
        }

        public <T> T getPrimitive(Class<T> expectedType) throws StreamCorruptedException {
            if (!this.isPrimitiveValue) {
                throw new StreamCorruptedException("field " + this.id + " is not a primitive, but expected " + expectedType);
            }
            assert (expectedType.isPrimitive() || Tag.isWrapper(expectedType));
            Object value = this.value;
            assert (value != null);
            if (!(!expectedType.isPrimitive() ? expectedType.isInstance(value) : Tag.getWrapperClass(expectedType).isInstance(value))) {
                throw new StreamCorruptedException("Field " + this.id + " of " + value.getClass() + ", but expected " + expectedType);
            }
            return (T)value;
        }

        public void setObject(@Nullable Object value) {
            this.value = value;
            this.isPrimitiveValue = false;
        }

        public void setPrimitive(Object value) {
            assert (value != null && Tag.isWrapper(value.getClass()));
            this.value = value;
            this.isPrimitiveValue = true;
        }

        public void setField(Object o, Field f, Yggdrasil y) throws StreamCorruptedException {
            block7: {
                if (Modifier.isStatic(f.getModifiers())) {
                    throw new StreamCorruptedException("The field " + this.id + " of " + f.getDeclaringClass() + " is static");
                }
                if (Modifier.isTransient(f.getModifiers())) {
                    throw new StreamCorruptedException("The field " + this.id + " of " + f.getDeclaringClass() + " is transient");
                }
                if (f.getType().isPrimitive() != this.isPrimitiveValue) {
                    throw new StreamCorruptedException("The field " + this.id + " of " + f.getDeclaringClass() + " is " + (f.getType().isPrimitive() ? "" : "not ") + "primitive");
                }
                try {
                    f.setAccessible(true);
                    f.set(o, this.value);
                }
                catch (IllegalArgumentException e) {
                    if (!(o instanceof YggdrasilSerializable.YggdrasilRobustSerializable) || !((YggdrasilSerializable.YggdrasilRobustSerializable)o).incompatibleField(f, this)) {
                        y.incompatibleField(o, f, this);
                    }
                }
                catch (IllegalAccessException e) {
                    if ($assertionsDisabled) break block7;
                    throw new AssertionError();
                }
            }
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof FieldContext)) {
                return false;
            }
            FieldContext other = (FieldContext)obj;
            return this.id.equals(other.id);
        }
    }
}

