/*
 * Decompiled with CFR 0.152.
 */
package org.skriptlang.skript.lang.comparator;

import org.eclipse.jdt.annotation.Nullable;
import org.skriptlang.skript.lang.comparator.Comparator;
import org.skriptlang.skript.lang.comparator.Relation;
import org.skriptlang.skript.lang.converter.Converter;

final class ConvertedComparator<T1, T2, C1, C2>
implements Comparator<T1, T2> {
    private final Comparator<C1, C2> comparator;
    private final @Nullable Converter<T1, C1> firstConverter;
    private final @Nullable Converter<T2, C2> secondConverter;

    ConvertedComparator(@Nullable Converter<T1, C1> firstConverter, Comparator<C1, C2> c, @Nullable Converter<T2, C2> secondConverter) {
        if (firstConverter == null && secondConverter == null) {
            throw new IllegalArgumentException("firstConverter and secondConverter must not BOTH be null!");
        }
        this.firstConverter = firstConverter;
        this.comparator = c;
        this.secondConverter = secondConverter;
    }

    @Override
    public Relation compare(T1 o1, T2 o2) {
        T2 t2;
        T1 t1;
        Object object = t1 = this.firstConverter == null ? o1 : this.firstConverter.convert(o1);
        if (t1 == null) {
            return Relation.NOT_EQUAL;
        }
        Object object2 = t2 = this.secondConverter == null ? o2 : this.secondConverter.convert(o2);
        if (t2 == null) {
            return Relation.NOT_EQUAL;
        }
        return this.comparator.compare(t1, t2);
    }

    @Override
    public boolean supportsOrdering() {
        return this.comparator.supportsOrdering();
    }

    public String toString() {
        return "ConvertedComparator(" + this.firstConverter + "," + this.comparator + "," + this.secondConverter + ")";
    }
}

