/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.inventory.MainHand;

@Name(value="Left Handed")
@Description(value={"Checks if living entities or players are left or right-handed. Armor stands are neither right nor left-handed.", "Paper 1.17.1+ is required for non-player entities."})
@Examples(value={"on damage of player:", "\tif victim is left handed:", "\t\tcancel event"})
@Since(value="2.8.0")
@RequiredPlugins(value={"Paper 1.17.1+ (entities)"})
public class CondIsLeftHanded
extends PropertyCondition<LivingEntity> {
    private static final boolean CAN_USE_ENTITIES = Skript.methodExists(Mob.class, "isLeftHanded", new Class[0]);
    private MainHand hand;

    @Override
    public boolean init(Expression[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.hand = parseResult.hasTag("left") ? MainHand.LEFT : MainHand.RIGHT;
        return super.init(exprs, matchedPattern, isDelayed, parseResult);
    }

    @Override
    public boolean check(LivingEntity livingEntity) {
        if (CAN_USE_ENTITIES && livingEntity instanceof Mob) {
            return ((Mob)livingEntity).isLeftHanded() == (this.hand == MainHand.LEFT);
        }
        if (livingEntity instanceof HumanEntity) {
            return ((HumanEntity)livingEntity).getMainHand() == this.hand;
        }
        return false;
    }

    @Override
    protected String getPropertyName() {
        return (this.hand == MainHand.LEFT ? "left" : "right") + " handed";
    }

    static {
        if (CAN_USE_ENTITIES) {
            CondIsLeftHanded.register(CondIsLeftHanded.class, PropertyCondition.PropertyType.BE, "(:left|right)( |-)handed", "livingentities");
        } else {
            CondIsLeftHanded.register(CondIsLeftHanded.class, PropertyCondition.PropertyType.BE, "(:left|right)( |-)handed", "players");
        }
    }
}

