/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptConfig;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.ExprParse;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionList;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.log.CountingLogHandler;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.log.ParseLogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.Patterns;
import ch.njol.skript.util.Utils;
import ch.njol.util.Kleenean;
import java.util.Arrays;
import java.util.logging.Level;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;
import org.skriptlang.skript.lang.script.ScriptWarning;

@Name(value="Change: Set/Add/Remove/Delete/Reset")
@Description(value={"A very general effect that can change many <a href='./expressions'>expressions</a>. Many expressions can only be set and/or deleted, while some can have things added to or removed from them."})
@Examples(value={"# set:", "Set the player's display name to \"&lt;red&gt;%name of player%\"", "set the block above the victim to lava", "# add:", "add 2 to the player's health # preferably use '<a href='#EffHealth'>heal</a>' for this", "add argument to {blacklist::*}", "give a diamond pickaxe of efficiency 5 to the player", "increase the data value of the clicked block by 1", "# remove:", "remove 2 pickaxes from the victim", "subtract 2.5 from {points::%uuid of player%}", "# remove all:", "remove every iron tool from the player", "remove all minecarts from {entitylist::*}", "# delete:", "delete the block below the player", "clear drops", "delete {variable}", "# reset:", "reset walk speed of player", "reset chunk at the targeted block"})
@Since(value="1.0 (set, add, remove, delete), 2.0 (remove all)")
public class EffChange
extends Effect {
    private static Patterns<Changer.ChangeMode> patterns = new Patterns(new Object[][]{{"(add|give) %objects% to %~objects%", Changer.ChangeMode.ADD}, {"increase %~objects% by %objects%", Changer.ChangeMode.ADD}, {"give %~objects% %objects%", Changer.ChangeMode.ADD}, {"set %~objects% to %objects%", Changer.ChangeMode.SET}, {"remove (all|every) %objects% from %~objects%", Changer.ChangeMode.REMOVE_ALL}, {"(remove|subtract) %objects% from %~objects%", Changer.ChangeMode.REMOVE}, {"(reduce|decrease) %~objects% by %objects%", Changer.ChangeMode.REMOVE}, {"(delete|clear) %~objects%", Changer.ChangeMode.DELETE}, {"reset %~objects%", Changer.ChangeMode.RESET}});
    private Expression<?> changed;
    private @Nullable Expression<?> changer = null;
    private Changer.ChangeMode mode;
    private boolean single;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        String what;
        Object[] rs;
        this.mode = patterns.getInfo(matchedPattern);
        switch (this.mode) {
            case ADD: {
                if (matchedPattern == 0) {
                    this.changer = exprs[0];
                    this.changed = exprs[1];
                    break;
                }
                this.changer = exprs[1];
                this.changed = exprs[0];
                break;
            }
            case SET: {
                this.changer = exprs[1];
                this.changed = exprs[0];
                break;
            }
            case REMOVE_ALL: {
                this.changer = exprs[0];
                this.changed = exprs[1];
                break;
            }
            case REMOVE: {
                if (matchedPattern == 5) {
                    this.changer = exprs[0];
                    this.changed = exprs[1];
                    break;
                }
                this.changer = exprs[1];
                this.changed = exprs[0];
                break;
            }
            case DELETE: {
                this.changed = exprs[0];
                break;
            }
            case RESET: {
                this.changed = exprs[0];
            }
        }
        CountingLogHandler h = new CountingLogHandler(Level.SEVERE).start();
        try {
            rs = this.changed.acceptChange(this.mode);
            ClassInfo<?> c = Classes.getSuperClassInfo(this.changed.getReturnType());
            Changer<?> changer = c.getChanger();
            what = changer == null || !Arrays.equals(changer.acceptChange(this.mode), rs) ? this.changed.toString(null, false) : c.getName().withIndefiniteArticle();
        }
        finally {
            h.stop();
        }
        if (rs == null) {
            if (h.getCount() > 0) {
                return false;
            }
            switch (this.mode) {
                case SET: {
                    Skript.error(what + " can't be set to anything", ErrorQuality.SEMANTIC_ERROR);
                    break;
                }
                case DELETE: {
                    if (this.changed.acceptChange(Changer.ChangeMode.RESET) != null) {
                        Skript.error(what + " can't be deleted/cleared. It can however be reset which might result in the desired effect.", ErrorQuality.SEMANTIC_ERROR);
                        break;
                    }
                    Skript.error(what + " can't be deleted/cleared", ErrorQuality.SEMANTIC_ERROR);
                    break;
                }
                case REMOVE_ALL: {
                    if (this.changed.acceptChange(Changer.ChangeMode.REMOVE) != null) {
                        Skript.error(what + " can't have 'all of something' removed from it. Use 'remove' instead of 'remove all' to fix this.", ErrorQuality.SEMANTIC_ERROR);
                        break;
                    }
                }
                case ADD: 
                case REMOVE: {
                    Skript.error(what + " can't have anything " + (this.mode == Changer.ChangeMode.ADD ? "added to" : "removed from") + " it", ErrorQuality.SEMANTIC_ERROR);
                    break;
                }
                case RESET: {
                    if (this.changed.acceptChange(Changer.ChangeMode.DELETE) != null) {
                        Skript.error(what + " can't be reset. It can however be deleted which might result in the desired effect.", ErrorQuality.SEMANTIC_ERROR);
                        break;
                    }
                    Skript.error(what + " can't be reset", ErrorQuality.SEMANTIC_ERROR);
                }
            }
            return false;
        }
        Object[] rs2 = new Class[rs.length];
        for (int i = 0; i < rs.length; ++i) {
            rs2[i] = ((Class)rs[i]).isArray() ? ((Class)rs[i]).getComponentType() : rs[i];
        }
        boolean allSingle = Arrays.equals(rs, rs2);
        Expression<Object> ch = this.changer;
        if (ch != null) {
            ClassInfo<Object> ci;
            int i;
            Expression v = null;
            ParseLogHandler log = SkriptLogger.startParseLogHandler();
            try {
                for (Class<?> clazz : rs) {
                    log.clear();
                    if (!(clazz.isArray() ? clazz.getComponentType() : clazz).isAssignableFrom(ch.getReturnType())) continue;
                    v = ch.getConvertedExpression(Object.class);
                    break;
                }
                if (v == null) {
                    v = ch.getConvertedExpression((Class<R>[])rs2);
                }
                if (v == null) {
                    if (log.hasError()) {
                        log.printError();
                        boolean bl = false;
                        return bl;
                    }
                    log.clear();
                    log.stop();
                    Class[] r = new Class[rs.length];
                    for (i = 0; i < rs.length; i += 1) {
                        r[i] = ((Class)rs[i]).isArray() ? ((Class)rs[i]).getComponentType() : rs[i];
                    }
                    if (r.length == 1 && r[0] == Object.class) {
                        Skript.error("Can't understand this expression: " + this.changer, ErrorQuality.NOT_AN_EXPRESSION);
                    } else if (this.mode == Changer.ChangeMode.SET) {
                        Skript.error(what + " can't be set to " + this.changer + " because the latter is " + SkriptParser.notOfType(r), ErrorQuality.SEMANTIC_ERROR);
                    } else {
                        Skript.error(this.changer + " can't be " + (this.mode == Changer.ChangeMode.ADD ? "added to" : "removed from") + " " + what + " because the former is " + SkriptParser.notOfType(r), ErrorQuality.SEMANTIC_ERROR);
                    }
                    log.printError();
                    i = 0;
                    return i != 0;
                }
                log.printLog();
            }
            finally {
                log.stop();
            }
            Object x = Utils.getSuperType(rs2);
            this.single = allSingle;
            for (i = 0; i < rs.length; i += 1) {
                if (!((Class)rs2[i]).isAssignableFrom(v.getReturnType())) continue;
                this.single = !((Class)rs[i]).isArray();
                x = rs2[i];
                break;
            }
            assert (x != null);
            ch = v;
            this.changer = ch;
            if (!ch.isSingle() && this.single) {
                if (this.mode == Changer.ChangeMode.SET) {
                    Skript.error(this.changed + " can only be set to one " + Classes.getSuperClassInfo(x).getName() + ", not more", ErrorQuality.SEMANTIC_ERROR);
                } else {
                    Skript.error("only one " + Classes.getSuperClassInfo(x).getName() + " can be " + (this.mode == Changer.ChangeMode.ADD ? "added to" : "removed from") + " " + this.changed + ", not more", ErrorQuality.SEMANTIC_ERROR);
                }
                return false;
            }
            if (this.changed instanceof Variable && !this.changed.isSingle() && this.mode == Changer.ChangeMode.SET) {
                if (ch instanceof ExprParse) {
                    ((ExprParse)ch).flatten = false;
                } else if (ch instanceof ExpressionList) {
                    void var16_23;
                    Expression<T>[] i2 = ((ExpressionList)ch).getExpressions();
                    int n = i2.length;
                    boolean bl = false;
                    while (var16_23 < n) {
                        Expression expression = i2[var16_23];
                        if (expression instanceof ExprParse) {
                            ((ExprParse)expression).flatten = false;
                        }
                        ++var16_23;
                    }
                }
            }
            if (this.changed instanceof Variable && !((Variable)this.changed).isLocal() && (this.mode == Changer.ChangeMode.SET || ((Variable)this.changed).isList() && this.mode == Changer.ChangeMode.ADD) && (ci = Classes.getSuperClassInfo(ch.getReturnType())).getC() != Object.class && ci.getSerializer() == null && ci.getSerializeAs() == null && !SkriptConfig.disableObjectCannotBeSavedWarnings.value().booleanValue() && this.getParser().isActive() && !this.getParser().getCurrentScript().suppressesWarning(ScriptWarning.VARIABLE_SAVE)) {
                Skript.warning(ci.getName().withIndefiniteArticle() + " cannot be saved, i.e. the contents of the variable " + this.changed + " will be lost when the server stops.");
            }
        }
        return true;
    }

    @Override
    protected void execute(Event e) {
        Object[] delta = this.changer == null ? null : this.changer.getArray(e);
        Object[] objectArray = delta = this.changer == null ? delta : this.changer.beforeChange(this.changed, delta);
        if ((delta == null || delta.length == 0) && this.mode != Changer.ChangeMode.DELETE && this.mode != Changer.ChangeMode.RESET) {
            if (this.mode == Changer.ChangeMode.SET && this.changed.acceptChange(Changer.ChangeMode.DELETE) != null) {
                this.changed.change(e, null, Changer.ChangeMode.DELETE);
            }
            return;
        }
        this.changed.change(e, delta, this.mode);
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        Expression<?> changer = this.changer;
        switch (this.mode) {
            case ADD: {
                assert (changer != null);
                return "add " + changer.toString(e, debug) + " to " + this.changed.toString(e, debug);
            }
            case SET: {
                assert (changer != null);
                return "set " + this.changed.toString(e, debug) + " to " + changer.toString(e, debug);
            }
            case REMOVE: {
                assert (changer != null);
                return "remove " + changer.toString(e, debug) + " from " + this.changed.toString(e, debug);
            }
            case REMOVE_ALL: {
                assert (changer != null);
                return "remove all " + changer.toString(e, debug) + " from " + this.changed.toString(e, debug);
            }
            case DELETE: {
                return "delete/clear " + this.changed.toString(e, debug);
            }
            case RESET: {
                return "reset " + this.changed.toString(e, debug);
            }
        }
        assert (false);
        return "";
    }

    static {
        Skript.registerEffect(EffChange.class, patterns.getPatterns());
    }
}

