/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.VariableString;
import ch.njol.skript.util.StringMode;
import ch.njol.skript.util.Utils;
import ch.njol.util.Kleenean;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Command")
@Description(value={"Executes a command. This can be useful to use other plugins in triggers.", "If the command is a bungeecord side command, you can use the [bungeecord] option to execute command on the proxy."})
@Examples(value={"make player execute command \"/home\"", "execute console command \"/say Hello everyone!\"", "execute player bungeecord command \"/alert &6Testing Announcement!\""})
@Since(value="1.0, 2.8.0 (bungeecord command)")
public class EffCommand
extends Effect {
    public static final String MESSAGE_CHANNEL = "Message";
    private @Nullable Expression<CommandSender> senders;
    private Expression<String> commands;
    private boolean bungeecord;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (matchedPattern == 0) {
            this.commands = exprs[0];
            this.senders = exprs[1];
        } else {
            this.senders = exprs[0];
            this.commands = exprs[1];
        }
        this.bungeecord = parseResult.hasTag("bungee");
        if (this.bungeecord && this.senders == null) {
            Skript.error("The commandsenders expression cannot be omitted when using the bungeecord option");
            return false;
        }
        this.commands = VariableString.setStringMode(this.commands, StringMode.COMMAND);
        return true;
    }

    @Override
    public void execute(Event event) {
        for (String command : this.commands.getArray(event)) {
            assert (command != null);
            if (command.startsWith("/")) {
                command = "" + command.substring(1);
            }
            if (this.senders != null) {
                for (CommandSender sender : this.senders.getArray(event)) {
                    if (this.bungeecord) {
                        if (!(sender instanceof Player)) continue;
                        Player player = (Player)sender;
                        Utils.sendPluginMessage(player, "BungeeCord", MESSAGE_CHANNEL, player.getName(), "/" + command);
                        continue;
                    }
                    Skript.dispatchCommand(sender, command);
                }
                continue;
            }
            Skript.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), command);
        }
    }

    @Override
    public String toString(@Nullable Event event, boolean debug) {
        return "make " + (this.senders != null ? this.senders.toString(event, debug) : "the console") + " execute " + (this.bungeecord ? "bungeecord " : "") + "command " + this.commands.toString(event, debug);
    }

    static {
        Skript.registerEffect(EffCommand.class, "[execute] [the] [bungee:bungee[cord]] command[s] %strings% [by %-commandsenders%]", "[execute] [the] %commandsenders% [bungee:bungee[cord]] command[s] %strings%", "(let|make) %commandsenders% execute [[the] [bungee:bungee[cord]] command[s]] %strings%");
    }
}

