/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.LoopSection;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.lang.TriggerSection;
import ch.njol.skript.lang.function.FunctionEvent;
import ch.njol.skript.lang.function.Functions;
import ch.njol.skript.lang.function.ScriptFunction;
import ch.njol.skript.log.RetainingLogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Return")
@Description(value={"Makes a function return a value"})
@Examples(value={"function double(i: number) :: number:", "\treturn 2 * {_i}", "", "function divide(i: number) returns number:", "\treturn {_i} / 2"})
@Since(value="2.2, 2.8.0 (returns aliases)")
public class EffReturn
extends Effect {
    private ScriptFunction<?> function;
    private Expression<?> value;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        Expression convertedExpr;
        ScriptFunction<?> f = Functions.currentFunction;
        if (f == null) {
            Skript.error("The return statement can only be used in a function");
            return false;
        }
        if (!isDelayed.isFalse()) {
            Skript.error("A return statement after a delay is useless, as the calling trigger will resume when the delay starts (and won't get any returned value)");
            return false;
        }
        this.function = f;
        ClassInfo returnType = this.function.getReturnType();
        if (returnType == null) {
            Skript.error("This function doesn't return any value. Please use 'stop' or 'exit' if you want to stop the function.");
            return false;
        }
        RetainingLogHandler log = SkriptLogger.startRetainingLog();
        try {
            convertedExpr = exprs[0].getConvertedExpression(returnType.getC());
            if (convertedExpr == null) {
                log.printErrors("This function is declared to return " + returnType.getName().withIndefiniteArticle() + ", but " + exprs[0].toString(null, false) + " is not of that type.");
                boolean bl = false;
                return bl;
            }
            log.printLog();
        }
        finally {
            log.stop();
        }
        if (f.isSingle() && !convertedExpr.isSingle()) {
            Skript.error("This function is defined to only return a single " + returnType.toString() + ", but this return statement can return multiple values.");
            return false;
        }
        this.value = convertedExpr;
        return true;
    }

    @Override
    protected @Nullable TriggerItem walk(Event event) {
        this.debug(event, false);
        if (event instanceof FunctionEvent) {
            this.function.setReturnValue(this.value.getArray(event));
        } else assert (false) : event;
        for (TriggerSection parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof LoopSection)) continue;
            ((LoopSection)parent).exit(event);
        }
        return null;
    }

    @Override
    protected void execute(Event event) {
        assert (false);
    }

    @Override
    public String toString(@Nullable Event event, boolean debug) {
        return "return " + this.value.toString(event, debug);
    }

    static {
        Skript.registerEffect(EffReturn.class, "return %objects%");
    }
}

