/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Openable;
import org.bukkit.block.data.Powerable;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Toggle")
@Description(value={"Toggle the state of a block."})
@Examples(value={"# use arrows to toggle switches, doors, etc.", "on projectile hit:", "\tprojectile is arrow", "\ttoggle the block at the arrow"})
@Since(value="1.4")
public class EffToggle
extends Effect {
    private Expression<Block> blocks;
    private int toggle;

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.blocks = vars[0];
        this.toggle = matchedPattern - 1;
        return true;
    }

    @Override
    protected void execute(Event e) {
        for (Block b : this.blocks.getArray(e)) {
            BlockData data = b.getBlockData();
            if (this.toggle == -1) {
                if (data instanceof Openable) {
                    ((Openable)data).setOpen(false);
                } else if (data instanceof Powerable) {
                    ((Powerable)data).setPowered(false);
                }
            } else if (this.toggle == 1) {
                if (data instanceof Openable) {
                    ((Openable)data).setOpen(true);
                } else if (data instanceof Powerable) {
                    ((Powerable)data).setPowered(true);
                }
            } else if (data instanceof Openable) {
                ((Openable)data).setOpen(!((Openable)data).isOpen());
            } else if (data instanceof Powerable) {
                ((Powerable)data).setPowered(!((Powerable)data).isPowered());
            }
            b.setBlockData(data);
        }
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "toggle " + this.blocks.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffToggle.class, "(close|turn off|de[-]activate) %blocks%", "(toggle|switch) [[the] state of] %blocks%", "(open|turn on|activate) %blocks%");
    }
}

