/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.entity;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAPIException;
import ch.njol.skript.bukkitutil.EntityUtils;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.classes.Serializer;
import ch.njol.skript.entity.SimpleEntityData;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.SyntaxElement;
import ch.njol.skript.lang.SyntaxElementInfo;
import ch.njol.skript.lang.util.SimpleLiteral;
import ch.njol.skript.localization.Adjective;
import ch.njol.skript.localization.Language;
import ch.njol.skript.localization.LanguageChangeListener;
import ch.njol.skript.localization.Message;
import ch.njol.skript.localization.Noun;
import ch.njol.skript.registrations.Classes;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import ch.njol.util.coll.iterator.SingleItemIterator;
import ch.njol.yggdrasil.Fields;
import ch.njol.yggdrasil.YggdrasilSerializable;
import java.io.NotSerializableException;
import java.io.StreamCorruptedException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.RegionAccessor;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.util.Consumer;
import org.eclipse.jdt.annotation.Nullable;

public abstract class EntityData<E extends Entity>
implements SyntaxElement,
YggdrasilSerializable.YggdrasilExtendedSerializable {
    protected static @Nullable Method WORLD_1_13_CONSUMER_METHOD;
    protected static final boolean WORLD_1_13_CONSUMER;
    protected static @Nullable Method WORLD_1_17_CONSUMER_METHOD;
    protected static boolean WORLD_1_17_CONSUMER;
    public static final String LANGUAGE_NODE = "entities";
    public static final Message m_age_pattern;
    public static final Adjective m_baby;
    public static final Adjective m_adult;
    private static final List<EntityDataInfo<EntityData<?>>> infos;
    private static final Pattern REGEX_PATTERN;
    private static final List<EntityData> ALL_ENTITY_DATAS;
    public static Serializer<EntityData> serializer;
    transient EntityDataInfo<?> info;
    protected int matchedPattern = 0;
    private Kleenean plural = Kleenean.UNKNOWN;
    private Kleenean baby = Kleenean.UNKNOWN;

    public static void onRegistrationStop() {
        infos.forEach(info -> {
            if (SimpleEntityData.class.equals(info.getElementClass())) {
                ALL_ENTITY_DATAS.addAll(Arrays.stream(info.codeNames).map(input -> (EntityData)SkriptParser.parseStatic(input, new SingleItemIterator<EntityDataInfo>((EntityDataInfo)info), null)).collect(Collectors.toList()));
            } else {
                ALL_ENTITY_DATAS.add((EntityData)SkriptParser.parseStatic(info.codeName, new SingleItemIterator<EntityDataInfo>((EntityDataInfo)info), null));
            }
        });
    }

    public static <E extends Entity, T extends EntityData<E>> void register(Class<T> dataClass, String name, Class<E> entityClass, String codeName) throws IllegalArgumentException {
        EntityData.register(dataClass, name, entityClass, 0, codeName);
    }

    public static <E extends Entity, T extends EntityData<E>> void register(Class<T> dataClass, String name, Class<E> entityClass, int defaultName, String ... codeNames) throws IllegalArgumentException {
        EntityDataInfo<T> info = new EntityDataInfo<T>(dataClass, name, codeNames, defaultName, entityClass);
        for (int i = 0; i < infos.size(); ++i) {
            if (!EntityData.infos.get((int)i).entityClass.isAssignableFrom(entityClass)) continue;
            infos.add(i, info);
            return;
        }
        infos.add(info);
    }

    public EntityData() {
        for (EntityDataInfo<EntityData<?>> i : infos) {
            if (this.getClass() != i.getElementClass()) continue;
            this.info = i;
            this.matchedPattern = i.defaultName;
            return;
        }
        throw new IllegalStateException();
    }

    @Override
    public final boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.matchedPattern = matchedPattern;
        int pluralBits = parseResult.mark & 3;
        this.plural = pluralBits == 1 ? Kleenean.TRUE : (pluralBits == 0 ? Kleenean.FALSE : Kleenean.UNKNOWN);
        int ageBits = parseResult.mark & 0xC;
        this.baby = ageBits == 4 ? Kleenean.TRUE : (ageBits == 8 ? Kleenean.FALSE : Kleenean.UNKNOWN);
        return this.init((Literal[])Arrays.copyOf(exprs, exprs.length, Literal[].class), matchedPattern, parseResult);
    }

    protected abstract boolean init(Literal<?>[] var1, int var2, SkriptParser.ParseResult var3);

    protected abstract boolean init(@Nullable Class<? extends E> var1, @Nullable E var2);

    public abstract void set(E var1);

    protected abstract boolean match(E var1);

    public abstract Class<? extends E> getType();

    public abstract EntityData getSuperType();

    public final String toString() {
        return this.toString(0);
    }

    protected Noun getName() {
        return this.info.names[this.matchedPattern];
    }

    protected @Nullable Adjective getAgeAdjective() {
        return this.baby.isTrue() ? m_baby : (this.baby.isFalse() ? m_adult : null);
    }

    public String toString(int flags) {
        Noun name = this.info.names[this.matchedPattern];
        return this.baby.isTrue() ? m_baby.toString(name, flags) : (this.baby.isFalse() ? m_adult.toString(name, flags) : name.toString(flags));
    }

    public Kleenean isPlural() {
        return this.plural;
    }

    public Kleenean isBaby() {
        return this.baby;
    }

    protected abstract int hashCode_i();

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.baby.hashCode();
        result = 31 * result + this.plural.hashCode();
        result = 31 * result + this.matchedPattern;
        result = 31 * result + this.info.hashCode();
        result = 31 * result + this.hashCode_i();
        return result;
    }

    protected abstract boolean equals_i(EntityData<?> var1);

    public final boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntityData)) {
            return false;
        }
        EntityData other = (EntityData)obj;
        if (this.baby != other.baby) {
            return false;
        }
        if (this.plural != other.plural) {
            return false;
        }
        if (this.matchedPattern != other.matchedPattern) {
            return false;
        }
        if (!this.info.equals(other.info)) {
            return false;
        }
        return this.equals_i(other);
    }

    public static EntityDataInfo<?> getInfo(Class<? extends EntityData<?>> c) {
        for (EntityDataInfo<EntityData<?>> i : infos) {
            if (i.getElementClass() != c) continue;
            return i;
        }
        throw new SkriptAPIException("Unregistered EntityData class " + c.getName());
    }

    public static @Nullable EntityDataInfo<?> getInfo(String codeName) {
        for (EntityDataInfo<EntityData<?>> i : infos) {
            if (!i.codeName.equals(codeName)) continue;
            return i;
        }
        return null;
    }

    public static @Nullable EntityData<?> parse(String s) {
        if (!REGEX_PATTERN.matcher(s).matches()) {
            return null;
        }
        Iterator<EntityDataInfo<EntityData<?>>> it = infos.iterator();
        return SkriptParser.parseStatic(Noun.stripIndefiniteArticle(s), it, null);
    }

    public static @Nullable EntityData<?> parseWithoutIndefiniteArticle(String s) {
        if (!REGEX_PATTERN.matcher(s).matches()) {
            return null;
        }
        Iterator<EntityDataInfo<EntityData<?>>> it = infos.iterator();
        return SkriptParser.parseStatic(s, it, null);
    }

    private E apply(E entity) {
        if (this.baby.isTrue()) {
            EntityUtils.setBaby(entity);
        } else if (this.baby.isFalse()) {
            EntityUtils.setAdult(entity);
        }
        this.set(entity);
        return entity;
    }

    public final @Nullable E spawn(Location location) {
        return this.spawn(location, (java.util.function.Consumer)null);
    }

    @Deprecated
    public @Nullable E spawn(Location location, @Nullable Consumer<E> consumer) {
        return (E)this.spawn(location, (E e) -> consumer.accept(e));
    }

    public @Nullable E spawn(Location location, @Nullable java.util.function.Consumer<E> consumer) {
        assert (location != null);
        if (consumer != null) {
            return (E)EntityData.spawn(location, this.getType(), e -> consumer.accept(this.apply(e)));
        }
        return (E)this.apply(location.getWorld().spawn(location, this.getType()));
    }

    public E[] getAll(World ... worlds) {
        assert (worlds != null && worlds.length > 0) : Arrays.toString(worlds);
        ArrayList<Entity> list = new ArrayList<Entity>();
        for (World w : worlds) {
            for (Entity e : w.getEntitiesByClass(this.getType())) {
                if (!this.match(e)) continue;
                list.add(e);
            }
        }
        return list.toArray((Entity[])Array.newInstance(this.getType(), list.size()));
    }

    public static <E extends Entity> E[] getAll(EntityData<?>[] types, Class<E> type, @Nullable World[] worlds) {
        assert (types.length > 0);
        if (type == Player.class) {
            if (worlds == null) {
                return (Entity[])Bukkit.getOnlinePlayers().toArray(new Player[0]);
            }
            ArrayList<Player> list = new ArrayList<Player>();
            for (Player p : Bukkit.getOnlinePlayers()) {
                if (!CollectionUtils.contains(worlds, p.getWorld())) continue;
                list.add(p);
            }
            return (Entity[])list.toArray(new Player[list.size()]);
        }
        ArrayList<Entity> list = new ArrayList<Entity>();
        if (worlds == null) {
            worlds = Bukkit.getWorlds().toArray(new World[0]);
        }
        for (World w : worlds) {
            block2: for (Entity e : w.getEntitiesByClass(type)) {
                for (EntityData<?> t : types) {
                    if (!t.isInstance(e)) continue;
                    list.add(e);
                    continue block2;
                }
            }
        }
        return list.toArray((Entity[])Array.newInstance(type, list.size()));
    }

    public static <E extends Entity> E[] getAll(EntityData<?>[] types, Class<E> type, Chunk[] chunks) {
        assert (types.length > 0);
        ArrayList<Entity> list = new ArrayList<Entity>();
        for (Chunk chunk : chunks) {
            block1: for (Entity entity : chunk.getEntities()) {
                for (EntityData<?> t : types) {
                    if (!t.isInstance(entity)) continue;
                    list.add(entity);
                    continue block1;
                }
            }
        }
        return list.toArray((Entity[])Array.newInstance(type, list.size()));
    }

    private static <E extends Entity> EntityData<? super E> getData(@Nullable Class<E> c, @Nullable E e) {
        assert (c == null ^ e == null);
        assert (c == null || c.isInterface());
        for (EntityDataInfo<EntityData<?>> info : infos) {
            if (info.entityClass == Entity.class || !(e == null ? info.entityClass.isAssignableFrom(c) : info.entityClass.isInstance(e))) continue;
            try {
                EntityData d = (EntityData)info.getElementClass().newInstance();
                if (!d.init(c, e)) continue;
                return d;
            }
            catch (Exception ex) {
                throw Skript.exception((Throwable)ex, new String[0]);
            }
        }
        if (e != null) {
            return new SimpleEntityData(e);
        }
        assert (c != null);
        return new SimpleEntityData(c);
    }

    public static <E extends Entity> EntityData<? super E> fromClass(Class<E> c) {
        return EntityData.getData(c, null);
    }

    public static <E extends Entity> EntityData<? super E> fromEntity(E e) {
        return EntityData.getData(null, e);
    }

    public static String toString(Entity e) {
        return EntityData.fromEntity(e).getSuperType().toString();
    }

    public static String toString(Class<? extends Entity> c) {
        return EntityData.fromClass(c).getSuperType().toString();
    }

    public static String toString(Entity e, int flags) {
        return EntityData.fromEntity(e).getSuperType().toString(flags);
    }

    public static String toString(Class<? extends Entity> c, int flags) {
        return EntityData.fromClass(c).getSuperType().toString(flags);
    }

    public final boolean isInstance(@Nullable Entity e) {
        if (e == null) {
            return false;
        }
        if (!this.baby.isUnknown() && EntityUtils.isAgeable(e) && EntityUtils.isAdult(e) != this.baby.isFalse()) {
            return false;
        }
        return this.getType().isInstance(e) && this.match(e);
    }

    public abstract boolean isSupertypeOf(EntityData<?> var1);

    @Override
    public Fields serialize() throws NotSerializableException {
        return new Fields(this);
    }

    @Override
    public void deserialize(Fields fields) throws StreamCorruptedException, NotSerializableException {
        fields.setFields(this);
    }

    @Deprecated
    protected boolean deserialize(String s) {
        return false;
    }

    protected static <E extends Entity> @Nullable E spawn(Location location, Class<E> type, java.util.function.Consumer<E> consumer) {
        try {
            if (WORLD_1_17_CONSUMER) {
                Object[] objectArray = new Object[3];
                objectArray[0] = location;
                objectArray[1] = type;
                objectArray[2] = consumer::accept;
                return (E)((Entity)WORLD_1_17_CONSUMER_METHOD.invoke((Object)location.getWorld(), objectArray));
            }
            if (WORLD_1_13_CONSUMER) {
                Object[] objectArray = new Object[3];
                objectArray[0] = location;
                objectArray[1] = type;
                objectArray[2] = consumer::accept;
                return (E)((Entity)WORLD_1_13_CONSUMER_METHOD.invoke((Object)location.getWorld(), objectArray));
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            if (Skript.testing()) {
                Skript.exception((Throwable)e, "Can't spawn " + type.getName());
            }
            return null;
        }
        return (E)location.getWorld().spawn(location, type, consumer);
    }

    static {
        WORLD_1_13_CONSUMER = Skript.methodExists(World.class, "spawn", Location.class, Class.class, Consumer.class);
        try {
            if (WORLD_1_13_CONSUMER) {
                WORLD_1_13_CONSUMER_METHOD = World.class.getDeclaredMethod("spawn", Location.class, Class.class, Consumer.class);
            } else if (Skript.classExists("org.bukkit.RegionAccessor") && (WORLD_1_17_CONSUMER = Skript.methodExists(RegionAccessor.class, "spawn", Location.class, Class.class, Consumer.class))) {
                WORLD_1_17_CONSUMER_METHOD = RegionAccessor.class.getDeclaredMethod("spawn", Location.class, Class.class, Consumer.class);
            }
        }
        catch (NoSuchMethodException | SecurityException exception) {
            // empty catch block
        }
        m_age_pattern = new Message("entities.age pattern");
        m_baby = new Adjective("entities.age adjectives.baby");
        m_adult = new Adjective("entities.age adjectives.adult");
        infos = new ArrayList();
        REGEX_PATTERN = Pattern.compile("[a-zA-Z -]+");
        ALL_ENTITY_DATAS = new ArrayList<EntityData>();
        serializer = new Serializer<EntityData>(){

            @Override
            public Fields serialize(EntityData o) throws NotSerializableException {
                Fields f = o.serialize();
                f.putObject("codeName", o.info.codeName);
                return f;
            }

            @Override
            public boolean canBeInstantiated() {
                return false;
            }

            @Override
            public void deserialize(EntityData o, Fields f) throws StreamCorruptedException {
                assert (false);
            }

            @Override
            protected EntityData deserialize(Fields fields) throws StreamCorruptedException, NotSerializableException {
                String codeName = fields.getAndRemoveObject("codeName", String.class);
                if (codeName == null) {
                    throw new StreamCorruptedException();
                }
                EntityDataInfo<?> info = EntityData.getInfo(codeName);
                if (info == null) {
                    throw new StreamCorruptedException("Invalid EntityData code name " + codeName);
                }
                try {
                    EntityData d = (EntityData)info.getElementClass().newInstance();
                    d.deserialize(fields);
                    return d;
                }
                catch (InstantiationException e) {
                    Skript.exception((Throwable)e, new String[0]);
                }
                catch (IllegalAccessException e) {
                    Skript.exception((Throwable)e, new String[0]);
                }
                throw new StreamCorruptedException();
            }

            @Override
            @Deprecated
            public @Nullable EntityData deserialize(String s) {
                EntityData d;
                String[] split = s.split(":", 2);
                if (split.length != 2) {
                    return null;
                }
                EntityDataInfo<?> i = EntityData.getInfo(split[0]);
                if (i == null) {
                    return null;
                }
                try {
                    d = (EntityData)i.getElementClass().newInstance();
                }
                catch (Exception e) {
                    Skript.exception((Throwable)e, "Can't create an instance of " + i.getElementClass().getCanonicalName());
                    return null;
                }
                if (!d.deserialize(split[1])) {
                    return null;
                }
                return d;
            }

            @Override
            public boolean mustSyncDeserialization() {
                return false;
            }
        };
        Classes.registerClass(new ClassInfo<EntityData>(EntityData.class, "entitydata").user("entity ?types?").name("Entity Type").description("The type of an <a href='#entity'>entity</a>, e.g. player, wolf, powered creeper, etc.").usage("<i>Detailed usage will be added eventually</i>").examples("victim is a cow", "spawn a creeper").since("1.3").defaultExpression(new SimpleLiteral<SimpleEntityData>(new SimpleEntityData(Entity.class), true)).before("entitytype").supplier(ALL_ENTITY_DATAS::iterator).parser((Parser<SimpleEntityData>)new Parser<EntityData>(){

            @Override
            public String toString(EntityData d, int flags) {
                return d.toString(flags);
            }

            @Override
            public @Nullable EntityData parse(String s, ParseContext context) {
                return EntityData.parse(s);
            }

            @Override
            public String toVariableNameString(EntityData o) {
                return "entitydata:" + o.toString();
            }
        }).serializer(serializer));
    }

    private static final class EntityDataInfo<T extends EntityData<?>>
    extends SyntaxElementInfo<T>
    implements LanguageChangeListener {
        final String codeName;
        final String[] codeNames;
        final int defaultName;
        final Class<? extends Entity> entityClass;
        final Noun[] names;

        public EntityDataInfo(Class<T> dataClass, String codeName, String[] codeNames, int defaultName, Class<? extends Entity> entityClass) throws IllegalArgumentException {
            super(new String[codeNames.length], dataClass, dataClass.getName());
            assert (codeName != null && entityClass != null && codeNames.length > 0);
            this.codeName = codeName;
            this.codeNames = codeNames;
            this.defaultName = defaultName;
            this.entityClass = entityClass;
            this.names = new Noun[codeNames.length];
            for (int i = 0; i < codeNames.length; ++i) {
                assert (codeNames[i] != null);
                this.names[i] = new Noun("entities." + codeNames[i] + ".name");
            }
            Language.addListener(this, Language.LanguageListenerPriority.LATEST);
        }

        @Override
        public void onLanguageChange() {
            for (int i = 0; i < this.codeNames.length; ++i) {
                this.patterns[i] = Language.get("entities." + this.codeNames[i] + ".pattern").replace("<age>", m_age_pattern.toString());
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.codeName.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof EntityDataInfo)) {
                return false;
            }
            EntityDataInfo other = (EntityDataInfo)obj;
            if (!this.codeName.equals(other.codeName)) {
                return false;
            }
            assert (Arrays.equals(this.codeNames, other.codeNames));
            assert (this.defaultName == other.defaultName);
            assert (this.entityClass == other.entityClass);
            return true;
        }
    }
}

