/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.entity;

import ch.njol.skript.Skript;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.entity.Cod;
import org.bukkit.entity.Fish;
import org.bukkit.entity.PufferFish;
import org.bukkit.entity.Salmon;
import org.bukkit.entity.Tadpole;
import org.bukkit.entity.TropicalFish;
import org.eclipse.jdt.annotation.Nullable;

public class FishData
extends EntityData<Fish> {
    private static final boolean HAS_TADPOLE = Skript.classExists("org.bukkit.entity.Tadpole");
    private static final List<String> PATTERNS = new ArrayList<String>(Arrays.asList("fish", "cod", "puffer fish", "salmon", "tropical fish"));
    private boolean init = true;
    private boolean wildcard = false;
    private int pattern = -1;

    public FishData() {
    }

    public FishData(int pattern) {
        this.pattern = pattern;
        this.matchedPattern = pattern;
    }

    @Override
    protected boolean init(Literal<?>[] exprs, int matchedPattern, SkriptParser.ParseResult parseResult) {
        if (matchedPattern == 0) {
            this.wildcard = true;
        }
        this.pattern = matchedPattern == 0 ? ThreadLocalRandom.current().nextInt(1, PATTERNS.size()) : matchedPattern;
        return true;
    }

    @Override
    protected boolean init(@Nullable Class<? extends Fish> c, @Nullable Fish e) {
        int matchedPattern = FishData.getInitPattern(e);
        if (matchedPattern == 0) {
            this.wildcard = true;
        }
        this.pattern = matchedPattern == 0 ? ThreadLocalRandom.current().nextInt(1, PATTERNS.size()) : matchedPattern;
        return true;
    }

    @Override
    public void set(Fish entity) {
    }

    @Override
    protected boolean match(Fish entity) {
        return this.wildcard ? true : this.getPattern(entity) == this.pattern;
    }

    @Override
    public Class<? extends Fish> getType() {
        if (!this.init && this.wildcard) {
            return Fish.class;
        }
        this.init = false;
        switch (this.pattern) {
            case 1: {
                return Cod.class;
            }
            case 2: {
                return PufferFish.class;
            }
            case 3: {
                return Salmon.class;
            }
            case 4: {
                return TropicalFish.class;
            }
            case 5: {
                return Tadpole.class;
            }
        }
        return Fish.class;
    }

    @Override
    public EntityData getSuperType() {
        return new FishData(this.pattern);
    }

    @Override
    protected int hashCode_i() {
        return this.wildcard ? 0 : this.pattern;
    }

    @Override
    protected boolean equals_i(EntityData<?> entityData) {
        return entityData instanceof Fish ? (this.wildcard ? true : this.getPattern((Fish)entityData) == this.pattern) : false;
    }

    @Override
    public boolean isSupertypeOf(EntityData<?> entityData) {
        return entityData instanceof Fish ? (this.wildcard ? true : this.getPattern((Fish)entityData) == this.pattern) : false;
    }

    private static int getInitPattern(@Nullable Fish fish) {
        if (fish == null) {
            return 0;
        }
        if (fish instanceof Cod) {
            return 1;
        }
        if (fish instanceof PufferFish) {
            return 2;
        }
        if (fish instanceof Salmon) {
            return 3;
        }
        if (fish instanceof TropicalFish) {
            return 4;
        }
        if (HAS_TADPOLE && fish instanceof Tadpole) {
            return 5;
        }
        return 0;
    }

    private int getPattern(@Nullable Fish fish) {
        int p = FishData.getInitPattern(fish);
        return p == 0 ? this.pattern : p;
    }

    static {
        if (HAS_TADPOLE) {
            PATTERNS.add("tadpole");
        }
        FishData.register(FishData.class, "fish", Fish.class, 0, PATTERNS.toArray(new String[0]));
    }
}

