/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Keywords;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.slot.EquipmentSlot;
import ch.njol.skript.util.slot.Slot;
import ch.njol.util.Kleenean;
import java.util.Arrays;
import java.util.Locale;
import java.util.stream.Stream;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.inventory.EntityEquipment;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Armour Slot")
@Description(value={"Equipment of living entities, i.e. the boots, leggings, chestplate or helmet."})
@Examples(value={"set chestplate of the player to a diamond chestplate", "helmet of player is neither a helmet nor air # player is wearing a block, e.g. from another plugin"})
@Keywords(value={"armor"})
@Since(value="1.0, 2.8.0 (Armour)")
public class ExprArmorSlot
extends PropertyExpression<LivingEntity, Slot> {
    private @Nullable EquipmentSlot.EquipSlot slot;
    private boolean explicitSlot;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.slot = parseResult.hasTag("armour") ? null : EquipmentSlot.EquipSlot.valueOf(parseResult.tags.get(0).toUpperCase(Locale.ENGLISH));
        this.explicitSlot = parseResult.hasTag("slot");
        this.setExpr(exprs[0]);
        return true;
    }

    protected Slot[] get(Event event, LivingEntity[] source) {
        if (this.slot == null) {
            return (Slot[])Arrays.stream(source).map(LivingEntity::getEquipment).flatMap(equipment -> {
                if (equipment == null) {
                    return null;
                }
                return Stream.of(new EquipmentSlot((EntityEquipment)equipment, EquipmentSlot.EquipSlot.HELMET, this.explicitSlot), new EquipmentSlot((EntityEquipment)equipment, EquipmentSlot.EquipSlot.CHESTPLATE, this.explicitSlot), new EquipmentSlot((EntityEquipment)equipment, EquipmentSlot.EquipSlot.LEGGINGS, this.explicitSlot), new EquipmentSlot((EntityEquipment)equipment, EquipmentSlot.EquipSlot.BOOTS, this.explicitSlot));
            }).toArray(Slot[]::new);
        }
        return this.get(source, entity -> {
            EntityEquipment equipment = entity.getEquipment();
            if (equipment == null) {
                return null;
            }
            return new EquipmentSlot(equipment, this.slot, this.explicitSlot);
        });
    }

    @Override
    public Class<Slot> getReturnType() {
        return Slot.class;
    }

    @Override
    public String toString(@Nullable Event event, boolean debug) {
        return this.slot == null ? "armour" : this.slot.name().toLowerCase(Locale.ENGLISH) + " of " + this.getExpr().toString(event, debug);
    }

    static {
        ExprArmorSlot.register(ExprArmorSlot.class, Slot.class, "((:boots|:shoes|leggings:leg[ging]s|chestplate:chestplate[s]|helmet:helmet[s]) [(item|:slot)]|armour:armo[u]r[s])", "livingentities");
    }
}

