/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.Aliases;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Timespan;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.util.Arrays;
import java.util.function.Function;
import org.bukkit.block.Block;
import org.bukkit.block.Furnace;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.FurnaceBurnEvent;
import org.eclipse.jdt.annotation.Nullable;
import org.skriptlang.skript.lang.arithmetic.Arithmetics;
import org.skriptlang.skript.lang.arithmetic.Operator;

@Name(value="Burn/Cook Time")
@Description(value={"The time a furnace takes to burn an item in a <a href='events.html#fuel_burn'>fuel burn</a> event.", "Can also be used to change the burn/cook time of a placed furnace."})
@Examples(value={"on fuel burn:", "\tif fuel slot is coal:", "\t\tset burning time to 1 tick"})
@Since(value="2.3")
public class ExprBurnCookTime
extends PropertyExpression<Block, Timespan> {
    static final ItemType anyFurnace;
    private boolean cookTime;
    private boolean isEvent;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.cookTime = parseResult.mark == 1;
        boolean bl = this.isEvent = matchedPattern == 0;
        if (this.isEvent && !this.getParser().isCurrentEvent((Class<? extends Event>)FurnaceBurnEvent.class)) {
            Skript.error("Cannot use 'burning time' outside a fuel burn event.");
            return false;
        }
        if (!this.isEvent) {
            this.setExpr(exprs[0]);
        }
        return true;
    }

    protected Timespan[] get(Event event, Block[] source) {
        if (this.isEvent) {
            if (!(event instanceof FurnaceBurnEvent)) {
                return new Timespan[0];
            }
            return CollectionUtils.array(Timespan.fromTicks(((FurnaceBurnEvent)event).getBurnTime()));
        }
        return (Timespan[])Arrays.stream(source).filter(anyFurnace::isOfType).map(furnace -> {
            Furnace state = (Furnace)furnace.getState();
            return Timespan.fromTicks(this.cookTime ? (long)state.getCookTime() : (long)state.getBurnTime());
        }).toArray(Timespan[]::new);
    }

    @Override
    public @Nullable Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.SET) {
            return CollectionUtils.array(Timespan.class);
        }
        return null;
    }

    @Override
    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (delta == null) {
            return;
        }
        Function<Timespan, Timespan> value = null;
        Timespan changed = (Timespan)delta[0];
        switch (mode) {
            case ADD: {
                value = original -> Arithmetics.calculate(Operator.ADDITION, original, changed, Timespan.class);
                break;
            }
            case REMOVE: {
                value = original -> Arithmetics.difference(original, changed, Timespan.class);
                break;
            }
            case SET: {
                value = original -> changed;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (this.isEvent) {
            if (!(event instanceof FurnaceBurnEvent)) {
                return;
            }
            FurnaceBurnEvent burnEvent = (FurnaceBurnEvent)event;
            burnEvent.setBurnTime((int)value.apply(Timespan.fromTicks(burnEvent.getBurnTime())).getTicks());
            return;
        }
        for (Block block : (Block[])this.getExpr().getArray(event)) {
            if (!anyFurnace.isOfType(block)) continue;
            Furnace furnace = (Furnace)block.getState();
            long time = value.apply(Timespan.fromTicks(this.cookTime ? (long)furnace.getCookTime() : (long)furnace.getBurnTime())).getTicks();
            if (this.cookTime) {
                furnace.setCookTime((short)time);
            } else {
                furnace.setBurnTime((short)time);
            }
            furnace.update();
        }
    }

    @Override
    public Class<? extends Timespan> getReturnType() {
        return Timespan.class;
    }

    @Override
    public String toString(@Nullable Event event, boolean debug) {
        return this.isEvent ? "the burning time" : String.format("the %sing time of %s", this.cookTime ? "cook" : "burn", this.getExpr().toString(event, debug));
    }

    static {
        Skript.registerExpression(ExprBurnCookTime.class, Timespan.class, ExpressionType.PROPERTY, "[the] burn[ing] time", "[the] (burn|1:cook)[ing] time of %blocks%", "%blocks%'[s] (burn|1:cook)[ing] time");
        anyFurnace = Aliases.javaItemType("any furnace");
    }
}

