/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.LiteralUtils;
import ch.njol.skript.util.Patterns;
import ch.njol.util.Kleenean;
import ch.njol.util.StringUtils;
import ch.njol.util.coll.CollectionUtils;
import com.google.common.collect.Iterators;
import java.lang.reflect.Array;
import java.util.Iterator;
import org.apache.commons.lang.ArrayUtils;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Elements")
@Description(value={"The first, last, range or a random element of a set, e.g. a list variable.", "See also: <a href='#ExprRandom'>random expression</a>"})
@Examples(value={"broadcast the first 3 elements of {top players::*}"})
@Since(value="2.0, 2.7 (relative to last element), 2.8.0 (range of elements)")
public class ExprElement<T>
extends SimpleExpression<T> {
    private static final Patterns<ElementType[]> PATTERNS = new Patterns(new Object[][]{{"[the] (first|1:last) element [out] of %objects%", new ElementType[]{ElementType.FIRST_ELEMENT, ElementType.LAST_ELEMENT}}, {"[the] (first|1:last) %integer% elements [out] of %objects%", new ElementType[]{ElementType.FIRST_X_ELEMENTS, ElementType.LAST_X_ELEMENTS}}, {"[a] random element [out] of %objects%", new ElementType[]{ElementType.RANDOM}}, {"[the] %integer%(st|nd|rd|th) [1:[to] last] element [out] of %objects%", new ElementType[]{ElementType.ORDINAL, ElementType.TAIL_END_ORDINAL}}, {"[the] elements (from|between) %integer% (to|and) %integer% [out] of %objects%", new ElementType[]{ElementType.RANGE}}});
    private Expression<? extends T> expr;
    private @Nullable Expression<Integer> startIndex;
    private @Nullable Expression<Integer> endIndex;
    private ElementType type;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        ElementType[] types = PATTERNS.getInfo(matchedPattern);
        this.expr = LiteralUtils.defendExpression(exprs[exprs.length - 1]);
        this.type = types[parseResult.mark];
        switch (this.type) {
            case RANGE: {
                this.endIndex = exprs[1];
            }
            case FIRST_X_ELEMENTS: 
            case LAST_X_ELEMENTS: 
            case ORDINAL: 
            case TAIL_END_ORDINAL: {
                this.startIndex = exprs[0];
                break;
            }
            default: {
                this.startIndex = null;
            }
        }
        return LiteralUtils.canInitSafely(this.expr);
    }

    @Override
    protected @Nullable T[] get(Event event) {
        Object[] elementArray;
        Integer integer;
        Iterator<T> iterator = this.expr.iterator(event);
        if (iterator == null || !iterator.hasNext()) {
            return null;
        }
        Object element = null;
        Class<T> returnType = this.getReturnType();
        int startIndex = 0;
        int endIndex = 0;
        if (this.startIndex != null) {
            integer = this.startIndex.getSingle(event);
            if (integer == null) {
                return null;
            }
            startIndex = integer;
            if (startIndex <= 0 && this.type != ElementType.RANGE) {
                return null;
            }
        }
        if (this.endIndex != null) {
            integer = this.endIndex.getSingle(event);
            if (integer == null) {
                return null;
            }
            endIndex = integer;
        }
        switch (this.type) {
            case FIRST_ELEMENT: {
                element = iterator.next();
                break;
            }
            case LAST_ELEMENT: {
                element = Iterators.getLast(iterator);
                break;
            }
            case RANDOM: {
                element = CollectionUtils.getRandom(Iterators.toArray(iterator, returnType));
                break;
            }
            case ORDINAL: {
                Iterators.advance(iterator, (int)(startIndex - 1));
                if (!iterator.hasNext()) {
                    return null;
                }
                element = iterator.next();
                break;
            }
            case TAIL_END_ORDINAL: {
                elementArray = Iterators.toArray(iterator, returnType);
                if (startIndex > elementArray.length) {
                    return null;
                }
                element = elementArray[elementArray.length - startIndex];
                break;
            }
            case FIRST_X_ELEMENTS: {
                return Iterators.toArray((Iterator)Iterators.limit(iterator, (int)startIndex), returnType);
            }
            case LAST_X_ELEMENTS: {
                elementArray = Iterators.toArray(iterator, returnType);
                startIndex = Math.min(startIndex, elementArray.length);
                return CollectionUtils.subarray(elementArray, elementArray.length - startIndex, elementArray.length);
            }
            case RANGE: {
                elementArray = Iterators.toArray(iterator, returnType);
                boolean reverse = startIndex > endIndex;
                int from = Math.min(startIndex, endIndex) - 1;
                int to = Math.max(startIndex, endIndex);
                Object[] elements = CollectionUtils.subarray(elementArray, from, to);
                if (reverse) {
                    ArrayUtils.reverse((Object[])elements);
                }
                return elements;
            }
        }
        elementArray = (Object[])Array.newInstance(this.getReturnType(), 1);
        elementArray[0] = element;
        return elementArray;
    }

    @Override
    public <R> @Nullable Expression<? extends R> getConvertedExpression(Class<R> ... to) {
        Expression<R> convExpr = this.expr.getConvertedExpression(to);
        if (convExpr == null) {
            return null;
        }
        ExprElement<T> exprElement = new ExprElement<T>();
        exprElement.expr = convExpr;
        exprElement.startIndex = this.startIndex;
        exprElement.endIndex = this.endIndex;
        exprElement.type = this.type;
        return exprElement;
    }

    @Override
    public boolean isSingle() {
        return this.type != ElementType.FIRST_X_ELEMENTS && this.type != ElementType.LAST_X_ELEMENTS && this.type != ElementType.RANGE;
    }

    @Override
    public Class<? extends T> getReturnType() {
        return this.expr.getReturnType();
    }

    @Override
    public String toString(@Nullable Event event, boolean debug) {
        String prefix;
        switch (this.type) {
            case FIRST_ELEMENT: {
                prefix = "the first";
                break;
            }
            case LAST_ELEMENT: {
                prefix = "the last";
                break;
            }
            case FIRST_X_ELEMENTS: {
                assert (this.startIndex != null);
                prefix = "the first " + this.startIndex.toString(event, debug);
                break;
            }
            case LAST_X_ELEMENTS: {
                assert (this.startIndex != null);
                prefix = "the last " + this.startIndex.toString(event, debug);
                break;
            }
            case RANDOM: {
                prefix = "a random";
                break;
            }
            case ORDINAL: 
            case TAIL_END_ORDINAL: {
                Integer integer;
                assert (this.startIndex != null);
                prefix = "the ";
                prefix = this.startIndex instanceof Literal ? ((integer = (Integer)((Literal)this.startIndex).getSingle()) == null ? prefix + this.startIndex.toString(event, debug) + "th" : prefix + StringUtils.fancyOrderNumber(integer)) : prefix + this.startIndex.toString(event, debug) + "th";
                if (this.type != ElementType.TAIL_END_ORDINAL) break;
                prefix = prefix + " last";
                break;
            }
            case RANGE: {
                assert (this.startIndex != null && this.endIndex != null);
                return "the elements from " + this.startIndex.toString(event, debug) + " to " + this.endIndex.toString(event, debug) + " of " + this.expr.toString(event, debug);
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return prefix + (this.isSingle() ? " element" : " elements") + " of " + this.expr.toString(event, debug);
    }

    static {
        Skript.registerExpression(ExprElement.class, Object.class, ExpressionType.PROPERTY, PATTERNS.getPatterns());
    }

    private static enum ElementType {
        FIRST_ELEMENT,
        LAST_ELEMENT,
        FIRST_X_ELEMENTS,
        LAST_X_ELEMENTS,
        RANDOM,
        ORDINAL,
        TAIL_END_ORDINAL,
        RANGE;

    }
}

