/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Events;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Heal Amount")
@Description(value={"The amount of health healed in a healing event."})
@Examples(value={"increase heal amount by 2", "remove 0.5 from heal amount"})
@Since(value="2.5.1")
@Events(value={"heal"})
public class ExprHealAmount
extends SimpleExpression<Number> {
    private Kleenean delay;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!this.getParser().isCurrentEvent((Class<? extends Event>)EntityRegainHealthEvent.class)) {
            Skript.error("The expression 'heal amount' may only be used in a healing event", ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        this.delay = isDelayed;
        return true;
    }

    protected @Nullable Number[] get(Event e) {
        if (!(e instanceof EntityRegainHealthEvent)) {
            return null;
        }
        return new Number[]{((EntityRegainHealthEvent)e).getAmount()};
    }

    @Override
    public @Nullable Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (this.delay != Kleenean.FALSE) {
            Skript.error("The heal amount cannot be changed after the event has already passed");
            return null;
        }
        if (mode == Changer.ChangeMode.REMOVE_ALL || mode == Changer.ChangeMode.RESET) {
            return null;
        }
        return CollectionUtils.array(Number.class);
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (!(e instanceof EntityRegainHealthEvent)) {
            return;
        }
        double value = delta == null ? 0.0 : ((Number)delta[0]).doubleValue();
        switch (mode) {
            case SET: 
            case DELETE: {
                ((EntityRegainHealthEvent)e).setAmount(value);
                break;
            }
            case ADD: {
                ((EntityRegainHealthEvent)e).setAmount(((EntityRegainHealthEvent)e).getAmount() + value);
                break;
            }
            case REMOVE: {
                ((EntityRegainHealthEvent)e).setAmount(((EntityRegainHealthEvent)e).getAmount() - value);
                break;
            }
        }
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "heal amount";
    }

    static {
        Skript.registerExpression(ExprHealAmount.class, Number.class, ExpressionType.SIMPLE, "[the] heal amount");
    }
}

