/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.Timespan;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Item Cooldown")
@Description(value={"Change the cooldown of a specific material to a certain amount of <a href='./classes.html#timespan'>Timespan</a>."})
@Examples(value={"on right click using stick:", "\tset item cooldown of player's tool for player to 1 minute", "\tset item cooldown of stone and grass for all players to 20 seconds", "\treset item cooldown of cobblestone and dirt for all players"})
@Since(value="2.8.0")
public class ExprItemCooldown
extends SimpleExpression<Timespan> {
    private Expression<Player> players;
    private Expression<ItemType> itemtypes;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.players = exprs[matchedPattern ^ 1];
        this.itemtypes = exprs[matchedPattern];
        return true;
    }

    protected Timespan[] get(Event event) {
        Player[] players = this.players.getArray(event);
        List itemTypes = this.itemtypes.stream(event).filter(ItemType::hasType).collect(Collectors.toList());
        Timespan[] timespan = new Timespan[players.length * itemTypes.size()];
        int i = 0;
        for (Player player : players) {
            for (ItemType itemType : itemTypes) {
                timespan[i++] = Timespan.fromTicks_i(player.getCooldown(itemType.getMaterial()));
            }
        }
        return timespan;
    }

    @Override
    public @Nullable Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return mode == Changer.ChangeMode.REMOVE_ALL ? null : CollectionUtils.array(Timespan.class);
    }

    @Override
    public void change(Event event, Object @Nullable [] delta, Changer.ChangeMode mode) {
        if (mode != Changer.ChangeMode.RESET && mode != Changer.ChangeMode.DELETE && delta == null) {
            return;
        }
        int ticks = delta != null ? (int)((Timespan)delta[0]).getTicks_i() : 0;
        Player[] players = this.players.getArray(event);
        List itemTypes = this.itemtypes.stream(event).filter(ItemType::hasType).collect(Collectors.toList());
        for (Player player : players) {
            for (ItemType itemtype : itemTypes) {
                Material material = itemtype.getMaterial();
                switch (mode) {
                    case RESET: 
                    case DELETE: 
                    case SET: {
                        player.setCooldown(material, ticks);
                        break;
                    }
                    case REMOVE: {
                        player.setCooldown(material, Math.max(player.getCooldown(material) - ticks, 0));
                        break;
                    }
                    case ADD: {
                        player.setCooldown(material, player.getCooldown(material) + ticks);
                    }
                }
            }
        }
    }

    @Override
    public boolean isSingle() {
        return this.players.isSingle() && this.itemtypes.isSingle();
    }

    @Override
    public Class<? extends Timespan> getReturnType() {
        return Timespan.class;
    }

    @Override
    public String toString(@Nullable Event event, boolean debug) {
        return "cooldown of " + this.itemtypes.toString(event, debug) + " for " + this.players.toString(event, debug);
    }

    static {
        Skript.registerExpression(ExprItemCooldown.class, Timespan.class, ExpressionType.COMBINED, "[the] [item] cooldown of %itemtypes% for %players%", "%players%'[s] [item] cooldown for %itemtypes%");
    }
}

