/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import org.bukkit.inventory.meta.ItemMeta;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Item with CustomModelData")
@Description(value={"Get an item with a CustomModelData tag. (Value is an integer between 0 and 99999999)"})
@Examples(value={"give player a diamond sword with custom model data 2", "set slot 1 of inventory of player to wooden hoe with custom model data 357"})
@RequiredPlugins(value={"1.14+"})
@Since(value="2.5")
public class ExprItemWithCustomModelData
extends PropertyExpression<ItemType, ItemType> {
    private Expression<Number> data;

    @Override
    public boolean init(Expression<?>[] exprs, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.setExpr(exprs[0]);
        this.data = exprs[1];
        return true;
    }

    protected ItemType[] get(Event e, ItemType[] source) {
        Number data = this.data.getSingle(e);
        if (data == null) {
            return source;
        }
        return this.get((ItemType[])source.clone(), item -> {
            ItemMeta meta = item.getItemMeta();
            meta.setCustomModelData(Integer.valueOf(data.intValue()));
            item.setItemMeta(meta);
            return item;
        });
    }

    @Override
    public Class<? extends ItemType> getReturnType() {
        return ItemType.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean d) {
        return this.getExpr().toString(e, d) + " with custom model data " + this.data.toString(e, d);
    }

    static {
        if (Skript.methodExists(ItemMeta.class, "hasCustomModelData", new Class[0])) {
            Skript.registerExpression(ExprItemWithCustomModelData.class, ItemType.class, ExpressionType.PROPERTY, "%itemtype% with [custom] model data %number%");
        }
    }
}

