/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.ArrayList;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Potion Effect Tier")
@Description(value={"An expression to obtain the amplifier of a potion effect applied to an entity."})
@Examples(value={"if the amplifier of haste of player >= 3:"})
@Since(value="2.7")
public class ExprPotionEffectTier
extends SimpleExpression<Integer> {
    private Expression<PotionEffectType> typeExpr;
    private Expression<LivingEntity> entityExpr;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.typeExpr = exprs[0];
        this.entityExpr = exprs[1];
        return true;
    }

    protected @Nullable Integer[] get(Event event) {
        PotionEffectType[] types = this.typeExpr.getArray(event);
        LivingEntity[] entities = this.entityExpr.getArray(event);
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (LivingEntity entity : entities) {
            for (PotionEffectType type : types) {
                PotionEffect effect = entity.getPotionEffect(type);
                result.add(effect == null ? 0 : effect.getAmplifier() + 1);
            }
        }
        return result.toArray(new Integer[0]);
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public Class<? extends Integer> getReturnType() {
        return Integer.class;
    }

    @Override
    public String toString(@Nullable Event event, boolean debug) {
        return "potion tier of " + this.typeExpr.toString(event, debug) + " of " + this.entityExpr.toString(event, debug);
    }

    static {
        Skript.registerExpression(ExprPotionEffectTier.class, Integer.class, ExpressionType.COMBINED, "[the] [potion] (tier|amplifier|level) of %potioneffecttypes% (of|for|on) %livingentities%");
    }
}

