/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.destroystokyo.paper.event.server.PaperServerListPingEvent;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.util.CachedServerIcon;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Server Icon")
@Description(value={"Icon of the server in the server list. Can be set to an icon that loaded using the", "<a href='effects.html#EffLoadServerIcon'>load server icon</a> effect,", "or can be reset to the default icon in a <a href='events.html#server_list_ping'>server list ping</a>.", "'default server icon' returns the default server icon (server-icon.png) always and cannot be changed."})
@Examples(value={"on script load:", "\tset {server-icons::default} to the default server icon"})
@Since(value="2.3")
@RequiredPlugins(value={"Paper 1.12.2 or newer"})
public class ExprServerIcon
extends SimpleExpression<CachedServerIcon> {
    private static final boolean PAPER_EVENT_EXISTS;
    private boolean isServerPingEvent;
    private boolean isDefault;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!PAPER_EVENT_EXISTS) {
            Skript.error("The server icon expression requires Paper 1.12.2 or newer");
            return false;
        }
        this.isServerPingEvent = this.getParser().isCurrentEvent((Class<? extends Event>)PaperServerListPingEvent.class);
        boolean bl = this.isDefault = parseResult.mark == 0 && !this.isServerPingEvent || parseResult.mark == 1;
        if (!this.isServerPingEvent && !this.isDefault) {
            Skript.error("The 'shown' server icon expression can't be used outside of a server list ping event");
            return false;
        }
        return true;
    }

    public @Nullable CachedServerIcon[] get(Event e) {
        CachedServerIcon icon = null;
        if (this.isServerPingEvent && !this.isDefault && PAPER_EVENT_EXISTS) {
            if (!(e instanceof PaperServerListPingEvent)) {
                return null;
            }
            icon = ((PaperServerListPingEvent)e).getServerIcon();
        } else {
            icon = Bukkit.getServerIcon();
        }
        if (icon == null || icon.getData() == null) {
            return null;
        }
        return CollectionUtils.array(icon);
    }

    @Override
    public @Nullable Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (this.isServerPingEvent && !this.isDefault) {
            if (this.getParser().getHasDelayBefore().isTrue()) {
                Skript.error("Can't change the server icon anymore after the server list ping event has already passed");
                return null;
            }
            if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.RESET) {
                return CollectionUtils.array(CachedServerIcon.class);
            }
        }
        return null;
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (!(e instanceof PaperServerListPingEvent)) {
            return;
        }
        PaperServerListPingEvent event = (PaperServerListPingEvent)e;
        switch (mode) {
            case SET: {
                event.setServerIcon((CachedServerIcon)delta[0]);
                break;
            }
            case RESET: {
                event.setServerIcon(Bukkit.getServerIcon());
            }
        }
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public Class<? extends CachedServerIcon> getReturnType() {
        return CachedServerIcon.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "the " + (!this.isServerPingEvent || this.isDefault ? "default" : "shown") + " server icon";
    }

    static {
        Skript.registerExpression(ExprServerIcon.class, CachedServerIcon.class, ExpressionType.PROPERTY, "[the] [(1\u00a6(default)|2\u00a6(shown|sent))] [server] icon");
        PAPER_EVENT_EXISTS = Skript.classExists("com.destroystokyo.paper.event.server.PaperServerListPingEvent");
    }
}

