/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.util.ConvertedExpression;
import org.bukkit.block.data.BlockData;
import org.bukkit.inventory.Inventory;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.eclipse.jdt.annotation.Nullable;
import org.skriptlang.skript.lang.converter.Converters;

@Name(value="Type of")
@Description(value={"Type of a block, item, entity, inventory or potion effect.", "Types of items, blocks and block datas are item types similar to them but have amounts", "of one, no display names and, on Minecraft 1.13 and newer versions, are undamaged.", "Types of entities and inventories are entity types and inventory types known to Skript.", "Types of potion effects are potion effect types."})
@Examples(value={"on rightclick on an entity:", "\tmessage \"This is a %type of clicked entity%!\""})
@Since(value="1.4, 2.5.2 (potion effect), 2.7 (block datas)")
public class ExprTypeOf
extends SimplePropertyExpression<Object, Object> {
    @Override
    protected String getPropertyName() {
        return "type";
    }

    @Override
    public @Nullable Object convert(Object o) {
        if (o instanceof EntityData) {
            return ((EntityData)o).getSuperType();
        }
        if (o instanceof ItemType) {
            return ((ItemType)o).getBaseType();
        }
        if (o instanceof Inventory) {
            return ((Inventory)o).getType();
        }
        if (o instanceof PotionEffect) {
            return ((PotionEffect)o).getType();
        }
        if (o instanceof BlockData) {
            return new ItemType(((BlockData)o).getMaterial());
        }
        assert (false);
        return null;
    }

    @Override
    public Class<?> getReturnType() {
        Class returnType = this.getExpr().getReturnType();
        return EntityData.class.isAssignableFrom(returnType) ? EntityData.class : (ItemType.class.isAssignableFrom(returnType) ? ItemType.class : (PotionEffectType.class.isAssignableFrom(returnType) ? PotionEffectType.class : (BlockData.class.isAssignableFrom(returnType) ? ItemType.class : Object.class)));
    }

    @Override
    protected <R> @Nullable ConvertedExpression<Object, ? extends R> getConvertedExpr(Class<R> ... to) {
        if (!Converters.converterExists(EntityData.class, to) && !Converters.converterExists(ItemType.class, to)) {
            return null;
        }
        return super.getConvertedExpr(to);
    }

    static {
        ExprTypeOf.register(ExprTypeOf.class, Object.class, "type", "entitydatas/itemtypes/inventories/potioneffects/blockdatas");
    }
}

