/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions.arithmetic;

import ch.njol.skript.expressions.arithmetic.ArithmeticExpressionInfo;
import ch.njol.skript.expressions.arithmetic.ArithmeticGettable;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.util.Utils;
import ch.njol.util.Checker;
import java.util.List;
import java.util.function.Function;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;
import org.skriptlang.skript.lang.arithmetic.Arithmetics;
import org.skriptlang.skript.lang.arithmetic.OperationInfo;
import org.skriptlang.skript.lang.arithmetic.Operator;
import org.skriptlang.skript.lang.converter.Converters;

public class ArithmeticChain<L, R, T>
implements ArithmeticGettable<T> {
    private static final Checker<Object>[] CHECKERS = new Checker[]{o -> o.equals((Object)Operator.ADDITION) || o.equals((Object)Operator.SUBTRACTION), o -> o.equals((Object)Operator.MULTIPLICATION) || o.equals((Object)Operator.DIVISION), o -> o.equals((Object)Operator.EXPONENTIATION)};
    private final ArithmeticGettable<L> left;
    private final ArithmeticGettable<R> right;
    private final Operator operator;
    private final Class<? extends T> returnType;
    private @Nullable OperationInfo<? extends L, ? extends R, ? extends T> operationInfo;

    public ArithmeticChain(ArithmeticGettable<L> left, Operator operator, ArithmeticGettable<R> right, @Nullable OperationInfo<L, R, T> operationInfo) {
        this.left = left;
        this.right = right;
        this.operator = operator;
        this.operationInfo = operationInfo;
        this.returnType = operationInfo != null ? operationInfo.getReturnType() : Object.class;
    }

    @Override
    public @Nullable T get(Event event) {
        Class<Object> rightClass;
        L left = this.left.get(event);
        if (left == null && this.left instanceof ArithmeticChain) {
            return null;
        }
        R right = this.right.get(event);
        if (right == null && this.right instanceof ArithmeticChain) {
            return null;
        }
        Class<Object> leftClass = left != null ? left.getClass() : this.left.getReturnType();
        Class<Object> clazz = rightClass = right != null ? right.getClass() : this.right.getReturnType();
        if (leftClass == Object.class && rightClass == Object.class) {
            return null;
        }
        if (left == null && leftClass == Object.class) {
            this.operationInfo = this.lookupOperationInfo(rightClass, OperationInfo::getRight);
        } else if (right == null && rightClass == Object.class) {
            this.operationInfo = this.lookupOperationInfo(leftClass, OperationInfo::getLeft);
        } else if (this.operationInfo == null) {
            this.operationInfo = Arithmetics.lookupOperationInfo(this.operator, leftClass, rightClass, this.returnType);
        }
        if (this.operationInfo == null) {
            return null;
        }
        Object object = left = left != null ? left : Arithmetics.getDefaultValue(this.operationInfo.getLeft());
        if (left == null) {
            return null;
        }
        R r = right = right != null ? right : Arithmetics.getDefaultValue(this.operationInfo.getRight());
        if (right == null) {
            return null;
        }
        return this.operationInfo.getOperation().calculate(left, right);
    }

    private @Nullable OperationInfo<L, R, T> lookupOperationInfo(Class<?> anchor, Function<OperationInfo<?, ?, ?>, Class<?>> anchorFunction) {
        OperationInfo<?, ?, ?> operationInfo = Arithmetics.lookupOperationInfo(this.operator, anchor, anchor);
        if (operationInfo != null) {
            return operationInfo;
        }
        return Arithmetics.getOperations(this.operator).stream().filter(info -> ((Class)anchorFunction.apply((OperationInfo<?, ?, ?>)info)).isAssignableFrom(anchor)).filter(info -> Converters.converterExists(info.getReturnType(), this.returnType)).reduce((info, info2) -> {
            if (anchorFunction.apply((OperationInfo<?, ?, ?>)info2) == anchor) {
                return info2;
            }
            return info;
        }).orElse(null);
    }

    @Override
    public Class<? extends T> getReturnType() {
        return this.returnType;
    }

    public static <L, R, T> @Nullable ArithmeticGettable<T> parse(List<Object> chain) {
        for (Checker<Object> checker : CHECKERS) {
            int lastIndex = Utils.findLastIndex(chain, checker);
            if (lastIndex == -1) continue;
            ArithmeticGettable<T> left = ArithmeticChain.parse(chain.subList(0, lastIndex));
            Operator operator = (Operator)((Object)chain.get(lastIndex));
            ArithmeticGettable<T> right = ArithmeticChain.parse(chain.subList(lastIndex + 1, chain.size()));
            if (left == null || right == null) {
                return null;
            }
            OperationInfo<T, T, ?> operationInfo = null;
            if (left.getReturnType() != Object.class && right.getReturnType() != Object.class && (operationInfo = Arithmetics.lookupOperationInfo(operator, left.getReturnType(), right.getReturnType())) == null) {
                return null;
            }
            return new ArithmeticChain<T, T, T>(left, operator, right, operationInfo);
        }
        if (chain.size() != 1) {
            throw new IllegalStateException();
        }
        return new ArithmeticExpressionInfo((Expression)chain.get(0));
    }
}

