/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang;

import ch.njol.skript.SkriptAPIException;
import ch.njol.skript.lang.SkriptEvent;
import java.util.Locale;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.eclipse.jdt.annotation.Nullable;
import org.skriptlang.skript.lang.structure.StructureInfo;

public final class SkriptEventInfo<E extends SkriptEvent>
extends StructureInfo<E> {
    public Class<? extends Event>[] events;
    public final String name;
    private @Nullable String[] description;
    private @Nullable String[] examples;
    private @Nullable String[] keywords;
    private @Nullable String[] requiredPlugins;
    private @Nullable String since;
    private @Nullable String documentationID;
    private final String id;
    public static final String[] NO_DOC = new String[0];

    public SkriptEventInfo(String name, String[] patterns, Class<E> eventClass, String originClassPath, Class<? extends Event>[] events) {
        super(patterns, eventClass, originClassPath);
        for (int i = 0; i < events.length; ++i) {
            for (int j = i + 1; j < events.length; ++j) {
                if (!events[i].isAssignableFrom(events[j]) && !events[j].isAssignableFrom(events[i]) || events[i].equals(PlayerInteractAtEntityEvent.class) || events[j].equals(PlayerInteractAtEntityEvent.class)) continue;
                throw new SkriptAPIException("The event " + name + " (" + eventClass.getName() + ") registers with super/subclasses " + events[i].getName() + " and " + events[j].getName());
            }
        }
        this.events = events;
        this.name = name.startsWith("*") ? (name = "" + name.substring(1)) : "On " + name;
        this.id = "" + name.toLowerCase(Locale.ENGLISH).replaceAll("[#'\"<>/&]", "").replaceAll("\\s+", "_");
    }

    public SkriptEventInfo<E> description(String ... description) {
        this.description = description;
        return this;
    }

    public SkriptEventInfo<E> examples(String ... examples) {
        this.examples = examples;
        return this;
    }

    public SkriptEventInfo<E> keywords(String ... keywords) {
        this.keywords = keywords;
        return this;
    }

    public SkriptEventInfo<E> since(String since) {
        assert (this.since == null);
        this.since = since;
        return this;
    }

    public SkriptEventInfo<E> documentationID(String id) {
        assert (this.documentationID == null);
        this.documentationID = id;
        return this;
    }

    public SkriptEventInfo<E> requiredPlugins(String ... pluginNames) {
        this.requiredPlugins = pluginNames;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public @Nullable String[] getDescription() {
        return this.description;
    }

    public @Nullable String[] getExamples() {
        return this.examples;
    }

    public @Nullable String[] getKeywords() {
        return this.keywords;
    }

    public @Nullable String getSince() {
        return this.since;
    }

    public @Nullable String[] getRequiredPlugins() {
        return this.requiredPlugins;
    }

    public @Nullable String getDocumentationID() {
        return this.documentationID;
    }
}

