/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.log;

import ch.njol.skript.log.LogEntry;
import ch.njol.skript.log.LogHandler;
import ch.njol.skript.log.SkriptLogger;
import java.util.logging.Level;
import org.bukkit.command.CommandSender;
import org.eclipse.jdt.annotation.Nullable;

public class RedirectingLogHandler
extends LogHandler {
    private final CommandSender recipient;
    private final String prefix;
    private int numErrors = 0;

    public RedirectingLogHandler(CommandSender recipient, @Nullable String prefix) {
        this.recipient = recipient;
        this.prefix = prefix == null ? "" : prefix;
    }

    @Override
    public LogHandler.LogResult log(LogEntry entry) {
        SkriptLogger.sendFormatted(this.recipient, this.prefix + entry.toFormattedString());
        if (entry.level == Level.SEVERE) {
            ++this.numErrors;
        }
        return LogHandler.LogResult.DO_NOT_LOG;
    }

    @Override
    public RedirectingLogHandler start() {
        return SkriptLogger.startLogHandler(this);
    }

    public int numErrors() {
        return this.numErrors;
    }
}

