/*
 * Decompiled with CFR 0.152.
 */
package org.skriptlang.skript.lang.arithmetic;

import com.google.common.base.MoreObjects;
import org.jetbrains.annotations.Nullable;
import org.skriptlang.skript.lang.arithmetic.Operation;
import org.skriptlang.skript.lang.converter.Converters;

public class OperationInfo<L, R, T> {
    private final Class<L> left;
    private final Class<R> right;
    private final Class<T> returnType;
    private final Operation<L, R, T> operation;

    public OperationInfo(Class<L> left, Class<R> right, Class<T> returnType, Operation<L, R, T> operation) {
        this.left = left;
        this.right = right;
        this.returnType = returnType;
        this.operation = operation;
    }

    public Class<L> getLeft() {
        return this.left;
    }

    public Class<R> getRight() {
        return this.right;
    }

    public Class<T> getReturnType() {
        return this.returnType;
    }

    public Operation<L, R, T> getOperation() {
        return this.operation;
    }

    @Nullable
    public <L2, R2> OperationInfo<L2, R2, T> getConverted(Class<L2> fromLeft, Class<R2> fromRight) {
        return this.getConverted(fromLeft, fromRight, this.returnType);
    }

    @Nullable
    public <L2, R2, T2> OperationInfo<L2, R2, T2> getConverted(Class<L2> fromLeft, Class<R2> fromRight, Class<T2> toReturnType) {
        if (fromLeft == Object.class || fromRight == Object.class) {
            return null;
        }
        if (!(Converters.converterExists(fromLeft, this.left) && Converters.converterExists(fromRight, this.right) && Converters.converterExists(this.returnType, toReturnType))) {
            return null;
        }
        return new OperationInfo<Object, Object, Object>(fromLeft, fromRight, toReturnType, (left, right) -> {
            L convertedLeft = Converters.convert(left, this.left);
            R convertedRight = Converters.convert(right, this.right);
            if (convertedLeft == null || convertedRight == null) {
                return null;
            }
            T result = this.operation.calculate(convertedLeft, convertedRight);
            return Converters.convert(result, toReturnType);
        });
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("left", this.left).add("right", this.right).add("returnType", this.returnType).toString();
    }
}

