/*
 * Decompiled with CFR 0.152.
 */
package org.skriptlang.skript.lang.structure;

import ch.njol.skript.Skript;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.lang.Debuggable;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.SyntaxElement;
import ch.njol.skript.lang.parser.ParserInstance;
import ch.njol.skript.log.ParseLogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.iterator.ConsumingIterator;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.jdt.annotation.Nullable;
import org.jetbrains.annotations.NotNull;
import org.skriptlang.skript.lang.entry.EntryContainer;
import org.skriptlang.skript.lang.entry.EntryValidator;
import org.skriptlang.skript.lang.structure.StructureInfo;

public abstract class Structure
implements SyntaxElement,
Debuggable {
    public static final Priority DEFAULT_PRIORITY = new Priority(1000);
    private @Nullable EntryContainer entryContainer = null;

    public final EntryContainer getEntryContainer() {
        if (this.entryContainer == null) {
            throw new IllegalStateException("This Structure hasn't been initialized!");
        }
        return this.entryContainer;
    }

    @Override
    public final boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        StructureData structureData = this.getParser().getData(StructureData.class);
        Literal[] literals = (Literal[])Arrays.copyOf(expressions, expressions.length, Literal[].class);
        StructureInfo structureInfo = structureData.structureInfo;
        assert (structureInfo != null);
        EntryValidator entryValidator = structureInfo.entryValidator;
        if (entryValidator == null) {
            this.entryContainer = EntryContainer.withoutValidator(structureData.sectionNode);
        } else {
            EntryContainer entryContainer = entryValidator.validate(structureData.sectionNode);
            if (entryContainer == null) {
                return false;
            }
            this.entryContainer = entryContainer;
        }
        return this.init(literals, matchedPattern, parseResult, this.entryContainer);
    }

    public abstract boolean init(Literal<?>[] var1, int var2, SkriptParser.ParseResult var3, EntryContainer var4);

    public boolean preLoad() {
        return true;
    }

    public abstract boolean load();

    public boolean postLoad() {
        return true;
    }

    public void unload() {
    }

    public void postUnload() {
    }

    public Priority getPriority() {
        return DEFAULT_PRIORITY;
    }

    @Override
    public String toString() {
        return this.toString(null, false);
    }

    public static @Nullable Structure parse(String expr, SectionNode sectionNode, @Nullable String defaultError) {
        return Structure.parse(expr, sectionNode, defaultError, Skript.getStructures().iterator());
    }

    public static @Nullable Structure parse(String expr, SectionNode sectionNode, @Nullable String defaultError, Iterator<? extends StructureInfo<? extends Structure>> iterator) {
        ParserInstance.get().getData(StructureData.class).sectionNode = sectionNode;
        iterator = new ConsumingIterator<StructureInfo>(iterator, elementInfo -> ParserInstance.get().getData(StructureData.class).structureInfo = elementInfo);
        try (ParseLogHandler parseLogHandler = SkriptLogger.startParseLogHandler();){
            Structure structure = (Structure)SkriptParser.parseStatic(expr, iterator, ParseContext.EVENT, defaultError);
            if (structure != null) {
                parseLogHandler.printLog();
                Structure structure2 = structure;
                return structure2;
            }
            parseLogHandler.printError();
            Structure structure3 = null;
            return structure3;
        }
    }

    static {
        ParserInstance.registerData(StructureData.class, StructureData::new);
    }

    public static class StructureData
    extends ParserInstance.Data {
        private SectionNode sectionNode;
        private @Nullable StructureInfo<? extends Structure> structureInfo;

        public StructureData(ParserInstance parserInstance) {
            super(parserInstance);
        }

        public @Nullable StructureInfo<? extends Structure> getStructureInfo() {
            return this.structureInfo;
        }
    }

    public static class Priority
    implements Comparable<Priority> {
        private final int priority;

        public Priority(int priority) {
            this.priority = priority;
        }

        public int getPriority() {
            return this.priority;
        }

        @Override
        public int compareTo(@NotNull Priority o) {
            return Integer.compare(this.priority, o.priority);
        }
    }
}

