/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.ServerPlatform;
import ch.njol.skript.SkriptAPIException;
import ch.njol.skript.SkriptAddon;
import ch.njol.skript.SkriptCommand;
import ch.njol.skript.SkriptCommandTabCompleter;
import ch.njol.skript.SkriptConfig;
import ch.njol.skript.SkriptUpdater;
import ch.njol.skript.aliases.Aliases;
import ch.njol.skript.bstats.bukkit.Metrics;
import ch.njol.skript.bstats.charts.SimplePie;
import ch.njol.skript.bukkitutil.BurgerHelper;
import ch.njol.skript.classes.data.BukkitClasses;
import ch.njol.skript.classes.data.BukkitEventValues;
import ch.njol.skript.classes.data.DefaultComparators;
import ch.njol.skript.classes.data.DefaultConverters;
import ch.njol.skript.classes.data.DefaultFunctions;
import ch.njol.skript.classes.data.DefaultOperations;
import ch.njol.skript.classes.data.JavaClasses;
import ch.njol.skript.classes.data.SkriptClasses;
import ch.njol.skript.command.Commands;
import ch.njol.skript.doc.Documentation;
import ch.njol.skript.events.EvtSkript;
import ch.njol.skript.hooks.Hook;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionInfo;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.Section;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptEventInfo;
import ch.njol.skript.lang.Statement;
import ch.njol.skript.lang.SyntaxElementInfo;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.localization.Language;
import ch.njol.skript.localization.Message;
import ch.njol.skript.localization.PluralizingArgsMessage;
import ch.njol.skript.log.BukkitLoggerFilter;
import ch.njol.skript.log.CountingLogHandler;
import ch.njol.skript.log.ErrorDescLogHandler;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.log.LogEntry;
import ch.njol.skript.log.LogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.log.Verbosity;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.test.runner.EffObjectives;
import ch.njol.skript.test.runner.SkriptJUnitTest;
import ch.njol.skript.test.runner.SkriptTestEvent;
import ch.njol.skript.test.runner.TestMode;
import ch.njol.skript.test.runner.TestTracker;
import ch.njol.skript.timings.SkriptTimings;
import ch.njol.skript.update.ReleaseManifest;
import ch.njol.skript.update.ReleaseStatus;
import ch.njol.skript.update.UpdateManifest;
import ch.njol.skript.util.Date;
import ch.njol.skript.util.EmptyStacktraceException;
import ch.njol.skript.util.ExceptionUtils;
import ch.njol.skript.util.FileUtils;
import ch.njol.skript.util.Task;
import ch.njol.skript.util.Utils;
import ch.njol.skript.util.Version;
import ch.njol.skript.util.chat.BungeeConverter;
import ch.njol.skript.util.chat.ChatMessages;
import ch.njol.skript.variables.Variables;
import ch.njol.util.Closeable;
import ch.njol.util.NullableChecker;
import ch.njol.util.OpenCloseable;
import ch.njol.util.StringUtils;
import ch.njol.util.coll.iterator.CheckedIterator;
import ch.njol.util.coll.iterator.EnumerationIterable;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;
import org.eclipse.jdt.annotation.Nullable;
import org.junit.After;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;
import org.skriptlang.skript.lang.converter.Converters;
import org.skriptlang.skript.lang.entry.EntryValidator;
import org.skriptlang.skript.lang.script.Script;
import org.skriptlang.skript.lang.structure.Structure;
import org.skriptlang.skript.lang.structure.StructureInfo;

public final class Skript
extends JavaPlugin
implements Listener {
    private static @Nullable Skript instance = null;
    private static boolean disabled = false;
    private static boolean partDisabled = false;
    private @Nullable SkriptUpdater updater;
    private static Version minecraftVersion = new Version(666);
    private static Version UNKNOWN_VERSION = new Version(666);
    private static ServerPlatform serverPlatform = ServerPlatform.BUKKIT_UNKNOWN;
    private static @Nullable Version version = null;
    public static final Message m_invalid_reload = new Message("skript.invalid reload");
    public static final Message m_finished_loading = new Message("skript.finished loading");
    public static final Message m_no_errors = new Message("skript.no errors");
    public static final Message m_no_scripts = new Message("skript.no scripts");
    private static final PluralizingArgsMessage m_scripts_loaded = new PluralizingArgsMessage("skript.scripts loaded");
    private static final Set<Class<? extends Hook<?>>> disabledHookRegistrations = new HashSet();
    private static boolean finishedLoadingHooks = false;
    private File scriptsFolder;
    static @Nullable Metrics metrics;
    private static final Collection<Closeable> closeOnDisable;
    private static final boolean IS_STOPPING_EXISTS;
    private static @Nullable Method IS_RUNNING;
    private static @Nullable Object MC_SERVER;
    public static final String SCRIPTSFOLDER = "scripts";
    public static final double EPSILON = 1.0E-10;
    public static final double EPSILON_MULT = 1.00001;
    public static final int MAXBLOCKID = 255;
    public static final int MAXDATAVALUE = 65535;
    public static final Thread.UncaughtExceptionHandler UEH;
    private static boolean acceptRegistrations;
    private static final HashMap<String, SkriptAddon> addons;
    private static @Nullable SkriptAddon addon;
    private static final Collection<SyntaxElementInfo<? extends Condition>> conditions;
    private static final Collection<SyntaxElementInfo<? extends Effect>> effects;
    private static final Collection<SyntaxElementInfo<? extends Statement>> statements;
    private static final Collection<SyntaxElementInfo<? extends Section>> sections;
    private static final List<ExpressionInfo<?, ?>> expressions;
    private static final int[] expressionTypesStartIndices;
    private static final List<SkriptEventInfo<?>> events;
    private static final List<StructureInfo<? extends Structure>> structures;
    private static final String EXCEPTION_PREFIX = "#!#! ";
    private static Map<String, PluginDescriptionFile> pluginPackages;
    private static boolean checkedPlugins;
    private static boolean tainted;
    private static boolean errored;
    private static final Message SKRIPT_PREFIX_MESSAGE;

    public static Skript getInstance() {
        Skript i = instance;
        if (i == null) {
            throw new IllegalStateException();
        }
        return i;
    }

    public Skript() throws IllegalStateException {
        if (instance != null) {
            throw new IllegalStateException("Cannot create multiple instances of Skript!");
        }
        instance = this;
    }

    public static void updateMinecraftVersion() {
        String bukkitV = Bukkit.getBukkitVersion();
        Matcher m = Pattern.compile("\\d+\\.\\d+(\\.\\d+)?").matcher(bukkitV);
        minecraftVersion = !m.find() ? new Version(666, 0, 0) : new Version("" + m.group());
    }

    public static Version getVersion() {
        Version v = version;
        if (v == null) {
            throw new IllegalStateException();
        }
        return v;
    }

    public static ServerPlatform getServerPlatform() {
        if (Skript.classExists("net.glowstone.GlowServer")) {
            return ServerPlatform.BUKKIT_GLOWSTONE;
        }
        if (Skript.classExists("co.aikar.timings.Timings")) {
            return ServerPlatform.BUKKIT_PAPER;
        }
        if (Skript.classExists("org.spigotmc.SpigotConfig")) {
            return ServerPlatform.BUKKIT_SPIGOT;
        }
        if (Skript.classExists("org.bukkit.craftbukkit.CraftServer") || Skript.classExists("org.bukkit.craftbukkit.Main")) {
            return ServerPlatform.BUKKIT_CRAFTBUKKIT;
        }
        return ServerPlatform.BUKKIT_UNKNOWN;
    }

    private static boolean using32BitJava() {
        return System.getProperty("java.vm.name").contains("32");
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean checkServerPlatform() {
        String bukkitV = Bukkit.getBukkitVersion();
        Matcher m = Pattern.compile("\\d+\\.\\d+(\\.\\d+)?").matcher(bukkitV);
        if (!m.find()) {
            Skript.error("The Bukkit version '" + bukkitV + "' does not contain a version number which is required for Skript to enable or disable certain features. Skript will still work, but you might get random errors if you use features that are not available in your version of Bukkit.");
            minecraftVersion = new Version(666, 0, 0);
        } else {
            minecraftVersion = new Version("" + m.group());
        }
        Skript.debug("Loading for Minecraft " + minecraftVersion);
        if (!Skript.isRunningMinecraft(1, 9)) {
            Skript.error("This version of Skript does not work with Minecraft " + minecraftVersion + " and requires Minecraft 1.9.4+");
            Skript.error("You probably want Skript 2.2 or 2.1 (Google to find where to get them)");
            Skript.error("Note that those versions are, of course, completely unsupported!");
            return false;
        }
        serverPlatform = Skript.getServerPlatform();
        Skript.debug("Server platform: " + (Object)((Object)serverPlatform));
        if (Skript.serverPlatform.works) {
            if (Skript.serverPlatform.supported) return true;
            Skript.warning("This server platform (" + Skript.serverPlatform.name + ") is not supported by Skript.");
            Skript.warning("It will still probably work, but if it does not, you are on your own.");
            Skript.warning("Skript officially supports Paper and Spigot.");
            return true;
        }
        Skript.error("It seems that this server platform (" + Skript.serverPlatform.name + ") does not work with Skript.");
        if (SkriptConfig.allowUnsafePlatforms.value().booleanValue()) {
            Skript.error("However, you have chosen to ignore this. Skript will probably still not work.");
            return true;
        }
        Skript.error("To prevent potentially unsafe behaviour, Skript has been disabled.");
        Skript.error("You may re-enable it by adding a configuration option 'allow unsafe platforms: true'");
        Skript.error("Note that it is unlikely that Skript works correctly even if you do so.");
        Skript.error("A better idea would be to install Paper or Spigot in place of your current server.");
        return false;
    }

    public static boolean isHookEnabled(Class<? extends Hook<?>> hook) {
        return !disabledHookRegistrations.contains(hook);
    }

    public static boolean isFinishedLoadingHooks() {
        return finishedLoadingHooks;
    }

    @SafeVarargs
    public static void disableHookRegistration(Class<? extends Hook<?>> ... hooks) {
        if (finishedLoadingHooks) {
            throw new SkriptAPIException("Disabling hooks is not possible after Skript has been enabled!");
        }
        Collections.addAll(disabledHookRegistrations, hooks);
    }

    public File getScriptsFolder() {
        if (!this.scriptsFolder.isDirectory()) {
            this.scriptsFolder.mkdirs();
        }
        return this.scriptsFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEnable() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        if (disabled) {
            Skript.error(m_invalid_reload.toString());
            this.setEnabled(false);
            return;
        }
        this.handleJvmArguments();
        version = new Version("" + this.getDescription().getVersion());
        try {
            this.updater = new SkriptUpdater();
        }
        catch (Exception e) {
            Skript.exception((Throwable)e, "Update checker could not be initialized.");
        }
        if (!this.getDataFolder().isDirectory()) {
            this.getDataFolder().mkdirs();
        }
        this.scriptsFolder = new File(this.getDataFolder(), SCRIPTSFOLDER);
        File config = new File(this.getDataFolder(), "config.sk");
        File features = new File(this.getDataFolder(), "features.sk");
        File lang = new File(this.getDataFolder(), "lang");
        if (!(this.scriptsFolder.isDirectory() && config.exists() && features.exists() && lang.exists())) {
            ZipFile f = null;
            try {
                boolean populateExamples = false;
                if (!this.scriptsFolder.isDirectory()) {
                    if (!this.scriptsFolder.mkdirs()) {
                        throw new IOException("Could not create the directory " + this.scriptsFolder);
                    }
                    populateExamples = true;
                }
                boolean populateLanguageFiles = false;
                if (!lang.isDirectory()) {
                    if (!lang.mkdirs()) {
                        throw new IOException("Could not create the directory " + lang);
                    }
                    populateLanguageFiles = true;
                }
                f = new ZipFile(this.getFile());
                for (ZipEntry zipEntry : new EnumerationIterable<ZipEntry>(f.entries())) {
                    String fileName;
                    if (zipEntry.isDirectory()) continue;
                    File saveTo = null;
                    if (populateExamples && zipEntry.getName().startsWith("scripts/")) {
                        fileName = zipEntry.getName().substring(zipEntry.getName().indexOf("/") + 1);
                        if (!fileName.startsWith("-")) {
                            fileName = "-" + fileName;
                        }
                        saveTo = new File(this.scriptsFolder, fileName);
                    } else if (populateLanguageFiles && zipEntry.getName().startsWith("lang/") && !zipEntry.getName().endsWith("default.lang")) {
                        fileName = zipEntry.getName().substring(zipEntry.getName().lastIndexOf("/") + 1);
                        saveTo = new File(lang, fileName);
                    } else if (zipEntry.getName().equals("config.sk")) {
                        if (!config.exists()) {
                            saveTo = config;
                        }
                    } else if (zipEntry.getName().startsWith("features.sk") && !features.exists()) {
                        saveTo = features;
                    }
                    if (saveTo == null) continue;
                    try (InputStream in = f.getInputStream(zipEntry);){
                        assert (in != null);
                        FileUtils.save(in, saveTo);
                    }
                }
                Skript.info("Successfully generated the config and the example scripts.");
            }
            catch (ZipException populateExamples) {
            }
            catch (IOException e) {
                Skript.error("Error generating the default files: " + ExceptionUtils.toString(e));
            }
            finally {
                if (f != null) {
                    try {
                        f.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        Skript.getAddonInstance();
        new JavaClasses();
        if (!Skript.checkServerPlatform()) {
            disabled = true;
            this.setEnabled(false);
            return;
        }
        Throwable classLoadError = null;
        try {
            new SkriptClasses();
            new BukkitClasses();
        }
        catch (Throwable e) {
            classLoadError = e;
        }
        SkriptConfig.load();
        if (TestMode.VERBOSITY != null) {
            SkriptLogger.setVerbosity(Verbosity.valueOf(TestMode.VERBOSITY));
        }
        if (this.updater != null) {
            ConsoleCommandSender console = Bukkit.getConsoleSender();
            assert (console != null);
            assert (this.updater != null);
            this.updater.updateCheck((CommandSender)console);
        }
        try {
            Aliases.load();
        }
        catch (StackOverflowError e) {
            if (Skript.using32BitJava()) {
                Skript.error("");
                Skript.error("There was a StackOverflowError that occured while loading aliases.");
                Skript.error("As you are currently using 32-bit Java, please update to 64-bit Java to resolve the error.");
                Skript.error("Please report this issue to our GitHub only if updating to 64-bit Java does not fix the issue.");
                Skript.error("");
            }
            throw e;
        }
        if (classLoadError != null) {
            Skript.exception(classLoadError, new String[0]);
            this.setEnabled(false);
            return;
        }
        PluginCommand skriptCommand = this.getCommand("skript");
        assert (skriptCommand != null);
        skriptCommand.setExecutor((CommandExecutor)new SkriptCommand());
        skriptCommand.setTabCompleter((TabCompleter)new SkriptCommandTabCompleter());
        new BukkitEventValues();
        new DefaultComparators();
        new DefaultConverters();
        new DefaultFunctions();
        new DefaultOperations();
        ChatMessages.registerListeners();
        try {
            Skript.getAddonInstance().loadClasses("ch.njol.skript", "conditions", "effects", "events", "expressions", "entity", "sections", "structures");
        }
        catch (Exception e) {
            Skript.exception((Throwable)e, "Could not load required .class files: " + e.getLocalizedMessage());
            this.setEnabled(false);
            return;
        }
        Commands.registerListeners();
        if (Skript.logNormal()) {
            Skript.info(" " + Language.get("skript.copyright"));
        }
        final long tick = Skript.testing() ? ((World)Bukkit.getWorlds().get(0)).getFullTime() : 0L;
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object c;
                assert (((World)Bukkit.getWorlds().get(0)).getFullTime() == tick);
                try (JarFile jar = new JarFile(Skript.this.getFile());){
                    for (JarEntry e : new EnumerationIterable<JarEntry>(jar.entries())) {
                        if (!e.getName().startsWith("ch/njol/skript/hooks/") || !e.getName().endsWith("Hook.class") || StringUtils.count("" + e.getName(), '/') > 5) continue;
                        c = e.getName().replace('/', '.').substring(0, e.getName().length() - ".class".length());
                        try {
                            Class<?> hook = Class.forName((String)c, true, Skript.this.getClassLoader());
                            if (!Hook.class.isAssignableFrom(hook) || Modifier.isAbstract(hook.getModifiers()) || !Skript.isHookEnabled(hook)) continue;
                            hook.getDeclaredConstructor(new Class[0]).setAccessible(true);
                            hook.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        }
                        catch (ClassNotFoundException ex) {
                            Skript.exception((Throwable)ex, "Cannot load class " + (String)c);
                        }
                        catch (ExceptionInInitializerError err) {
                            Skript.exception(err.getCause(), "Class " + (String)c + " generated an exception while loading");
                        }
                        catch (Exception ex) {
                            Skript.exception((Throwable)ex, "Exception initializing hook: " + (String)c);
                        }
                    }
                }
                catch (IOException e) {
                    Skript.error("Error while loading plugin hooks" + (e.getLocalizedMessage() == null ? "" : ": " + e.getLocalizedMessage()));
                    Skript.exception((Throwable)e, new String[0]);
                }
                finishedLoadingHooks = true;
                if (TestMode.ENABLED) {
                    Skript.info("Preparing Skript for testing...");
                    tainted = true;
                    try {
                        Skript.getAddonInstance().loadClasses("ch.njol.skript.test.runner", new String[0]);
                        if (TestMode.JUNIT) {
                            Skript.getAddonInstance().loadClasses("org.skriptlang.skript.test.junit.registration", new String[0]);
                        }
                    }
                    catch (IOException e) {
                        Skript.exception("Failed to load testing environment.");
                        Bukkit.getServer().shutdown();
                    }
                }
                Skript.stopAcceptingRegistrations();
                Documentation.generate();
                if (Skript.logNormal()) {
                    Skript.info("Loading variables...");
                }
                long vls = System.currentTimeMillis();
                1 h = SkriptLogger.startLogHandler(new ErrorDescLogHandler(){

                    @Override
                    public LogHandler.LogResult log(LogEntry entry) {
                        super.log(entry);
                        if (entry.level.intValue() >= Level.SEVERE.intValue()) {
                            Skript.logEx(entry.message);
                            return LogHandler.LogResult.DO_NOT_LOG;
                        }
                        return LogHandler.LogResult.LOG;
                    }

                    @Override
                    protected void beforeErrors() {
                        Skript.logEx();
                        Skript.logEx("===!!!=== Skript variable load error ===!!!===");
                        Skript.logEx("Unable to load (all) variables:");
                    }

                    @Override
                    protected void afterErrors() {
                        Skript.logEx();
                        Skript.logEx("Skript will work properly, but old variables might not be available at all and new ones may or may not be saved until Skript is able to create a backup of the old file and/or is able to connect to the database (which requires a restart of Skript)!");
                        Skript.logEx();
                    }
                });
                try {
                    c = new CountingLogHandler(SkriptLogger.SEVERE).start();
                    try {
                        if (!Variables.load() && ((CountingLogHandler)c).getCount() == 0) {
                            Skript.error("(no information available)");
                        }
                    }
                    finally {
                        if (c != null) {
                            ((LogHandler)c).close();
                        }
                    }
                }
                finally {
                    h.stop();
                }
                long vld = System.currentTimeMillis() - vls;
                if (Skript.logNormal()) {
                    Skript.info("Loaded " + Variables.numVariables() + " variables in " + (double)(vld / 100L) / 10.0 + " seconds");
                }
                Skript.debug("Early init done");
                if (TestMode.ENABLED) {
                    Bukkit.getScheduler().runTaskLater((Plugin)Skript.this, () -> Skript.info("Skript testing environment enabled, starting soon..."), 1L);
                    Bukkit.getScheduler().runTaskLater((Plugin)Skript.this, () -> {
                        long shutdownDelay = 0L;
                        if (TestMode.GEN_DOCS) {
                            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)"skript gen-docs");
                        } else {
                            if (TestMode.DEV_MODE) {
                                Skript.info("Test development mode enabled. Test scripts are at " + TestMode.TEST_DIR);
                                return;
                            }
                            Skript.info("Loading all tests from " + TestMode.TEST_DIR);
                            CountingLogHandler errorCounter = new CountingLogHandler(Level.SEVERE);
                            try {
                                errorCounter.start();
                                File testDir = TestMode.TEST_DIR.toFile();
                                assert (testDir != null);
                                ScriptLoader.loadScripts(testDir, (OpenCloseable)errorCounter);
                            }
                            finally {
                                errorCounter.stop();
                            }
                            Bukkit.getPluginManager().callEvent((Event)new SkriptTestEvent());
                            if (errorCounter.getCount() > 0) {
                                TestTracker.testStarted("parse scripts");
                                TestTracker.testFailed(errorCounter.getCount() + " error(s) found");
                            }
                            if (errored) {
                                TestTracker.testStarted("run scripts");
                                TestTracker.testFailed("exception was thrown during execution");
                            }
                            if (TestMode.JUNIT) {
                                long size;
                                long ignored;
                                long fails;
                                long tests;
                                long milliseconds;
                                block19: {
                                    Skript.info("Running all JUnit tests...");
                                    milliseconds = 0L;
                                    tests = 0L;
                                    fails = 0L;
                                    ignored = 0L;
                                    size = 0L;
                                    try {
                                        ArrayList classes = Lists.newArrayList((Object[])Utils.getClasses((Plugin)Skript.getInstance(), "org.skriptlang.skript.test", "tests"));
                                        classes.removeIf(Class::isAnonymousClass);
                                        classes.removeIf(Class::isLocalClass);
                                        classes.add(Class.forName("ch.njol.skript.variables.FlatFileStorageTest"));
                                        size = classes.size();
                                        for (Class clazz : classes) {
                                            String test = clazz.getName();
                                            SkriptJUnitTest.setCurrentJUnitTest(test);
                                            SkriptJUnitTest.setShutdownDelay(0L);
                                            Skript.info("Running JUnit test '" + test + "'");
                                            Result junit = JUnitCore.runClasses((Class[])new Class[]{clazz});
                                            TestTracker.testStarted("JUnit: '" + test + "'");
                                            boolean overrides = false;
                                            for (Method method : clazz.getDeclaredMethods()) {
                                                if (!method.isAnnotationPresent(After.class)) continue;
                                                if (SkriptJUnitTest.getShutdownDelay() > 1L) {
                                                    Skript.warning("Using @After in JUnit classes, happens instantaneously, and JUnit class '" + test + "' requires a delay. Do your test cleanup in the script junit file or 'cleanup' method.");
                                                }
                                                if (!method.getName().equals("cleanup")) continue;
                                                overrides = true;
                                            }
                                            if (SkriptJUnitTest.getShutdownDelay() > 1L && !overrides) {
                                                Skript.error("The JUnit class '" + test + "' does not override the method 'cleanup' thus the test data will instantly be cleaned up. This JUnit test requires longer shutdown time: " + SkriptJUnitTest.getShutdownDelay());
                                            }
                                            shutdownDelay = Math.max(shutdownDelay, SkriptJUnitTest.getShutdownDelay());
                                            tests += (long)junit.getRunCount();
                                            milliseconds += junit.getRunTime();
                                            ignored += (long)junit.getIgnoreCount();
                                            fails += (long)junit.getFailureCount();
                                            junit.getFailures().forEach(failure -> {
                                                String message = failure.getMessage() == null ? "" : " " + failure.getMessage();
                                                TestTracker.JUnitTestFailed(test, message);
                                                Skript.exception(failure.getException(), "JUnit test '" + failure.getTestHeader() + " failed.");
                                            });
                                            SkriptJUnitTest.clearJUnitTest();
                                        }
                                    }
                                    catch (IOException e) {
                                        Skript.exception((Throwable)e, "Failed to execute JUnit runtime tests.");
                                    }
                                    catch (ClassNotFoundException e) {
                                        if ($assertionsDisabled) break block19;
                                        throw new AssertionError((Object)"Class 'ch.njol.skript.variables.FlatFileStorageTest' was not found.");
                                    }
                                }
                                if (ignored > 0L) {
                                    Skript.warning("There were " + ignored + " ignored test cases! This can mean they are not properly setup in order in that class!");
                                }
                                Skript.info("Completed " + tests + " JUnit tests in " + size + " classes with " + fails + " failures in " + milliseconds + " milliseconds.");
                            }
                        }
                        double display = shutdownDelay / 20L;
                        Skript.info("Testing done, shutting down the server in " + display + " second" + (display <= 1.0 ? "" : "s") + "...");
                        Bukkit.getScheduler().runTaskLater((Plugin)Skript.this, () -> {
                            if (TestMode.JUNIT && !EffObjectives.isJUnitComplete()) {
                                EffObjectives.fail();
                            }
                            Skript.info("Collecting results to " + TestMode.RESULTS_FILE);
                            String results = new Gson().toJson((Object)TestTracker.collectResults());
                            try {
                                Files.write(TestMode.RESULTS_FILE, results.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                            }
                            catch (IOException e) {
                                Skript.exception((Throwable)e, "Failed to write test results.");
                            }
                            Bukkit.getServer().shutdown();
                        }, shutdownDelay);
                    }, 100L);
                }
                Metrics metrics = new Metrics(Skript.this, 722);
                metrics.addCustomChart(new SimplePie("pluginLanguage", Language::getName));
                metrics.addCustomChart(new SimplePie("effectCommands", () -> SkriptConfig.enableEffectCommands.value().toString()));
                metrics.addCustomChart(new SimplePie("uuidsWithPlayers", () -> SkriptConfig.usePlayerUUIDsInVariableNames.value().toString()));
                metrics.addCustomChart(new SimplePie("playerVariableFix", () -> SkriptConfig.enablePlayerVariableFix.value().toString()));
                metrics.addCustomChart(new SimplePie("logVerbosity", () -> SkriptConfig.verbosity.value().name().toLowerCase(Locale.ENGLISH).replace('_', ' ')));
                metrics.addCustomChart(new SimplePie("pluginPriority", () -> SkriptConfig.defaultEventPriority.value().name().toLowerCase(Locale.ENGLISH).replace('_', ' ')));
                metrics.addCustomChart(new SimplePie("logPlayerCommands", () -> String.valueOf(SkriptConfig.logEffectCommands.value() != false || SkriptConfig.logPlayerCommands.value() != false)));
                metrics.addCustomChart(new SimplePie("maxTargetDistance", () -> SkriptConfig.maxTargetBlockDistance.value().toString()));
                metrics.addCustomChart(new SimplePie("softApiExceptions", () -> SkriptConfig.apiSoftExceptions.value().toString()));
                metrics.addCustomChart(new SimplePie("timingsStatus", () -> {
                    if (!Skript.classExists("co.aikar.timings.Timings")) {
                        return "unsupported";
                    }
                    return SkriptConfig.enableTimings.value().toString();
                }));
                metrics.addCustomChart(new SimplePie("parseLinks", () -> ChatMessages.linkParseMode.name().toLowerCase(Locale.ENGLISH)));
                metrics.addCustomChart(new SimplePie("colorResetCodes", () -> SkriptConfig.colorResetCodes.value().toString()));
                metrics.addCustomChart(new SimplePie("functionsWithNulls", () -> SkriptConfig.executeFunctionsWithMissingParams.value().toString()));
                metrics.addCustomChart(new SimplePie("buildFlavor", () -> {
                    if (Skript.this.updater != null) {
                        return ((Skript)Skript.this).updater.getCurrentRelease().flavor;
                    }
                    return "unknown";
                }));
                metrics.addCustomChart(new SimplePie("updateCheckerEnabled", () -> SkriptConfig.checkForNewVersion.value().toString()));
                metrics.addCustomChart(new SimplePie("releaseChannel", SkriptConfig.releaseChannel::value));
                Skript.metrics = metrics;
                Date start = new Date();
                CountingLogHandler logHandler = new CountingLogHandler(Level.SEVERE);
                File scriptsFolder = Skript.this.getScriptsFolder();
                ScriptLoader.updateDisabledScripts(scriptsFolder.toPath());
                ScriptLoader.loadScripts(scriptsFolder, (OpenCloseable)logHandler).thenAccept(scriptInfo -> {
                    try {
                        if (logHandler.getCount() == 0) {
                            Skript.info(m_no_errors.toString());
                        }
                        if (scriptInfo.files == 0) {
                            Skript.warning(m_no_scripts.toString());
                        }
                        if (Skript.logNormal() && scriptInfo.files > 0) {
                            Skript.info(m_scripts_loaded.toString(scriptInfo.files, scriptInfo.structures, start.difference(new Date())));
                        }
                        Skript.info(m_finished_loading.toString());
                        if (!ScriptLoader.isAsync()) {
                            EvtSkript.onSkriptStart();
                            Filter filter = record -> {
                                if (record == null) {
                                    return false;
                                }
                                return record.getMessage() == null || !record.getMessage().toLowerCase(Locale.ENGLISH).startsWith("can't keep up!");
                            };
                            BukkitLoggerFilter.addFilter(filter);
                            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Skript.this, () -> BukkitLoggerFilter.removeFilter(filter), 1L);
                        } else {
                            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Skript.this, EvtSkript::onSkriptStart);
                        }
                    }
                    catch (Exception e) {
                        throw Skript.exception((Throwable)e, new String[0]);
                    }
                });
            }
        });
        Bukkit.getPluginManager().registerEvents(new Listener(){

            @EventHandler
            public void onJoin(final PlayerJoinEvent e) {
                if (e.getPlayer().hasPermission("skript.admin")) {
                    new Task((Plugin)Skript.this, 0L){

                        @Override
                        public void run() {
                            Player p = e.getPlayer();
                            SkriptUpdater updater = Skript.this.getUpdater();
                            if (updater == null) {
                                return;
                            }
                            if (updater.getReleaseStatus() == ReleaseStatus.OUTDATED) {
                                UpdateManifest update = updater.getUpdateManifest();
                                assert (update != null);
                                Skript.info((CommandSender)p, "" + SkriptUpdater.m_update_available.toString(update.id, Skript.getVersion()));
                                p.spigot().sendMessage(BungeeConverter.convert(ChatMessages.parseToArray("Download it at: <aqua><u><link:" + update.downloadUrl + ">" + update.downloadUrl)));
                            }
                        }
                    };
                }
            }
        }, (Plugin)this);
        SkriptTimings.setSkript(this);
    }

    private void handleJvmArguments() {
        Path folder = this.getDataFolder().toPath();
        String burgerEnabled = System.getProperty("skript.burger.enable");
        if (burgerEnabled != null) {
            String burgerInput;
            tainted = true;
            String version = System.getProperty("skript.burger.version");
            if (version == null) {
                String inputFile = System.getProperty("skript.burger.file");
                if (inputFile == null) {
                    Skript.exception("burger enabled but skript.burger.file not provided");
                    return;
                }
                try {
                    burgerInput = new String(Files.readAllBytes(Paths.get(inputFile, new String[0])), StandardCharsets.UTF_8);
                }
                catch (IOException e) {
                    Skript.exception((Throwable)e, new String[0]);
                    return;
                }
            }
            try {
                Path data = folder.resolve("burger-" + version + ".json");
                if (!Files.exists(data, new LinkOption[0])) {
                    URL url = new URL("https://pokechu22.github.io/Burger/" + version + ".json");
                    try (InputStream is = url.openStream();){
                        Files.copy(is, data, new CopyOption[0]);
                    }
                }
                burgerInput = new String(Files.readAllBytes(data), StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                Skript.exception((Throwable)e, new String[0]);
                return;
            }
            try {
                BurgerHelper burger = new BurgerHelper(burgerInput);
                Map<String, Material> materials = burger.mapMaterials();
                Map<Integer, Material> ids = BurgerHelper.mapIds();
                Gson gson = new Gson();
                Files.write(folder.resolve("materials_mappings.json"), gson.toJson(materials).getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE);
                Files.write(folder.resolve("id_mappings.json"), gson.toJson(ids).getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE);
            }
            catch (IOException e) {
                Skript.exception((Throwable)e, new String[0]);
            }
        }
    }

    public static Version getMinecraftVersion() {
        return minecraftVersion;
    }

    public static boolean isRunningCraftBukkit() {
        return serverPlatform == ServerPlatform.BUKKIT_CRAFTBUKKIT;
    }

    public static boolean isRunningMinecraft(int major, int minor) {
        if (minecraftVersion.compareTo(UNKNOWN_VERSION) == 0) {
            Skript.updateMinecraftVersion();
        }
        return minecraftVersion.compareTo(major, minor) >= 0;
    }

    public static boolean isRunningMinecraft(int major, int minor, int revision) {
        if (minecraftVersion.compareTo(UNKNOWN_VERSION) == 0) {
            Skript.updateMinecraftVersion();
        }
        return minecraftVersion.compareTo(major, minor, revision) >= 0;
    }

    public static boolean isRunningMinecraft(Version v) {
        if (minecraftVersion.compareTo(UNKNOWN_VERSION) == 0) {
            Skript.updateMinecraftVersion();
        }
        return minecraftVersion.compareTo(v) >= 0;
    }

    @Deprecated
    public static boolean supports(String className) {
        return Skript.classExists(className);
    }

    public static boolean classExists(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean methodExists(Class<?> c, String methodName, Class<?> ... parameterTypes) {
        try {
            c.getDeclaredMethod(methodName, parameterTypes);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public static boolean methodExists(Class<?> c, String methodName, Class<?>[] parameterTypes, Class<?> returnType) {
        try {
            Method m = c.getDeclaredMethod(methodName, parameterTypes);
            return m.getReturnType() == returnType;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public static boolean fieldExists(Class<?> c, String fieldName) {
        try {
            c.getDeclaredField(fieldName);
            return true;
        }
        catch (NoSuchFieldException e) {
            return false;
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public static @Nullable Metrics getMetrics() {
        return metrics;
    }

    public static void closeOnDisable(Closeable closeable) {
        closeOnDisable.add(closeable);
    }

    @EventHandler
    public void onPluginDisable(PluginDisableEvent event) {
        Plugin plugin = event.getPlugin();
        PluginDescriptionFile descriptionFile = plugin.getDescription();
        if ((descriptionFile.getDepend().contains("Skript") || descriptionFile.getSoftDepend().contains("Skript")) && !this.isServerRunning()) {
            this.beforeDisable();
        }
    }

    private boolean isServerRunning() {
        if (IS_STOPPING_EXISTS) {
            return !Bukkit.getServer().isStopping();
        }
        try {
            return (Boolean)IS_RUNNING.invoke(MC_SERVER, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private void beforeDisable() {
        partDisabled = true;
        EvtSkript.onSkriptStop();
        ScriptLoader.unloadScripts(ScriptLoader.getLoadedScripts());
    }

    public void onDisable() {
        if (disabled) {
            return;
        }
        disabled = true;
        if (!partDisabled) {
            this.beforeDisable();
        }
        Bukkit.getScheduler().cancelTasks((Plugin)this);
        for (Closeable c : closeOnDisable) {
            try {
                c.close();
            }
            catch (Exception e) {
                Skript.exception((Throwable)e, "An error occurred while shutting down.", "This might or might not cause any issues.");
            }
        }
    }

    public static void outdatedError() {
        Skript.error("Skript v" + Skript.getInstance().getDescription().getVersion() + " is not fully compatible with Bukkit " + Bukkit.getVersion() + ". Some feature(s) will be broken until you update Skript.");
    }

    public static void outdatedError(Exception e) {
        Skript.outdatedError();
        if (Skript.testing()) {
            e.printStackTrace();
        }
    }

    public static String toString(double n) {
        return StringUtils.toString(n, SkriptConfig.numberAccuracy.value());
    }

    public static Thread newThread(Runnable r, String name) {
        Thread t = new Thread(r, name);
        t.setUncaughtExceptionHandler(UEH);
        return t;
    }

    public static boolean isAcceptRegistrations() {
        if (instance == null) {
            throw new IllegalStateException("Skript was never loaded");
        }
        return acceptRegistrations && instance.isEnabled();
    }

    public static void checkAcceptRegistrations() {
        if (!Skript.isAcceptRegistrations() && !Skript.testing()) {
            throw new SkriptAPIException("Registration can only be done during plugin initialization");
        }
    }

    private static void stopAcceptingRegistrations() {
        Converters.createChainedConverters();
        acceptRegistrations = false;
        Classes.onRegistrationsStop();
    }

    public static SkriptAddon registerAddon(JavaPlugin p) {
        Skript.checkAcceptRegistrations();
        if (addons.containsKey(p.getName())) {
            throw new IllegalArgumentException("The plugin " + p.getName() + " is already registered");
        }
        SkriptAddon addon = new SkriptAddon(p);
        addons.put(p.getName(), addon);
        return addon;
    }

    public static @Nullable SkriptAddon getAddon(JavaPlugin p) {
        return addons.get(p.getName());
    }

    public static @Nullable SkriptAddon getAddon(String name) {
        return addons.get(name);
    }

    public static Collection<SkriptAddon> getAddons() {
        return Collections.unmodifiableCollection(addons.values());
    }

    public static SkriptAddon getAddonInstance() {
        if (addon == null) {
            addon = new SkriptAddon(Skript.getInstance());
            addon.setLanguageFileDirectory("lang");
        }
        return addon;
    }

    public static <E extends Condition> void registerCondition(Class<E> condition, String ... patterns) throws IllegalArgumentException {
        Skript.checkAcceptRegistrations();
        String originClassPath = Thread.currentThread().getStackTrace()[2].getClassName();
        SyntaxElementInfo<E> info = new SyntaxElementInfo<E>(patterns, condition, originClassPath);
        conditions.add(info);
        statements.add(info);
    }

    public static <E extends Effect> void registerEffect(Class<E> effect, String ... patterns) throws IllegalArgumentException {
        Skript.checkAcceptRegistrations();
        String originClassPath = Thread.currentThread().getStackTrace()[2].getClassName();
        SyntaxElementInfo<E> info = new SyntaxElementInfo<E>(patterns, effect, originClassPath);
        effects.add(info);
        statements.add(info);
    }

    public static <E extends Section> void registerSection(Class<E> section, String ... patterns) throws IllegalArgumentException {
        Skript.checkAcceptRegistrations();
        String originClassPath = Thread.currentThread().getStackTrace()[2].getClassName();
        SyntaxElementInfo<E> info = new SyntaxElementInfo<E>(patterns, section, originClassPath);
        sections.add(info);
    }

    public static Collection<SyntaxElementInfo<? extends Statement>> getStatements() {
        return statements;
    }

    public static Collection<SyntaxElementInfo<? extends Condition>> getConditions() {
        return conditions;
    }

    public static Collection<SyntaxElementInfo<? extends Effect>> getEffects() {
        return effects;
    }

    public static Collection<SyntaxElementInfo<? extends Section>> getSections() {
        return sections;
    }

    public static <E extends Expression<T>, T> void registerExpression(Class<E> c, Class<T> returnType, ExpressionType type, String ... patterns) throws IllegalArgumentException {
        Skript.checkAcceptRegistrations();
        if (returnType.isAnnotation() || returnType.isArray() || returnType.isPrimitive()) {
            throw new IllegalArgumentException("returnType must be a normal type");
        }
        String originClassPath = Thread.currentThread().getStackTrace()[2].getClassName();
        ExpressionInfo<E, T> info = new ExpressionInfo<E, T>(patterns, returnType, c, originClassPath, type);
        expressions.add(expressionTypesStartIndices[type.ordinal()], info);
        int i = type.ordinal();
        while (i < ExpressionType.values().length) {
            int n = i++;
            expressionTypesStartIndices[n] = expressionTypesStartIndices[n] + 1;
        }
    }

    public static Iterator<ExpressionInfo<?, ?>> getExpressions() {
        return expressions.iterator();
    }

    public static Iterator<ExpressionInfo<?, ?>> getExpressions(final Class<?> ... returnTypes) {
        return new CheckedIterator(Skript.getExpressions(), new NullableChecker<ExpressionInfo<?, ?>>(){

            @Override
            public boolean check(@Nullable ExpressionInfo<?, ?> i) {
                if (i == null || i.returnType == Object.class) {
                    return true;
                }
                for (Class returnType : returnTypes) {
                    assert (returnType != null);
                    if (!Converters.converterExists(i.returnType, returnType)) continue;
                    return true;
                }
                return false;
            }
        });
    }

    public static <E extends SkriptEvent> SkriptEventInfo<E> registerEvent(String name, Class<E> c, Class<? extends Event> event, String ... patterns) {
        return Skript.registerEvent(name, c, new Class[]{event}, patterns);
    }

    public static <E extends SkriptEvent> SkriptEventInfo<E> registerEvent(String name, Class<E> c, Class<? extends Event>[] events, String ... patterns) {
        Skript.checkAcceptRegistrations();
        String originClassPath = Thread.currentThread().getStackTrace()[2].getClassName();
        String[] transformedPatterns = new String[patterns.length];
        for (int i = 0; i < patterns.length; ++i) {
            transformedPatterns[i] = SkriptEvent.fixPattern(patterns[i]);
        }
        SkriptEventInfo<E> r = new SkriptEventInfo<E>(name, transformedPatterns, c, originClassPath, events);
        Skript.events.add(r);
        return r;
    }

    public static <E extends Structure> void registerStructure(Class<E> c, String ... patterns) {
        Skript.checkAcceptRegistrations();
        String originClassPath = Thread.currentThread().getStackTrace()[2].getClassName();
        StructureInfo<E> structureInfo = new StructureInfo<E>(patterns, c, originClassPath);
        structures.add(structureInfo);
    }

    public static <E extends Structure> void registerStructure(Class<E> c, EntryValidator entryValidator, String ... patterns) {
        Skript.checkAcceptRegistrations();
        String originClassPath = Thread.currentThread().getStackTrace()[2].getClassName();
        StructureInfo<E> structureInfo = new StructureInfo<E>(patterns, c, originClassPath, entryValidator);
        structures.add(structureInfo);
    }

    public static Collection<SkriptEventInfo<?>> getEvents() {
        return events;
    }

    public static List<StructureInfo<? extends Structure>> getStructures() {
        return structures;
    }

    public static boolean dispatchCommand(CommandSender sender, String command) {
        try {
            if (sender instanceof Player) {
                PlayerCommandPreprocessEvent e = new PlayerCommandPreprocessEvent((Player)sender, "/" + command);
                Bukkit.getPluginManager().callEvent((Event)e);
                if (e.isCancelled() || !e.getMessage().startsWith("/")) {
                    return false;
                }
                return Bukkit.dispatchCommand((CommandSender)e.getPlayer(), (String)e.getMessage().substring(1));
            }
            ServerCommandEvent e = new ServerCommandEvent(sender, command);
            Bukkit.getPluginManager().callEvent((Event)e);
            if (e.getCommand().isEmpty() || e.isCancelled()) {
                return false;
            }
            return Bukkit.dispatchCommand((CommandSender)e.getSender(), (String)e.getCommand());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static boolean logNormal() {
        return SkriptLogger.log(Verbosity.NORMAL);
    }

    public static boolean logHigh() {
        return SkriptLogger.log(Verbosity.HIGH);
    }

    public static boolean logVeryHigh() {
        return SkriptLogger.log(Verbosity.VERY_HIGH);
    }

    public static boolean debug() {
        return SkriptLogger.debug();
    }

    public static boolean testing() {
        return Skript.debug() || Skript.class.desiredAssertionStatus();
    }

    public static boolean log(Verbosity minVerb) {
        return SkriptLogger.log(minVerb);
    }

    public static void debug(String info) {
        if (!Skript.debug()) {
            return;
        }
        SkriptLogger.log(SkriptLogger.DEBUG, info);
    }

    public static void info(String info) {
        SkriptLogger.log(Level.INFO, info);
    }

    public static void warning(String warning) {
        SkriptLogger.log(Level.WARNING, warning);
    }

    public static void error(@Nullable String error) {
        if (error != null) {
            SkriptLogger.log(Level.SEVERE, error);
        }
    }

    public static void error(String error, ErrorQuality quality) {
        SkriptLogger.log(new LogEntry(SkriptLogger.SEVERE, quality, error));
    }

    public static EmptyStacktraceException exception(String ... info) {
        return Skript.exception(null, info);
    }

    public static EmptyStacktraceException exception(@Nullable Throwable cause, String ... info) {
        return Skript.exception(cause, null, null, info);
    }

    public static EmptyStacktraceException exception(@Nullable Throwable cause, @Nullable Thread thread, String ... info) {
        return Skript.exception(cause, thread, null, info);
    }

    public static EmptyStacktraceException exception(@Nullable Throwable cause, @Nullable TriggerItem item, String ... info) {
        return Skript.exception(cause, null, item, info);
    }

    public static void markErrored() {
        errored = true;
    }

    public static EmptyStacktraceException exception(@Nullable Throwable cause, @Nullable Thread thread, @Nullable TriggerItem item, String ... info) {
        errored = true;
        if (cause instanceof EmptyStacktraceException) {
            return new EmptyStacktraceException();
        }
        if (!checkedPlugins) {
            for (Plugin plugin : Bukkit.getPluginManager().getPlugins()) {
                PluginDescriptionFile desc;
                if (plugin.getName().equals("Skript") || !(desc = plugin.getDescription()).getDepend().contains("Skript") && !desc.getSoftDepend().contains("Skript")) continue;
                String[] parts = desc.getMain().split("\\.");
                StringBuilder name = new StringBuilder(desc.getMain().length());
                for (int i = 0; i < parts.length - 1; ++i) {
                    name.append(parts[i]).append('.');
                }
                pluginPackages.put(name.toString(), desc);
                if (!Skript.debug()) continue;
                Skript.info("Identified potential addon: " + desc.getFullName() + " (" + name.toString() + ")");
            }
            checkedPlugins = true;
        }
        String issuesUrl = "https://github.com/SkriptLang/Skript/issues";
        Skript.logEx();
        Skript.logEx("[Skript] Severe Error:");
        Skript.logEx(info);
        Skript.logEx();
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        HashSet<PluginDescriptionFile> stackPlugins = new HashSet<PluginDescriptionFile>();
        for (StackTraceElement s : stackTrace) {
            for (Map.Entry<String, PluginDescriptionFile> entry : pluginPackages.entrySet()) {
                if (!s.getClassName().contains(entry.getKey())) continue;
                stackPlugins.add(entry.getValue());
            }
        }
        SkriptUpdater skriptUpdater = Skript.getInstance().getUpdater();
        if (tainted) {
            Skript.logEx("Skript is running with developer command-line options.");
            Skript.logEx("If you are not a developer, consider disabling them.");
        } else if (Skript.getInstance().getDescription().getVersion().contains("nightly")) {
            Skript.logEx("You're running a (buggy) nightly version of Skript.");
            Skript.logEx("If this is not a test server, switch to a more stable release NOW!");
            Skript.logEx("Your players are unlikely to appreciate crashes and/or data loss due to Skript bugs.");
            Skript.logEx("");
            Skript.logEx("Just testing things? Good. Please report this bug, so that we can fix it before a stable release.");
            Skript.logEx("Issue tracker: " + issuesUrl);
        } else if (!Skript.isRunningMinecraft(1, 9)) {
            Skript.logEx("You are running an outdated Minecraft version not supported by Skript.");
            Skript.logEx("Please update to Minecraft 1.9.4 or later or fix this yourself and send us a pull request.");
            Skript.logEx("Alternatively, use an older Skript version; do note that those are also unsupported by us.");
            Skript.logEx("");
            Skript.logEx("Again, we do not support Minecraft versions this old.");
        } else if (!Skript.serverPlatform.supported) {
            Skript.logEx("Your server platform appears to be unsupported by Skript. It might not work reliably.");
            Skript.logEx("You can report this at " + issuesUrl + ". However, we may be unable to fix the issue.");
            Skript.logEx("It is recommended that you switch to Paper or Spigot, should you encounter more problems.");
        } else if (skriptUpdater != null && skriptUpdater.getReleaseStatus() == ReleaseStatus.OUTDATED) {
            Skript.logEx("You're running outdated version of Skript! Please try updating it NOW; it might fix this.");
            Skript.logEx("Run /sk update check to get a download link to latest Skript!");
            Skript.logEx("You will be given instructions how to report this error if it persists after update.");
        } else {
            Skript.logEx("Something went horribly wrong with Skript.");
            Skript.logEx("This issue is NOT your fault! You probably can't fix it yourself, either.");
            if (pluginPackages.isEmpty()) {
                Skript.logEx("You should report it at " + issuesUrl + ". Please copy paste this report there (or use paste service).");
                Skript.logEx("This ensures that your issue is noticed and will be fixed as soon as possible.");
            } else {
                StringBuilder pluginsMessage;
                Skript.logEx("It looks like you are using some plugin(s) that alter how Skript works (addons).");
                if (stackPlugins.isEmpty()) {
                    Skript.logEx("Here is full list of them:");
                    pluginsMessage = new StringBuilder();
                    for (PluginDescriptionFile desc : pluginPackages.values()) {
                        pluginsMessage.append(desc.getFullName());
                        String website = desc.getWebsite();
                        if (website != null && !website.isEmpty()) {
                            pluginsMessage.append(" (").append(desc.getWebsite()).append(")");
                        }
                        pluginsMessage.append(" ");
                    }
                    Skript.logEx(pluginsMessage.toString());
                    Skript.logEx("We could not identify which of those are specially related, so this might also be Skript issue.");
                } else {
                    Skript.logEx("Following plugins are probably related to this error in some way:");
                    pluginsMessage = new StringBuilder();
                    for (PluginDescriptionFile desc : stackPlugins) {
                        pluginsMessage.append(desc.getName());
                        String website = desc.getWebsite();
                        if (website != null && !website.isEmpty()) {
                            pluginsMessage.append(" (").append(desc.getWebsite()).append(")");
                        }
                        pluginsMessage.append(" ");
                    }
                    Skript.logEx(pluginsMessage.toString());
                }
                Skript.logEx("You should try disabling those plugins one by one, trying to find which one causes it.");
                Skript.logEx("If the error doesn't disappear even after disabling all listed plugins, it is probably Skript issue.");
                Skript.logEx("In that case, you will be given instruction on how should you report it.");
                Skript.logEx("On the other hand, if the error disappears when disabling some plugin, report it to author of that plugin.");
                Skript.logEx("Only if the author tells you to do so, report it to Skript's issue tracker.");
            }
        }
        Skript.logEx();
        Skript.logEx("Stack trace:");
        if (cause == null || cause.getStackTrace().length == 0) {
            Skript.logEx("  warning: no/empty exception given, dumping current stack trace instead");
            cause = new Exception(cause);
        }
        boolean first = true;
        while (cause != null) {
            Skript.logEx((first ? "" : "Caused by: ") + cause.toString());
            for (StackTraceElement stackTraceElement : cause.getStackTrace()) {
                Skript.logEx("    at " + stackTraceElement.toString());
            }
            cause = cause.getCause();
            first = false;
        }
        Skript.logEx();
        Skript.logEx("Version Information:");
        if (skriptUpdater != null) {
            ReleaseStatus status = skriptUpdater.getReleaseStatus();
            Skript.logEx("  Skript: " + Skript.getVersion() + (status == ReleaseStatus.LATEST ? " (latest)" : (status == ReleaseStatus.OUTDATED ? " (OUTDATED)" : (status == ReleaseStatus.CUSTOM ? " (custom version)" : ""))));
            ReleaseManifest current = skriptUpdater.getCurrentRelease();
            Skript.logEx("    Flavor: " + current.flavor);
            Skript.logEx("    Date: " + current.date);
        } else {
            Skript.logEx("  Skript: " + Skript.getVersion() + " (unknown; likely custom)");
        }
        Skript.logEx("  Bukkit: " + Bukkit.getBukkitVersion());
        Skript.logEx("  Minecraft: " + Skript.getMinecraftVersion());
        Skript.logEx("  Java: " + System.getProperty("java.version") + " (" + System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version") + ")");
        Skript.logEx("  OS: " + System.getProperty("os.name") + " " + System.getProperty("os.arch") + " " + System.getProperty("os.version"));
        Skript.logEx();
        Skript.logEx("Server platform: " + Skript.serverPlatform.name + (Skript.serverPlatform.supported ? "" : " (unsupported)"));
        Skript.logEx();
        Skript.logEx("Current node: " + SkriptLogger.getNode());
        Skript.logEx("Current item: " + (item == null ? "null" : item.toString(null, true)));
        if (item != null && item.getTrigger() != null) {
            Trigger trigger = item.getTrigger();
            Script script = trigger.getScript();
            Skript.logEx("Current trigger: " + trigger.toString(null, true) + " (" + (script == null ? "null" : script.getConfig().getFileName()) + ", line " + trigger.getLineNumber() + ")");
        }
        Skript.logEx();
        Skript.logEx("Thread: " + (thread == null ? Thread.currentThread() : thread).getName());
        Skript.logEx();
        Skript.logEx("Language: " + Language.getName());
        Skript.logEx("Link parse mode: " + (Object)((Object)ChatMessages.linkParseMode));
        Skript.logEx();
        Skript.logEx("End of Error.");
        Skript.logEx();
        return new EmptyStacktraceException();
    }

    static void logEx() {
        SkriptLogger.LOGGER.severe(EXCEPTION_PREFIX);
    }

    static void logEx(String ... lines) {
        for (String line : lines) {
            SkriptLogger.LOGGER.severe(EXCEPTION_PREFIX + line);
        }
    }

    public static String getSkriptPrefix() {
        return SKRIPT_PREFIX_MESSAGE.getValueOrDefault("<grey>[<gold>Skript<grey>] <reset>");
    }

    public static void info(CommandSender sender, String info) {
        sender.sendMessage(Utils.replaceEnglishChatStyles(Skript.getSkriptPrefix() + info));
    }

    public static void broadcast(String message, String permission) {
        Bukkit.broadcast((String)Utils.replaceEnglishChatStyles(Skript.getSkriptPrefix() + message), (String)permission);
    }

    public static void adminBroadcast(String message) {
        Skript.broadcast(message, "skript.admin");
    }

    public static void message(CommandSender sender, String info) {
        sender.sendMessage(Utils.replaceEnglishChatStyles(info));
    }

    public static void error(CommandSender sender, String error) {
        sender.sendMessage(Utils.replaceEnglishChatStyles(Skript.getSkriptPrefix() + ChatColor.DARK_RED + error));
    }

    public @Nullable SkriptUpdater getUpdater() {
        return this.updater;
    }

    static {
        closeOnDisable = Collections.synchronizedCollection(new ArrayList());
        IS_STOPPING_EXISTS = Skript.methodExists(Server.class, "isStopping", new Class[0]);
        if (!IS_STOPPING_EXISTS) {
            Method serverMethod;
            Server server = Bukkit.getServer();
            Class<?> clazz = server.getClass();
            try {
                serverMethod = clazz.getMethod("getServer", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            try {
                MC_SERVER = serverMethod.invoke((Object)server, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            try {
                String isRunningMethod = "isRunning";
                if (Skript.isRunningMinecraft(1, 20)) {
                    isRunningMethod = "v";
                } else if (Skript.isRunningMinecraft(1, 19)) {
                    isRunningMethod = "u";
                } else if (Skript.isRunningMinecraft(1, 18)) {
                    isRunningMethod = "v";
                }
                IS_RUNNING = MC_SERVER.getClass().getMethod(isRunningMethod, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
        UEH = new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(@Nullable Thread t, @Nullable Throwable e) {
                Skript.exception(e, "Exception in thread " + (t == null ? null : t.getName()));
            }
        };
        acceptRegistrations = true;
        addons = new HashMap();
        conditions = new ArrayList<SyntaxElementInfo<? extends Condition>>(50);
        effects = new ArrayList<SyntaxElementInfo<? extends Effect>>(50);
        statements = new ArrayList<SyntaxElementInfo<? extends Statement>>(100);
        sections = new ArrayList<SyntaxElementInfo<? extends Section>>(50);
        expressions = new ArrayList(100);
        expressionTypesStartIndices = new int[ExpressionType.values().length];
        events = new ArrayList(50);
        structures = new ArrayList<StructureInfo<? extends Structure>>(10);
        pluginPackages = new HashMap<String, PluginDescriptionFile>();
        checkedPlugins = false;
        tainted = false;
        errored = false;
        SKRIPT_PREFIX_MESSAGE = new Message("skript.prefix");
    }
}

