/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.bukkitutil;

import ch.njol.skript.Skript;
import java.util.HashMap;
import org.bukkit.Material;
import org.bukkit.TreeType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.eclipse.jdt.annotation.Nullable;

public class ItemUtils {
    private static final boolean IS_AIR_EXISTS = Skript.methodExists(Material.class, "isAir", new Class[0]);
    private static final HashMap<TreeType, Material> TREE_TO_SAPLING_MAP = new HashMap();

    public static int getDamage(ItemStack stack) {
        ItemMeta meta = stack.getItemMeta();
        if (meta instanceof Damageable) {
            return ((Damageable)meta).getDamage();
        }
        return 0;
    }

    public static void setDamage(ItemStack stack, int damage) {
        ItemMeta meta = stack.getItemMeta();
        if (meta instanceof Damageable) {
            ((Damageable)meta).setDamage(damage);
            stack.setItemMeta(meta);
        }
    }

    public static @Nullable Material asBlock(Material type) {
        if (type.isBlock()) {
            return type;
        }
        return null;
    }

    public static Material asItem(Material type) {
        return type;
    }

    public static boolean itemStacksEqual(@Nullable ItemStack is1, @Nullable ItemStack is2) {
        if (is1 == null || is2 == null) {
            return is1 == is2;
        }
        return is1.getType() == is2.getType() && ItemUtils.getDamage(is1) == ItemUtils.getDamage(is2) && is1.getItemMeta().equals(is2.getItemMeta());
    }

    public static boolean isAir(Material type) {
        if (IS_AIR_EXISTS) {
            return type.isAir();
        }
        return type == Material.AIR || type == Material.CAVE_AIR || type == Material.VOID_AIR;
    }

    public static Material getTreeSapling(TreeType treeType) {
        return TREE_TO_SAPLING_MAP.get(treeType);
    }

    static {
        TREE_TO_SAPLING_MAP.put(TreeType.TREE, Material.OAK_SAPLING);
        TREE_TO_SAPLING_MAP.put(TreeType.BIG_TREE, Material.OAK_SAPLING);
        TREE_TO_SAPLING_MAP.put(TreeType.SWAMP, Material.OAK_SAPLING);
        TREE_TO_SAPLING_MAP.put(TreeType.REDWOOD, Material.SPRUCE_SAPLING);
        TREE_TO_SAPLING_MAP.put(TreeType.TALL_REDWOOD, Material.SPRUCE_SAPLING);
        TREE_TO_SAPLING_MAP.put(TreeType.MEGA_REDWOOD, Material.SPRUCE_SAPLING);
        TREE_TO_SAPLING_MAP.put(TreeType.BIRCH, Material.BIRCH_SAPLING);
        TREE_TO_SAPLING_MAP.put(TreeType.TALL_BIRCH, Material.BIRCH_SAPLING);
        TREE_TO_SAPLING_MAP.put(TreeType.JUNGLE, Material.JUNGLE_SAPLING);
        TREE_TO_SAPLING_MAP.put(TreeType.SMALL_JUNGLE, Material.JUNGLE_SAPLING);
        TREE_TO_SAPLING_MAP.put(TreeType.JUNGLE_BUSH, Material.JUNGLE_SAPLING);
        TREE_TO_SAPLING_MAP.put(TreeType.COCOA_TREE, Material.JUNGLE_SAPLING);
        TREE_TO_SAPLING_MAP.put(TreeType.ACACIA, Material.ACACIA_SAPLING);
        TREE_TO_SAPLING_MAP.put(TreeType.DARK_OAK, Material.DARK_OAK_SAPLING);
        TREE_TO_SAPLING_MAP.put(TreeType.BROWN_MUSHROOM, Material.BROWN_MUSHROOM);
        TREE_TO_SAPLING_MAP.put(TreeType.RED_MUSHROOM, Material.RED_MUSHROOM);
        TREE_TO_SAPLING_MAP.put(TreeType.CHORUS_PLANT, Material.CHORUS_FLOWER);
        if (Skript.isRunningMinecraft(1, 16)) {
            TREE_TO_SAPLING_MAP.put(TreeType.WARPED_FUNGUS, Material.WARPED_FUNGUS);
            TREE_TO_SAPLING_MAP.put(TreeType.CRIMSON_FUNGUS, Material.CRIMSON_FUNGUS);
        }
        if (Skript.isRunningMinecraft(1, 17)) {
            TREE_TO_SAPLING_MAP.put(TreeType.AZALEA, Material.AZALEA);
        }
        if (Skript.isRunningMinecraft(1, 19)) {
            TREE_TO_SAPLING_MAP.put(TreeType.MANGROVE, Material.MANGROVE_PROPAGULE);
            TREE_TO_SAPLING_MAP.put(TreeType.TALL_MANGROVE, Material.MANGROVE_PROPAGULE);
        }
        if (Skript.isRunningMinecraft(1, 19, 4)) {
            TREE_TO_SAPLING_MAP.put(TreeType.CHERRY, Material.CHERRY_SAPLING);
        }
    }
}

