/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.command;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.SkriptConfig;
import ch.njol.skript.command.Argument;
import ch.njol.skript.command.EffectCommandEvent;
import ch.njol.skript.command.ScriptCommand;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.lang.parser.ParserInstance;
import ch.njol.skript.localization.ArgsMessage;
import ch.njol.skript.localization.Message;
import ch.njol.skript.log.RetainingLogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.util.SkriptColor;
import ch.njol.skript.variables.Variables;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.bukkit.help.HelpMap;
import org.bukkit.help.HelpTopic;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.SimplePluginManager;
import org.eclipse.jdt.annotation.Nullable;
import org.jetbrains.annotations.NotNull;
import org.skriptlang.skript.lang.script.Script;

public abstract class Commands {
    public static final ArgsMessage m_too_many_arguments = new ArgsMessage("commands.too many arguments");
    public static final Message m_internal_error = new Message("commands.internal error");
    public static final Message m_correct_usage = new Message("commands.correct usage");
    public static final int CONVERTER_NO_COMMAND_ARGUMENTS = 4;
    private static final Map<String, ScriptCommand> commands = new HashMap<String, ScriptCommand>();
    private static @Nullable SimpleCommandMap commandMap = null;
    private static @Nullable Map<String, Command> cmKnownCommands;
    private static @Nullable Set<String> cmAliases;
    public static @Nullable List<Argument<?>> currentArguments;
    private static final Pattern escape;
    private static final Pattern unescape;
    private static final Listener commandListener;
    private static boolean registeredListeners;

    public static Set<String> getScriptCommands() {
        return commands.keySet();
    }

    public static @Nullable SimpleCommandMap getCommandMap() {
        return commandMap;
    }

    private static void init() {
        try {
            if (Bukkit.getPluginManager() instanceof SimplePluginManager) {
                Field commandMapField = SimplePluginManager.class.getDeclaredField("commandMap");
                commandMapField.setAccessible(true);
                commandMap = (SimpleCommandMap)commandMapField.get(Bukkit.getPluginManager());
                Field knownCommandsField = SimpleCommandMap.class.getDeclaredField("knownCommands");
                knownCommandsField.setAccessible(true);
                cmKnownCommands = (Map)knownCommandsField.get(commandMap);
                try {
                    Field aliasesField = SimpleCommandMap.class.getDeclaredField("aliases");
                    aliasesField.setAccessible(true);
                    cmAliases = (Set)aliasesField.get(commandMap);
                }
                catch (NoSuchFieldException noSuchFieldException) {}
            }
        }
        catch (SecurityException e) {
            Skript.error("Please disable the security manager");
            commandMap = null;
        }
        catch (Exception e) {
            Skript.outdatedError(e);
            commandMap = null;
        }
    }

    public static String escape(String string) {
        return "" + escape.matcher(string).replaceAll("\\\\$0");
    }

    public static String unescape(String string) {
        return "" + unescape.matcher(string).replaceAll("$0");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean handleEffectCommand(CommandSender sender, String command) {
        if (!(sender instanceof ConsoleCommandSender || sender.hasPermission("skript.effectcommands") || SkriptConfig.allowOpsToUseEffectCommands.value().booleanValue() && sender.isOp())) {
            return false;
        }
        try {
            command = "" + command.substring(SkriptConfig.effectCommandToken.value().length()).trim();
            RetainingLogHandler log = SkriptLogger.startRetainingLog();
            try {
                EffectCommandEvent effectCommand = new EffectCommandEvent(sender, command);
                Bukkit.getPluginManager().callEvent((Event)effectCommand);
                command = effectCommand.getCommand();
                ParserInstance parserInstance = ParserInstance.get();
                parserInstance.setCurrentEvent("effect command", EffectCommandEvent.class);
                Effect effect = Effect.parse(command, null);
                parserInstance.deleteCurrentEvent();
                if (effect != null) {
                    log.clear();
                    log.printLog();
                    if (!effectCommand.isCancelled()) {
                        sender.sendMessage(ChatColor.GRAY + "executing '" + SkriptColor.replaceColorChar(command) + "'");
                        if ((SkriptConfig.logEffectCommands.value().booleanValue() || SkriptConfig.logPlayerCommands.value().booleanValue()) && !(sender instanceof ConsoleCommandSender)) {
                            Skript.info(sender.getName() + " issued effect command: " + SkriptColor.replaceColorChar(command));
                        }
                        TriggerItem.walk(effect, effectCommand);
                        Variables.removeLocals(effectCommand);
                    } else {
                        sender.sendMessage(ChatColor.RED + "your effect command '" + SkriptColor.replaceColorChar(command) + "' was cancelled.");
                    }
                } else {
                    if (sender == Bukkit.getConsoleSender()) {
                        SkriptLogger.LOGGER.severe("Error in: " + SkriptColor.replaceColorChar(command));
                    } else {
                        sender.sendMessage(ChatColor.RED + "Error in: " + ChatColor.GRAY + SkriptColor.replaceColorChar(command));
                    }
                    log.printErrors(sender, "(No specific information is available)");
                }
            }
            finally {
                log.stop();
            }
            return true;
        }
        catch (Exception e) {
            Skript.exception((Throwable)e, "Unexpected error while executing effect command '" + SkriptColor.replaceColorChar(command) + "' by '" + sender.getName() + "'");
            sender.sendMessage(ChatColor.RED + "An internal error occurred while executing this effect. Please refer to the server log for details.");
            return true;
        }
    }

    public static @Nullable ScriptCommand getScriptCommand(String key) {
        return commands.get(key);
    }

    @Deprecated
    public static boolean skriptCommandExists(String command) {
        return Commands.scriptCommandExists(command);
    }

    public static boolean scriptCommandExists(String command) {
        ScriptCommand scriptCommand = commands.get(command);
        return scriptCommand != null && scriptCommand.getName().equals(command);
    }

    public static void registerCommand(ScriptCommand command) {
        ScriptCommand existingCommand = commands.get(command.getLabel());
        if (existingCommand != null && existingCommand.getLabel().equals(command.getLabel())) {
            Script script = existingCommand.getScript();
            Skript.error("A command with the name /" + existingCommand.getName() + " is already defined" + (script != null ? " in " + script.getConfig().getFileName() : ""));
            return;
        }
        if (commandMap != null) {
            assert (cmKnownCommands != null);
            command.register(commandMap, cmKnownCommands, cmAliases);
        }
        commands.put(command.getLabel(), command);
        for (String alias : command.getActiveAliases()) {
            commands.put(alias.toLowerCase(Locale.ENGLISH), command);
        }
        command.registerHelp();
    }

    @Deprecated
    public static int unregisterCommands(File script) {
        int numCommands = 0;
        for (ScriptCommand c : new ArrayList<ScriptCommand>(commands.values())) {
            if (c.getScript() == null || !c.getScript().equals(ScriptLoader.getScript(script))) continue;
            ++numCommands;
            Commands.unregisterCommand(c);
        }
        return numCommands;
    }

    public static void unregisterCommand(ScriptCommand scriptCommand) {
        scriptCommand.unregisterHelp();
        if (commandMap != null) {
            assert (cmKnownCommands != null);
            scriptCommand.unregister(commandMap, cmKnownCommands, cmAliases);
        }
        commands.values().removeIf(command -> command == scriptCommand);
    }

    public static void registerListeners() {
        if (!registeredListeners) {
            Bukkit.getPluginManager().registerEvents(commandListener, (Plugin)Skript.getInstance());
            Bukkit.getPluginManager().registerEvents(new Listener(){

                @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
                public void onPlayerChat(AsyncPlayerChatEvent event) {
                    if (!SkriptConfig.enableEffectCommands.value().booleanValue() || !event.getMessage().startsWith(SkriptConfig.effectCommandToken.value())) {
                        return;
                    }
                    if (!event.isAsynchronous()) {
                        if (Commands.handleEffectCommand((CommandSender)event.getPlayer(), event.getMessage())) {
                            event.setCancelled(true);
                        }
                    } else {
                        Future f = Bukkit.getScheduler().callSyncMethod((Plugin)Skript.getInstance(), () -> Commands.handleEffectCommand((CommandSender)event.getPlayer(), event.getMessage()));
                        try {
                            while (true) {
                                try {
                                    if (((Boolean)f.get()).booleanValue()) {
                                        event.setCancelled(true);
                                    }
                                }
                                catch (InterruptedException interruptedException) {
                                    continue;
                                }
                                break;
                            }
                        }
                        catch (ExecutionException e) {
                            Skript.exception((Throwable)e, new String[0]);
                        }
                    }
                }
            }, (Plugin)Skript.getInstance());
            registeredListeners = true;
        }
    }

    static {
        Commands.init();
        currentArguments = null;
        escape = Pattern.compile("[" + Pattern.quote("(|)<>%\\") + "]");
        unescape = Pattern.compile("\\\\[" + Pattern.quote("(|)<>%\\") + "]");
        commandListener = new Listener(){

            @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
            public void onPlayerCommand(PlayerCommandPreprocessEvent event) {
                String[] cmd = event.getMessage().substring(1).split("\\s+", 2);
                String label = cmd[0].toLowerCase(Locale.ENGLISH);
                String arguments = cmd.length == 1 ? "" : "" + cmd[1];
                ScriptCommand command = (ScriptCommand)commands.get(label);
                if (command != null && !command.checkPermissions((CommandSender)event.getPlayer(), label, arguments)) {
                    event.setCancelled(true);
                }
            }

            @EventHandler(priority=EventPriority.HIGHEST)
            public void onServerCommand(ServerCommandEvent event) {
                if (event.getCommand().isEmpty() || event.isCancelled()) {
                    return;
                }
                if ((Skript.testing() || SkriptConfig.enableEffectCommands.value().booleanValue()) && event.getCommand().startsWith(SkriptConfig.effectCommandToken.value()) && Commands.handleEffectCommand(event.getSender(), event.getCommand())) {
                    event.setCancelled(true);
                }
            }
        };
        registeredListeners = false;
    }

    public static final class CommandAliasHelpTopic
    extends HelpTopic {
        private final String aliasFor;
        private final HelpMap helpMap;

        public CommandAliasHelpTopic(String alias, String aliasFor, HelpMap helpMap) {
            this.aliasFor = aliasFor.startsWith("/") ? aliasFor : "/" + aliasFor;
            this.helpMap = helpMap;
            this.name = alias.startsWith("/") ? alias : "/" + alias;
            Validate.isTrue((!this.name.equals(this.aliasFor) ? 1 : 0) != 0, (String)("Command " + this.name + " cannot be alias for itself"));
            this.shortText = ChatColor.YELLOW + "Alias for " + ChatColor.WHITE + this.aliasFor;
        }

        @NotNull
        public String getFullText(CommandSender forWho) {
            StringBuilder fullText = new StringBuilder(this.shortText);
            HelpTopic aliasForTopic = this.helpMap.getHelpTopic(this.aliasFor);
            if (aliasForTopic != null) {
                fullText.append("\n");
                fullText.append(aliasForTopic.getFullText(forWho));
            }
            return "" + fullText;
        }

        public boolean canSee(CommandSender commandSender) {
            if (this.amendedPermission != null) {
                return commandSender.hasPermission(this.amendedPermission);
            }
            HelpTopic aliasForTopic = this.helpMap.getHelpTopic(this.aliasFor);
            return aliasForTopic != null && aliasForTopic.canSee(commandSender);
        }
    }
}

