/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Chance")
@Description(value={"A condition that randomly succeeds or fails.", "Valid values are between 0% and 100%, or if the percent sign is omitted between 0 and 1."})
@Examples(value={"chance of 50%:", "\tdrop a diamond", "chance of {chance}% # {chance} between 0 and 100", "chance of {chance} # {chance} between 0 and 1"})
@Since(value="1.0")
public class CondChance
extends Condition {
    private Expression<Number> chance;
    private boolean percent;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.chance = exprs[0];
        this.percent = parser.mark == 1;
        return true;
    }

    @Override
    public boolean check(Event e) {
        Number n = this.chance.getSingle(e);
        if (n == null) {
            return false;
        }
        return Math.random() < (this.percent ? n.doubleValue() / 100.0 : n.doubleValue());
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "chance of " + this.chance.toString(e, debug) + (this.percent ? "%" : "");
    }

    static {
        Skript.registerCondition(CondChance.class, "chance of %number%(1\u00a6\\%|)");
    }
}

