/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import org.bukkit.Material;

@Name(value="Is Interactable")
@Description(value={"Checks wether or not a block is interactable."})
@Examples(value={"on block break:", "\tif event-block is interactable:", "\t\tcancel event", "\t\tsend \"You cannot break interactable blocks!\""})
@Since(value="2.5.2")
@RequiredPlugins(value={"Minecraft 1.13+"})
public class CondIsInteractable
extends PropertyCondition<ItemType> {
    @Override
    public boolean check(ItemType item) {
        return item.getMaterial().isInteractable();
    }

    @Override
    protected String getPropertyName() {
        return "interactable";
    }

    static {
        if (Skript.methodExists(Material.class, "isInteractable", new Class[0])) {
            CondIsInteractable.register(CondIsInteractable.class, "interactable", "itemtypes");
        }
    }
}

