/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Events;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.destroystokyo.paper.event.server.PaperServerListPingEvent;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Player Info Visibility")
@Description(value={"Sets whether all player related information is hidden in the server list.", "The Vanilla Minecraft client will display ??? (dark gray) instead of player counts and will not show the", "<a href='expressions.html#ExprHoverList'>hover hist</a> when hiding player info.", "<a href='expressions.html#ExprVersionString'>The version string</a> can override the ???.", "Also the <a href='expressions.html#ExprOnlinePlayersCount'>Online Players Count</a> and", "<a href='expressions.html#ExprMaxPlayers'>Max Players</a> expressions will return -1 when hiding player info."})
@Examples(value={"hide player info", "hide player related information in the server list", "reveal all player related info"})
@Since(value="2.3")
@RequiredPlugins(value={"Paper 1.12.2 or newer"})
@Events(value={"server list ping"})
public class EffPlayerInfoVisibility
extends Effect {
    private static final boolean PAPER_EVENT_EXISTS;
    private boolean shouldHide;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!PAPER_EVENT_EXISTS) {
            Skript.error("The player info visibility effect requires Paper 1.12.2 or newer");
            return false;
        }
        if (!this.getParser().isCurrentEvent((Class<? extends Event>)PaperServerListPingEvent.class)) {
            Skript.error("The player info visibility effect can't be used outside of a server list ping event");
            return false;
        }
        if (isDelayed == Kleenean.TRUE) {
            Skript.error("Can't change the player info visibility anymore after the server list ping event has already passed");
            return false;
        }
        this.shouldHide = matchedPattern == 0;
        return true;
    }

    @Override
    protected void execute(Event e) {
        if (!(e instanceof PaperServerListPingEvent)) {
            return;
        }
        ((PaperServerListPingEvent)e).setHidePlayers(this.shouldHide);
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return (this.shouldHide ? "hide" : "show") + " player info in the server list";
    }

    static {
        Skript.registerEffect(EffPlayerInfoVisibility.class, "hide [all] player [related] info[rmation] [(in|on|from) [the] server list]", "(show|reveal) [all] player [related] info[rmation] [(in|to|on|from) [the] server list]");
        PAPER_EVENT_EXISTS = Skript.classExists("com.destroystokyo.paper.event.server.PaperServerListPingEvent");
    }
}

