/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.PotionEffectUtils;
import ch.njol.skript.util.Timespan;
import ch.njol.util.Kleenean;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Potion Effects")
@Description(value={"Apply or remove potion effects to/from entities."})
@Examples(value={"apply ambient swiftness 2 to the player", "remove haste from the victim", "", "on join:", "\tapply infinite potion of strength of tier {strength::%uuid of player%} to the player", "\tapply potion of strength of tier {strength::%uuid of player%} to the player for 999 days # Before 1.19.4", "", "apply potion effects of player's tool to player", "apply haste potion of tier 3 without any particles whilst hiding the potion icon to the player # Hide potions"})
@Since(value="2.0, 2.2-dev27 (ambient and particle-less potion effects), 2.5 (replacing existing effect), 2.5.2 (potion effects), 2.7 (icon and infinite)")
public class EffPotion
extends Effect {
    private static final boolean COMPATIBLE;
    private static final int DEFAULT_DURATION = 300;
    private Expression<PotionEffectType> potions;
    private Expression<LivingEntity> entities;
    private Expression<PotionEffect> effects;
    private @Nullable Expression<Timespan> duration;
    private @Nullable Expression<Number> tier;
    private boolean replaceExisting;
    private boolean potionEffect;
    private boolean noParticles;
    private boolean infinite;
    private boolean ambient;
    private boolean icon;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.potionEffect = matchedPattern == 0;
        this.replaceExisting = parseResult.hasTag("replacing");
        this.noParticles = parseResult.hasTag("noparticles");
        this.ambient = parseResult.hasTag("ambient");
        this.icon = !parseResult.hasTag("icon");
        boolean bl = this.infinite = matchedPattern == 1;
        if (this.potionEffect) {
            this.effects = exprs[0];
            this.entities = exprs[1];
        } else {
            this.potions = exprs[0];
            this.tier = exprs[1];
            this.entities = exprs[2];
            if (!this.infinite) {
                this.duration = exprs[3];
            }
        }
        return true;
    }

    @Override
    protected void execute(Event event) {
        if (this.potionEffect) {
            for (LivingEntity livingEntity : this.entities.getArray(event)) {
                PotionEffectUtils.addEffects(livingEntity, (Object[])this.effects.getArray(event));
            }
        } else {
            int duration;
            PotionEffectType[] potionEffectTypes = this.potions.getArray(event);
            if (potionEffectTypes.length == 0) {
                return;
            }
            int tier = 0;
            if (this.tier != null) {
                tier = this.tier.getOptionalSingle(event).orElse(1).intValue() - 1;
            }
            int n = this.infinite ? (COMPATIBLE ? -1 : Integer.MAX_VALUE) : (duration = 300);
            if (this.duration != null && !this.infinite) {
                Timespan timespan = this.duration.getSingle(event);
                if (timespan == null) {
                    return;
                }
                duration = (int)Math.min(timespan.getTicks(), Integer.MAX_VALUE);
            }
            for (LivingEntity entity : this.entities.getArray(event)) {
                for (PotionEffectType potionEffectType : potionEffectTypes) {
                    int finalDuration = duration;
                    if (!this.replaceExisting && !this.infinite && entity.hasPotionEffect(potionEffectType)) {
                        for (PotionEffect effect : entity.getActivePotionEffects()) {
                            if (effect.getType() != potionEffectType) continue;
                            finalDuration += effect.getDuration();
                            break;
                        }
                    }
                    entity.addPotionEffect(new PotionEffect(potionEffectType, finalDuration, tier, this.ambient, !this.noParticles, this.icon));
                }
            }
        }
    }

    @Override
    public String toString(@Nullable Event event, boolean debug) {
        if (this.potionEffect) {
            return "apply " + this.effects.toString(event, debug) + " to " + this.entities.toString(event, debug);
        }
        return "apply " + (this.infinite ? " infinite " : "") + this.potions.toString(event, debug) + (this.tier != null ? " of tier " + this.tier.toString(event, debug) : "") + " to " + this.entities.toString(event, debug) + (this.duration != null ? " for " + this.duration.toString(event, debug) : "");
    }

    static {
        Skript.registerEffect(EffPotion.class, "apply %potioneffects% to %livingentities%", "apply infinite [:ambient] [potion of] %potioneffecttypes% [potion] [[[of] tier] %-number%] [noparticles:without [any] particles] [icon:(whilst hiding [the]|without (the|a)) [potion] icon] to %livingentities% [replacing:replacing [the] existing effect]", "apply [:ambient] [potion of] %potioneffecttypes% [potion] [[[of] tier] %-number%] [noparticles:without [any] particles] [icon:(whilst hiding [the]|without (the|a)) [potion] icon] to %livingentities% [for %-timespan%] [replacing:replacing [the] existing effect]");
        COMPATIBLE = Skript.isRunningMinecraft(1, 19, 4);
    }
}

