/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;
import org.skriptlang.skript.lang.script.ScriptWarning;

@Name(value="Locally Suppress Warning")
@Description(value={"Suppresses target warnings from the current script."})
@Examples(value={"locally suppress missing conjunction warnings", "suppress the variable save warnings"})
@Since(value="2.3")
public class EffSuppressWarnings
extends Effect {
    private static final int CONFLICT = 1;
    private static final int INSTANCE = 2;
    private static final int CONJUNCTION = 3;
    private static final int START_EXPR = 4;
    private int mark = 0;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!this.getParser().isActive()) {
            Skript.error("You can't suppress warnings outside of a script!");
            return false;
        }
        this.mark = parseResult.mark;
        if (this.mark == 1) {
            Skript.warning("Variable conflict warnings no longer need suppression, as they have been removed altogether");
        } else {
            this.getParser().getCurrentScript().suppressWarning(ScriptWarning.values()[this.mark - 2]);
        }
        return true;
    }

    @Override
    protected void execute(Event event) {
    }

    @Override
    public String toString(@Nullable Event event, boolean debug) {
        String word;
        switch (this.mark) {
            case 1: {
                word = "conflict";
                break;
            }
            case 2: {
                word = "variable save";
                break;
            }
            case 3: {
                word = "missing conjunction";
                break;
            }
            case 4: {
                word = "starting expression";
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return "suppress " + word + " warnings";
    }

    static {
        Skript.registerEffect(EffSuppressWarnings.class, "[local[ly]] suppress [the] (1:conflict|2:variable save|3:[missing] conjunction[s]|4:starting [with] expression[s]) warning[s]");
    }
}

