/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.entity;

import ch.njol.skript.Skript;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.yggdrasil.Fields;
import java.io.NotSerializableException;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.Allay;
import org.bukkit.entity.Animals;
import org.bukkit.entity.AreaEffectCloud;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Bat;
import org.bukkit.entity.Blaze;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.Breeze;
import org.bukkit.entity.Camel;
import org.bukkit.entity.CaveSpider;
import org.bukkit.entity.ChestedHorse;
import org.bukkit.entity.Chicken;
import org.bukkit.entity.Cod;
import org.bukkit.entity.Cow;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Display;
import org.bukkit.entity.Dolphin;
import org.bukkit.entity.Donkey;
import org.bukkit.entity.DragonFireball;
import org.bukkit.entity.Drowned;
import org.bukkit.entity.Egg;
import org.bukkit.entity.ElderGuardian;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.EnderSignal;
import org.bukkit.entity.Endermite;
import org.bukkit.entity.Enemy;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Evoker;
import org.bukkit.entity.EvokerFangs;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Fish;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.Ghast;
import org.bukkit.entity.Giant;
import org.bukkit.entity.GlowItemFrame;
import org.bukkit.entity.GlowSquid;
import org.bukkit.entity.Golem;
import org.bukkit.entity.Guardian;
import org.bukkit.entity.Hoglin;
import org.bukkit.entity.Horse;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Husk;
import org.bukkit.entity.Illager;
import org.bukkit.entity.Illusioner;
import org.bukkit.entity.Interaction;
import org.bukkit.entity.IronGolem;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LargeFireball;
import org.bukkit.entity.LeashHitch;
import org.bukkit.entity.LightningStrike;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Llama;
import org.bukkit.entity.LlamaSpit;
import org.bukkit.entity.MagmaCube;
import org.bukkit.entity.Marker;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Mule;
import org.bukkit.entity.MushroomCow;
import org.bukkit.entity.Painting;
import org.bukkit.entity.Phantom;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.Piglin;
import org.bukkit.entity.PiglinBrute;
import org.bukkit.entity.Pillager;
import org.bukkit.entity.Player;
import org.bukkit.entity.PolarBear;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.PufferFish;
import org.bukkit.entity.Raider;
import org.bukkit.entity.Ravager;
import org.bukkit.entity.Salmon;
import org.bukkit.entity.Shulker;
import org.bukkit.entity.ShulkerBullet;
import org.bukkit.entity.Silverfish;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.SkeletonHorse;
import org.bukkit.entity.Slime;
import org.bukkit.entity.SmallFireball;
import org.bukkit.entity.Sniffer;
import org.bukkit.entity.Snowball;
import org.bukkit.entity.Snowman;
import org.bukkit.entity.SpectralArrow;
import org.bukkit.entity.Spellcaster;
import org.bukkit.entity.Spider;
import org.bukkit.entity.Squid;
import org.bukkit.entity.Stray;
import org.bukkit.entity.Strider;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.Tadpole;
import org.bukkit.entity.TextDisplay;
import org.bukkit.entity.ThrownExpBottle;
import org.bukkit.entity.TippedArrow;
import org.bukkit.entity.Trident;
import org.bukkit.entity.TropicalFish;
import org.bukkit.entity.Turtle;
import org.bukkit.entity.Vex;
import org.bukkit.entity.Vindicator;
import org.bukkit.entity.WanderingTrader;
import org.bukkit.entity.Warden;
import org.bukkit.entity.WaterMob;
import org.bukkit.entity.WindCharge;
import org.bukkit.entity.Witch;
import org.bukkit.entity.Wither;
import org.bukkit.entity.WitherSkeleton;
import org.bukkit.entity.WitherSkull;
import org.bukkit.entity.Zoglin;
import org.bukkit.entity.Zombie;
import org.bukkit.entity.ZombieHorse;
import org.eclipse.jdt.annotation.Nullable;

public class SimpleEntityData
extends EntityData<Entity> {
    private static final List<SimpleEntityDataInfo> types = new ArrayList<SimpleEntityDataInfo>();
    private transient SimpleEntityDataInfo info;

    private static void addSimpleEntity(String codeName, Class<? extends Entity> entityClass) {
        types.add(new SimpleEntityDataInfo(codeName, entityClass));
    }

    private static void addSuperEntity(String codeName, Class<? extends Entity> entityClass) {
        types.add(new SimpleEntityDataInfo(codeName, entityClass, true));
    }

    public SimpleEntityData() {
        this(Entity.class);
    }

    private SimpleEntityData(SimpleEntityDataInfo info) {
        assert (info != null);
        this.info = info;
        this.matchedPattern = types.indexOf(info);
    }

    public SimpleEntityData(Class<? extends Entity> c) {
        assert (c != null && c.isInterface()) : c;
        int i = 0;
        for (SimpleEntityDataInfo info : types) {
            if (info.c.isAssignableFrom(c)) {
                this.info = info;
                this.matchedPattern = i;
                return;
            }
            ++i;
        }
        throw new IllegalStateException();
    }

    public SimpleEntityData(Entity e) {
        int i = 0;
        for (SimpleEntityDataInfo info : types) {
            if (info.c.isInstance(e)) {
                this.info = info;
                this.matchedPattern = i;
                return;
            }
            ++i;
        }
        throw new IllegalStateException();
    }

    @Override
    protected boolean init(Literal<?>[] exprs, int matchedPattern, SkriptParser.ParseResult parseResult) {
        this.info = types.get(matchedPattern);
        assert (this.info != null) : matchedPattern;
        return true;
    }

    @Override
    protected boolean init(@Nullable Class<? extends Entity> c, @Nullable Entity e) {
        assert (false);
        return false;
    }

    @Override
    public void set(Entity entity) {
    }

    @Override
    public boolean match(Entity e) {
        if (this.info.isSupertype) {
            return this.info.c.isInstance(e);
        }
        for (SimpleEntityDataInfo info : types) {
            if (!info.c.isInstance(e)) continue;
            return this.info.c == info.c;
        }
        assert (false);
        return false;
    }

    @Override
    public Class<? extends Entity> getType() {
        return this.info.c;
    }

    @Override
    protected int hashCode_i() {
        return this.info.hashCode();
    }

    @Override
    protected boolean equals_i(EntityData<?> obj) {
        if (!(obj instanceof SimpleEntityData)) {
            return false;
        }
        SimpleEntityData other = (SimpleEntityData)obj;
        return this.info.equals(other.info);
    }

    @Override
    public Fields serialize() throws NotSerializableException {
        Fields f = super.serialize();
        f.putObject("info.codeName", this.info.codeName);
        return f;
    }

    @Override
    public void deserialize(Fields fields) throws StreamCorruptedException, NotSerializableException {
        String codeName = fields.getAndRemoveObject("info.codeName", String.class);
        for (SimpleEntityDataInfo i : types) {
            if (!i.codeName.equals(codeName)) continue;
            this.info = i;
            super.deserialize(fields);
            return;
        }
        throw new StreamCorruptedException("Invalid SimpleEntityDataInfo code name " + codeName);
    }

    @Override
    @Deprecated
    protected boolean deserialize(String s) {
        try {
            Class<?> c = Class.forName(s);
            for (SimpleEntityDataInfo i : types) {
                if (i.c != c) continue;
                this.info = i;
                return true;
            }
            return false;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @Override
    public boolean isSupertypeOf(EntityData<?> e) {
        return this.info.c == e.getType() || this.info.isSupertype && this.info.c.isAssignableFrom(e.getType());
    }

    @Override
    public EntityData getSuperType() {
        return new SimpleEntityData(this.info);
    }

    static {
        SimpleEntityData.addSimpleEntity("arrow", Arrow.class);
        SimpleEntityData.addSimpleEntity("spectral arrow", SpectralArrow.class);
        SimpleEntityData.addSimpleEntity("tipped arrow", TippedArrow.class);
        SimpleEntityData.addSimpleEntity("blaze", Blaze.class);
        SimpleEntityData.addSimpleEntity("chicken", Chicken.class);
        SimpleEntityData.addSimpleEntity("mooshroom", MushroomCow.class);
        SimpleEntityData.addSimpleEntity("cow", Cow.class);
        SimpleEntityData.addSimpleEntity("cave spider", CaveSpider.class);
        SimpleEntityData.addSimpleEntity("dragon fireball", DragonFireball.class);
        SimpleEntityData.addSimpleEntity("egg", Egg.class);
        SimpleEntityData.addSimpleEntity("ender crystal", EnderCrystal.class);
        SimpleEntityData.addSimpleEntity("ender dragon", EnderDragon.class);
        SimpleEntityData.addSimpleEntity("ender pearl", EnderPearl.class);
        SimpleEntityData.addSimpleEntity("ender eye", EnderSignal.class);
        SimpleEntityData.addSimpleEntity("small fireball", SmallFireball.class);
        SimpleEntityData.addSimpleEntity("large fireball", LargeFireball.class);
        SimpleEntityData.addSimpleEntity("fireball", Fireball.class);
        SimpleEntityData.addSimpleEntity("fish hook", FishHook.class);
        SimpleEntityData.addSimpleEntity("ghast", Ghast.class);
        SimpleEntityData.addSimpleEntity("giant", Giant.class);
        SimpleEntityData.addSimpleEntity("iron golem", IronGolem.class);
        SimpleEntityData.addSimpleEntity("lightning bolt", LightningStrike.class);
        SimpleEntityData.addSimpleEntity("magma cube", MagmaCube.class);
        SimpleEntityData.addSimpleEntity("slime", Slime.class);
        SimpleEntityData.addSimpleEntity("painting", Painting.class);
        SimpleEntityData.addSimpleEntity("player", Player.class);
        SimpleEntityData.addSimpleEntity("zombie pigman", PigZombie.class);
        SimpleEntityData.addSimpleEntity("silverfish", Silverfish.class);
        SimpleEntityData.addSimpleEntity("snowball", Snowball.class);
        SimpleEntityData.addSimpleEntity("snow golem", Snowman.class);
        SimpleEntityData.addSimpleEntity("spider", Spider.class);
        SimpleEntityData.addSimpleEntity("bottle of enchanting", ThrownExpBottle.class);
        SimpleEntityData.addSimpleEntity("tnt", TNTPrimed.class);
        SimpleEntityData.addSimpleEntity("leash hitch", LeashHitch.class);
        SimpleEntityData.addSimpleEntity("item frame", ItemFrame.class);
        SimpleEntityData.addSimpleEntity("bat", Bat.class);
        SimpleEntityData.addSimpleEntity("witch", Witch.class);
        SimpleEntityData.addSimpleEntity("wither", Wither.class);
        SimpleEntityData.addSimpleEntity("wither skull", WitherSkull.class);
        SimpleEntityData.addSimpleEntity("firework", Firework.class);
        SimpleEntityData.addSimpleEntity("endermite", Endermite.class);
        SimpleEntityData.addSimpleEntity("armor stand", ArmorStand.class);
        SimpleEntityData.addSimpleEntity("shulker", Shulker.class);
        SimpleEntityData.addSimpleEntity("shulker bullet", ShulkerBullet.class);
        SimpleEntityData.addSimpleEntity("polar bear", PolarBear.class);
        SimpleEntityData.addSimpleEntity("area effect cloud", AreaEffectCloud.class);
        SimpleEntityData.addSimpleEntity("wither skeleton", WitherSkeleton.class);
        SimpleEntityData.addSimpleEntity("stray", Stray.class);
        SimpleEntityData.addSimpleEntity("husk", Husk.class);
        SimpleEntityData.addSuperEntity("skeleton", Skeleton.class);
        SimpleEntityData.addSimpleEntity("llama spit", LlamaSpit.class);
        SimpleEntityData.addSimpleEntity("evoker", Evoker.class);
        SimpleEntityData.addSimpleEntity("evoker fangs", EvokerFangs.class);
        SimpleEntityData.addSimpleEntity("vex", Vex.class);
        SimpleEntityData.addSimpleEntity("vindicator", Vindicator.class);
        SimpleEntityData.addSimpleEntity("elder guardian", ElderGuardian.class);
        SimpleEntityData.addSimpleEntity("normal guardian", Guardian.class);
        SimpleEntityData.addSimpleEntity("donkey", Donkey.class);
        SimpleEntityData.addSimpleEntity("mule", Mule.class);
        SimpleEntityData.addSimpleEntity("llama", Llama.class);
        SimpleEntityData.addSimpleEntity("undead horse", ZombieHorse.class);
        SimpleEntityData.addSimpleEntity("skeleton horse", SkeletonHorse.class);
        SimpleEntityData.addSimpleEntity("horse", Horse.class);
        SimpleEntityData.addSimpleEntity("dolphin", Dolphin.class);
        SimpleEntityData.addSimpleEntity("phantom", Phantom.class);
        SimpleEntityData.addSimpleEntity("drowned", Drowned.class);
        SimpleEntityData.addSimpleEntity("turtle", Turtle.class);
        SimpleEntityData.addSimpleEntity("cod", Cod.class);
        SimpleEntityData.addSimpleEntity("puffer fish", PufferFish.class);
        SimpleEntityData.addSimpleEntity("salmon", Salmon.class);
        SimpleEntityData.addSimpleEntity("tropical fish", TropicalFish.class);
        SimpleEntityData.addSimpleEntity("trident", Trident.class);
        SimpleEntityData.addSimpleEntity("illusioner", Illusioner.class);
        if (Skript.isRunningMinecraft(1, 14)) {
            SimpleEntityData.addSimpleEntity("pillager", Pillager.class);
            SimpleEntityData.addSimpleEntity("ravager", Ravager.class);
            SimpleEntityData.addSimpleEntity("wandering trader", WanderingTrader.class);
        }
        if (Skript.isRunningMinecraft(1, 16)) {
            SimpleEntityData.addSimpleEntity("piglin", Piglin.class);
            SimpleEntityData.addSimpleEntity("hoglin", Hoglin.class);
            SimpleEntityData.addSimpleEntity("zoglin", Zoglin.class);
            SimpleEntityData.addSimpleEntity("strider", Strider.class);
        }
        if (Skript.classExists("org.bukkit.entity.PiglinBrute")) {
            SimpleEntityData.addSimpleEntity("piglin brute", PiglinBrute.class);
        }
        if (Skript.isRunningMinecraft(1, 17)) {
            SimpleEntityData.addSimpleEntity("glow squid", GlowSquid.class);
            SimpleEntityData.addSimpleEntity("marker", Marker.class);
            SimpleEntityData.addSimpleEntity("glow item frame", GlowItemFrame.class);
        }
        if (Skript.isRunningMinecraft(1, 19)) {
            SimpleEntityData.addSimpleEntity("allay", Allay.class);
            SimpleEntityData.addSimpleEntity("tadpole", Tadpole.class);
            SimpleEntityData.addSimpleEntity("warden", Warden.class);
        }
        if (Skript.isRunningMinecraft(1, 19, 3)) {
            SimpleEntityData.addSimpleEntity("camel", Camel.class);
        }
        if (Skript.isRunningMinecraft(1, 19, 4)) {
            SimpleEntityData.addSimpleEntity("sniffer", Sniffer.class);
            SimpleEntityData.addSimpleEntity("text display", TextDisplay.class);
            SimpleEntityData.addSimpleEntity("item display", ItemDisplay.class);
            SimpleEntityData.addSimpleEntity("block display", BlockDisplay.class);
            SimpleEntityData.addSimpleEntity("interaction", Interaction.class);
            SimpleEntityData.addSuperEntity("display", Display.class);
        }
        if (Skript.isRunningMinecraft(1, 20, 3)) {
            SimpleEntityData.addSimpleEntity("breeze", Breeze.class);
            SimpleEntityData.addSimpleEntity("wind charge", WindCharge.class);
        }
        SimpleEntityData.addSimpleEntity("zombie", Zombie.class);
        SimpleEntityData.addSimpleEntity("squid", Squid.class);
        SimpleEntityData.addSuperEntity("human", HumanEntity.class);
        SimpleEntityData.addSuperEntity("damageable", Damageable.class);
        SimpleEntityData.addSuperEntity("monster", Monster.class);
        SimpleEntityData.addSuperEntity("mob", Mob.class);
        SimpleEntityData.addSuperEntity("creature", Creature.class);
        SimpleEntityData.addSuperEntity("animal", Animals.class);
        SimpleEntityData.addSuperEntity("golem", Golem.class);
        SimpleEntityData.addSuperEntity("projectile", Projectile.class);
        SimpleEntityData.addSuperEntity("living entity", LivingEntity.class);
        SimpleEntityData.addSuperEntity("entity", Entity.class);
        SimpleEntityData.addSuperEntity("chested horse", ChestedHorse.class);
        SimpleEntityData.addSuperEntity("any horse", AbstractHorse.class);
        SimpleEntityData.addSuperEntity("guardian", Guardian.class);
        SimpleEntityData.addSuperEntity("water mob", WaterMob.class);
        SimpleEntityData.addSuperEntity("fish", Fish.class);
        SimpleEntityData.addSuperEntity("any fireball", Fireball.class);
        SimpleEntityData.addSuperEntity("illager", Illager.class);
        SimpleEntityData.addSuperEntity("spellcaster", Spellcaster.class);
        if (Skript.classExists("org.bukkit.entity.Raider")) {
            SimpleEntityData.addSuperEntity("raider", Raider.class);
        }
        if (Skript.classExists("org.bukkit.entity.Enemy")) {
            SimpleEntityData.addSuperEntity("enemy", Enemy.class);
        }
        String[] codeNames = new String[types.size()];
        int i = 0;
        for (SimpleEntityDataInfo info : types) {
            codeNames[i++] = info.codeName;
        }
        EntityData.register(SimpleEntityData.class, "simple", Entity.class, 0, codeNames);
    }

    public static final class SimpleEntityDataInfo {
        final String codeName;
        final Class<? extends Entity> c;
        final boolean isSupertype;

        SimpleEntityDataInfo(String codeName, Class<? extends Entity> c) {
            this(codeName, c, false);
        }

        SimpleEntityDataInfo(String codeName, Class<? extends Entity> c, boolean isSupertype) {
            this.codeName = codeName;
            this.c = c;
            this.isSupertype = isSupertype;
        }

        public int hashCode() {
            return this.c.hashCode();
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof SimpleEntityDataInfo)) {
                return false;
            }
            SimpleEntityDataInfo other = (SimpleEntityDataInfo)obj;
            if (this.c != other.c) {
                return false;
            }
            assert (this.codeName.equals(other.codeName));
            assert (this.isSupertype == other.isSupertype);
            return true;
        }
    }
}

