/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.BlockingLogHandler;
import ch.njol.util.Kleenean;
import ch.njol.util.StringUtils;
import ch.njol.util.coll.iterator.CheckedIterator;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Entities")
@Description(value={"All entities in all worlds, in a specific world, in a chunk or in a radius around a certain location, e.g. <code>all players</code>, <code>all creepers in the player's world</code>, or <code>players in radius 100 of the player</code>."})
@Examples(value={"kill all creepers in the player's world", "send \"Psst!\" to all players within 100 meters of the player", "give a diamond to all ops", "heal all tamed wolves in radius 2000 around {town center}", "delete all monsters in chunk at player"})
@Since(value="1.2.1, 2.5 (chunks)")
public class ExprEntities
extends SimpleExpression<Entity> {
    Expression<? extends EntityData<?>> types;
    private @Nullable Expression<World> worlds;
    private @Nullable Expression<Chunk> chunks;
    private @Nullable Expression<Number> radius;
    private @Nullable Expression<Location> center;
    private Class<? extends Entity> returnType = Entity.class;
    private boolean isUsingRadius;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.types = exprs[0];
        if (matchedPattern % 2 == 0) {
            for (EntityData d : (EntityData[])((Literal)this.types).getAll()) {
                if (!d.isPlural().isFalse() && (!d.isPlural().isUnknown() || StringUtils.startsWithIgnoreCase(parseResult.expr, "all"))) continue;
                return false;
            }
        }
        boolean bl = this.isUsingRadius = matchedPattern >= 2;
        if (this.isUsingRadius) {
            this.radius = exprs[exprs.length - 2];
            this.center = exprs[exprs.length - 1];
        } else if (parseResult.mark == 1) {
            this.chunks = exprs[2];
        } else {
            this.worlds = exprs[1];
        }
        if (this.types instanceof Literal && ((EntityData[])((Literal)this.types).getAll()).length == 1) {
            this.returnType = ((EntityData)((Literal)this.types).getSingle()).getType();
        }
        return true;
    }

    @Override
    public boolean isLoopOf(String s) {
        if (!(this.types instanceof Literal)) {
            return false;
        }
        try (BlockingLogHandler ignored = new BlockingLogHandler().start();){
            EntityData<?> d = EntityData.parseWithoutIndefiniteArticle(s);
            if (d != null) {
                for (EntityData t : (EntityData[])((Literal)this.types).getAll()) {
                    assert (t != null);
                    if (d.isSupertypeOf(t)) continue;
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    protected @Nullable Entity[] get(Event e) {
        if (this.isUsingRadius) {
            Iterator<? extends Entity> iter = this.iterator(e);
            if (iter == null || !iter.hasNext()) {
                return null;
            }
            ArrayList<Entity> l = new ArrayList<Entity>();
            while (iter.hasNext()) {
                l.add(iter.next());
            }
            return l.toArray((Entity[])Array.newInstance(this.returnType, l.size()));
        }
        if (this.chunks != null) {
            return EntityData.getAll((EntityData[])this.types.getArray(e), this.returnType, (Chunk[])this.chunks.getArray(e));
        }
        return EntityData.getAll((EntityData[])this.types.getAll(e), this.returnType, this.worlds != null ? this.worlds.getArray(e) : null);
    }

    @Override
    public @Nullable Iterator<? extends Entity> iterator(Event e) {
        if (this.isUsingRadius) {
            assert (this.center != null);
            Location l = this.center.getSingle(e);
            if (l == null) {
                return null;
            }
            assert (this.radius != null);
            Number n = this.radius.getSingle(e);
            if (n == null) {
                return null;
            }
            double d = n.doubleValue();
            if (l.getWorld() == null) {
                return null;
            }
            Collection es = l.getWorld().getNearbyEntities(l, d, d, d);
            double radiusSquared = d * d * 1.00001;
            EntityData[] ts = this.types.getAll(e);
            return new CheckedIterator<Entity>(es.iterator(), e1 -> {
                if (e1 == null || e1.getLocation().distanceSquared(l) > radiusSquared) {
                    return false;
                }
                for (EntityData t : ts) {
                    if (!t.isInstance((Entity)e1)) continue;
                    return true;
                }
                return false;
            });
        }
        if (this.chunks == null || this.returnType == Player.class) {
            return super.iterator(e);
        }
        return Arrays.stream(EntityData.getAll((EntityData[])this.types.getArray(e), this.returnType, (Chunk[])this.chunks.getArray(e))).iterator();
    }

    @Override
    public boolean isSingle() {
        return false;
    }

    @Override
    public Class<? extends Entity> getReturnType() {
        return this.returnType;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "all entities of type " + this.types.toString(e, debug) + (this.worlds != null ? " in " + this.worlds.toString(e, debug) : (this.radius != null && this.center != null ? " in radius " + this.radius.toString(e, debug) + " around " + this.center.toString(e, debug) : ""));
    }

    static {
        Skript.registerExpression(ExprEntities.class, Entity.class, ExpressionType.PATTERN_MATCHES_EVERYTHING, "[(all [[of] the]|the)] %*entitydatas% [(in|of) ([world[s]] %-worlds%|1\u00a6%-chunks%)]", "[(all [[of] the]|the)] entities of type[s] %entitydatas% [(in|of) ([world[s]] %-worlds%|1\u00a6%-chunks%)]", "[(all [[of] the]|the)] %*entitydatas% (within|[with]in radius) %number% [(block[s]|met(er|re)[s])] (of|around) %location%", "[(all [[of] the]|the)] entities of type[s] %entitydatas% in radius %number% (of|around) %location%");
    }
}

