/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Events;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.List;
import org.bukkit.block.Block;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Exploded Blocks")
@Description(value={"Get all the blocks that were destroyed in an explode event"})
@Examples(value={"on explode:", "\tloop exploded blocks:", "\t\tadd loop-block to {exploded::blocks::*}"})
@Events(value={"explode"})
@Since(value="2.5")
public class ExprExplodedBlocks
extends SimpleExpression<Block> {
    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!this.getParser().isCurrentEvent((Class<? extends Event>)EntityExplodeEvent.class)) {
            Skript.error("Exploded blocks can only be retrieved from an explode event.");
            return false;
        }
        return true;
    }

    protected @Nullable Block[] get(Event e) {
        if (!(e instanceof EntityExplodeEvent)) {
            return null;
        }
        List blockList = ((EntityExplodeEvent)e).blockList();
        return blockList.toArray(new Block[blockList.size()]);
    }

    @Override
    public boolean isSingle() {
        return false;
    }

    @Override
    public Class<? extends Block> getReturnType() {
        return Block.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean d) {
        return "exploded blocks";
    }

    static {
        Skript.registerExpression(ExprExplodedBlocks.class, Block.class, ExpressionType.COMBINED, "[the] exploded blocks");
    }
}

