/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Events;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.effects.Delay;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.slot.InventorySlot;
import ch.njol.skript.util.slot.Slot;
import ch.njol.util.Kleenean;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Furnace;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.FurnaceBurnEvent;
import org.bukkit.event.inventory.FurnaceSmeltEvent;
import org.bukkit.inventory.FurnaceInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Furnace Slot")
@Description(value={"A slot of a furnace, i.e. either the ore, fuel or result slot.", "Remember to use '<a href='#ExprBlock'>block</a>' and not <code>furnace</code>, as <code>furnace</code> is not an existing expression.", "Note that <code>the result</code> and <code>the result slot</code> refer to separate things. <code>the result</code> is the product in a smelt event and <code>the result slot</code> is the output slot of a furnace (where <code>the result</code> will end up).", "Note that if the result in a smelt event is changed to an item that differs in type from the items currently in the result slot, the smelting will fail to complete (the item will attempt to smelt itself again).", "Note that if values other than <code>the result</code> are changed, event values may not accurately reflect the actual items in a furnace.", "Thus you may wish to use the event block in this case (e.g. <code>the fuel slot of the event-block</code>) to get accurate values if needed."})
@Examples(value={"set the fuel slot of the clicked block to a lava bucket", "set the block's ore slot to 64 iron ore", "give the result of the block to the player", "clear the result slot of the block"})
@Events(value={"smelt", "fuel burn"})
@Since(value="1.0, 2.8.0 (syntax rework)")
public class ExprFurnaceSlot
extends SimpleExpression<Slot> {
    private static final int ORE = 0;
    private static final int FUEL = 1;
    private static final int RESULT = 2;
    private @Nullable Expression<Block> blocks;
    private boolean isEvent;
    private boolean isResultSlot;
    private int slot;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        boolean bl = this.isEvent = matchedPattern == 0;
        if (!this.isEvent) {
            this.blocks = exprs[0];
        }
        this.slot = parseResult.mark;
        boolean bl2 = this.isResultSlot = this.slot == 7;
        if (this.isResultSlot) {
            this.slot = 2;
        }
        if (this.isEvent && (this.slot == 0 || this.slot == 2) && !this.getParser().isCurrentEvent((Class<? extends Event>)FurnaceSmeltEvent.class)) {
            Skript.error("Cannot use 'result slot' or 'ore slot' outside an ore smelt event.");
            return false;
        }
        if (this.isEvent && this.slot == 1 && !this.getParser().isCurrentEvent((Class<? extends Event>)FurnaceBurnEvent.class)) {
            Skript.error("Cannot use 'fuel slot' outside a fuel burn event.");
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected @Nullable Slot[] get(Event event) {
        Block[] blocks;
        if (this.isEvent) {
            blocks = new Block[1];
            if (event instanceof FurnaceSmeltEvent) {
                blocks[0] = ((FurnaceSmeltEvent)event).getBlock();
            } else {
                if (!(event instanceof FurnaceBurnEvent)) return new Slot[0];
                blocks[0] = ((FurnaceBurnEvent)event).getBlock();
            }
        } else {
            assert (this.blocks != null);
            blocks = this.blocks.getArray(event);
        }
        ArrayList<InventorySlot> slots = new ArrayList<InventorySlot>();
        for (Block block : blocks) {
            BlockState state = block.getState();
            if (!(state instanceof Furnace)) continue;
            FurnaceInventory furnaceInventory = ((Furnace)state).getInventory();
            if (this.isEvent && !Delay.isDelayed(event)) {
                slots.add(new FurnaceEventSlot(event, furnaceInventory));
                continue;
            }
            slots.add(new InventorySlot((Inventory)furnaceInventory, this.slot));
        }
        return slots.toArray(new Slot[0]);
    }

    @Override
    public boolean isSingle() {
        if (this.isEvent) {
            return true;
        }
        assert (this.blocks != null);
        return this.blocks.isSingle();
    }

    @Override
    public Class<? extends Slot> getReturnType() {
        return InventorySlot.class;
    }

    @Override
    public String toString(@Nullable Event event, boolean debug) {
        String slotName;
        String time;
        String string = this.getTime() == -1 ? "past " : (time = this.getTime() == 1 ? "future " : "");
        String string2 = this.slot == 0 ? "ore" : (slotName = this.slot == 1 ? "fuel" : "result");
        if (this.isEvent) {
            return "the " + time + slotName + (this.isResultSlot ? " slot" : "");
        }
        assert (this.blocks != null);
        return "the " + time + slotName + " slot of " + this.blocks.toString(event, debug);
    }

    @Override
    public boolean setTime(int time) {
        if (this.isEvent) {
            if (this.slot == 2 && !this.isResultSlot) {
                return false;
            }
            if (this.slot == 1) {
                return this.setTime(time, (Class<? extends Event>)FurnaceBurnEvent.class);
            }
            return this.setTime(time, (Class<? extends Event>)FurnaceSmeltEvent.class);
        }
        return false;
    }

    static {
        Skript.registerExpression(ExprFurnaceSlot.class, Slot.class, ExpressionType.PROPERTY, "[the] (0:ore slot|1:fuel slot|2:result [5:slot])", "[the] (0:ore|1:fuel|2:result) slot[s] of %blocks%", "%blocks%'[s] (0:ore|1:fuel|2:result) slot[s]");
    }

    private final class FurnaceEventSlot
    extends InventorySlot {
        private final Event event;

        public FurnaceEventSlot(Event event, FurnaceInventory furnaceInventory) {
            super((Inventory)furnaceInventory, ExprFurnaceSlot.this.slot);
            this.event = event;
        }

        @Override
        public @Nullable ItemStack getItem() {
            switch (ExprFurnaceSlot.this.slot) {
                case 0: {
                    if (this.event instanceof FurnaceSmeltEvent) {
                        ItemStack source = ((FurnaceSmeltEvent)this.event).getSource().clone();
                        if (ExprFurnaceSlot.this.getTime() != 1) {
                            return source;
                        }
                        source.setAmount(source.getAmount() - 1);
                        return source;
                    }
                    return super.getItem();
                }
                case 1: {
                    if (this.event instanceof FurnaceBurnEvent) {
                        ItemStack fuel = ((FurnaceBurnEvent)this.event).getFuel().clone();
                        if (ExprFurnaceSlot.this.getTime() != 1) {
                            return fuel;
                        }
                        Material newMaterial = fuel.getType() == Material.LAVA_BUCKET ? Material.BUCKET : Material.AIR;
                        fuel.setAmount(fuel.getAmount() - 1);
                        if (fuel.getAmount() == 0) {
                            fuel = new ItemStack(newMaterial);
                        }
                        return fuel;
                    }
                    return super.getItem();
                }
                case 2: {
                    if (this.event instanceof FurnaceSmeltEvent) {
                        ItemStack result = ((FurnaceSmeltEvent)this.event).getResult().clone();
                        if (ExprFurnaceSlot.this.isResultSlot) {
                            ItemStack currentResult = ((FurnaceInventory)this.getInventory()).getResult();
                            if (currentResult != null) {
                                currentResult = currentResult.clone();
                            }
                            if (ExprFurnaceSlot.this.getTime() != 1) {
                                return currentResult;
                            }
                            if (currentResult != null && currentResult.isSimilar(result)) {
                                currentResult.setAmount(currentResult.getAmount() + result.getAmount());
                                return currentResult;
                            }
                            return result;
                        }
                        return result;
                    }
                    return super.getItem();
                }
            }
            return null;
        }

        @Override
        public void setItem(@Nullable ItemStack item) {
            if (ExprFurnaceSlot.this.slot == 2 && !ExprFurnaceSlot.this.isResultSlot && this.event instanceof FurnaceSmeltEvent) {
                ((FurnaceSmeltEvent)this.event).setResult(item != null ? item : new ItemStack(Material.AIR));
            } else if (ExprFurnaceSlot.this.getTime() == 1) {
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Skript.getInstance(), () -> FurnaceEventSlot.super.setItem(item));
            } else {
                super.setItem(item);
            }
        }
    }
}

