/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions.arithmetic;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.arithmetic.ArithmeticChain;
import ch.njol.skript.expressions.arithmetic.ArithmeticGettable;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.UnparsedLiteral;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.lang.util.SimpleLiteral;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.LiteralUtils;
import ch.njol.skript.util.Patterns;
import ch.njol.util.Kleenean;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;
import org.skriptlang.skript.lang.arithmetic.Arithmetics;
import org.skriptlang.skript.lang.arithmetic.OperationInfo;
import org.skriptlang.skript.lang.arithmetic.Operator;

@Name(value="Arithmetic")
@Description(value={"Arithmetic expressions, e.g. 1 + 2, (health of player - 2) / 3, etc."})
@Examples(value={"set the player's health to 10 - the player's health", "loop (argument + 2) / 5 times:", "\tmessage \"Two useless numbers: %loop-num * 2 - 5%, %2^loop-num - 1%\"", "message \"You have %health of player * 2% half hearts of HP!\""})
@Since(value="1.4.2")
public class ExprArithmetic<L, R, T>
extends SimpleExpression<T> {
    private static final Class<?>[] INTEGER_CLASSES = new Class[]{Long.class, Integer.class, Short.class, Byte.class};
    private static final Patterns<PatternInfo> patterns = new Patterns(new Object[][]{{"\\(%object%\\)[ ]+[ ]\\(%object%\\)", new PatternInfo(Operator.ADDITION, true, true)}, {"\\(%object%\\)[ ]+[ ]%object%", new PatternInfo(Operator.ADDITION, true, false)}, {"%object%[ ]+[ ]\\(%object%\\)", new PatternInfo(Operator.ADDITION, false, true)}, {"%object%[ ]+[ ]%object%", new PatternInfo(Operator.ADDITION, false, false)}, {"\\(%object%\\)[ ]-[ ]\\(%object%\\)", new PatternInfo(Operator.SUBTRACTION, true, true)}, {"\\(%object%\\)[ ]-[ ]%object%", new PatternInfo(Operator.SUBTRACTION, true, false)}, {"%object%[ ]-[ ]\\(%object%\\)", new PatternInfo(Operator.SUBTRACTION, false, true)}, {"%object%[ ]-[ ]%object%", new PatternInfo(Operator.SUBTRACTION, false, false)}, {"\\(%object%\\)[ ]*[ ]\\(%object%\\)", new PatternInfo(Operator.MULTIPLICATION, true, true)}, {"\\(%object%\\)[ ]*[ ]%object%", new PatternInfo(Operator.MULTIPLICATION, true, false)}, {"%object%[ ]*[ ]\\(%object%\\)", new PatternInfo(Operator.MULTIPLICATION, false, true)}, {"%object%[ ]*[ ]%object%", new PatternInfo(Operator.MULTIPLICATION, false, false)}, {"\\(%object%\\)[ ]/[ ]\\(%object%\\)", new PatternInfo(Operator.DIVISION, true, true)}, {"\\(%object%\\)[ ]/[ ]%object%", new PatternInfo(Operator.DIVISION, true, false)}, {"%object%[ ]/[ ]\\(%object%\\)", new PatternInfo(Operator.DIVISION, false, true)}, {"%object%[ ]/[ ]%object%", new PatternInfo(Operator.DIVISION, false, false)}, {"\\(%object%\\)[ ]^[ ]\\(%object%\\)", new PatternInfo(Operator.EXPONENTIATION, true, true)}, {"\\(%object%\\)[ ]^[ ]%object%", new PatternInfo(Operator.EXPONENTIATION, true, false)}, {"%object%[ ]^[ ]\\(%object%\\)", new PatternInfo(Operator.EXPONENTIATION, false, true)}, {"%object%[ ]^[ ]%object%", new PatternInfo(Operator.EXPONENTIATION, false, false)}});
    private Expression<L> first;
    private Expression<R> second;
    private Operator operator;
    private Class<? extends T> returnType;
    private final List<Object> chain = new ArrayList<Object>();
    private ArithmeticGettable<? extends T> arithmeticGettable;
    private boolean leftGrouped;
    private boolean rightGrouped;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        Class<L> firstClass;
        this.first = exprs[0];
        this.second = exprs[1];
        PatternInfo patternInfo = patterns.getInfo(matchedPattern);
        this.leftGrouped = patternInfo.leftGrouped;
        this.rightGrouped = patternInfo.rightGrouped;
        this.operator = patternInfo.operator;
        if (this.first instanceof UnparsedLiteral) {
            if (this.second instanceof UnparsedLiteral) {
                for (OperationInfo<?, ?, ?> operation : Arithmetics.getOperations(this.operator)) {
                    Expression convertedSecond;
                    Expression convertedFirst = this.first.getConvertedExpression(operation.getLeft());
                    if (convertedFirst == null || (convertedSecond = this.second.getConvertedExpression(operation.getRight())) == null) continue;
                    this.first = convertedFirst;
                    this.second = convertedSecond;
                    this.returnType = operation.getReturnType();
                }
            } else {
                Class<R> secondClass = this.second.getReturnType();
                Class[] leftTypes = (Class[])Arithmetics.getOperations(this.operator).stream().filter(info -> info.getRight().isAssignableFrom(secondClass)).map(OperationInfo::getLeft).toArray(Class[]::new);
                if (leftTypes.length == 0) {
                    if (secondClass != Object.class) {
                        return this.error(this.first.getReturnType(), secondClass);
                    }
                    this.first = this.first.getConvertedExpression(Object.class);
                } else {
                    this.first = this.first.getConvertedExpression(leftTypes);
                }
            }
        } else if (this.second instanceof UnparsedLiteral) {
            firstClass = this.first.getReturnType();
            List<OperationInfo<L, ?, ?>> operations = Arithmetics.getOperations(this.operator, firstClass);
            if (operations.isEmpty()) {
                if (firstClass != Object.class) {
                    return this.error(firstClass, this.second.getReturnType());
                }
                this.second = this.second.getConvertedExpression(Object.class);
            } else {
                this.second = this.second.getConvertedExpression((Class[])operations.stream().map(OperationInfo::getRight).toArray(Class[]::new));
            }
        }
        if (!LiteralUtils.canInitSafely(this.first, this.second)) {
            return false;
        }
        firstClass = this.first.getReturnType();
        Class<R> secondClass = this.second.getReturnType();
        if (firstClass == Object.class || secondClass == Object.class) {
            Class[] returnTypes = null;
            if (firstClass != Object.class || secondClass != Object.class) {
                returnTypes = firstClass == Object.class ? (Class[])Arithmetics.getOperations(this.operator).stream().filter(info -> info.getRight().isAssignableFrom(secondClass)).map(OperationInfo::getReturnType).toArray(Class[]::new) : (Class[])Arithmetics.getOperations(this.operator, firstClass).stream().map(OperationInfo::getReturnType).toArray(Class[]::new);
            }
            if (returnTypes == null) {
                this.returnType = Object.class;
            } else {
                if (returnTypes.length == 0) {
                    return this.error(firstClass, secondClass);
                }
                this.returnType = Classes.getSuperClassInfo(returnTypes).getC();
            }
        } else if (this.returnType == null) {
            OperationInfo<L, R, ?> operationInfo = Arithmetics.lookupOperationInfo(this.operator, firstClass, secondClass);
            if (operationInfo == null) {
                return this.error(firstClass, secondClass);
            }
            this.returnType = operationInfo.getReturnType();
        }
        if (Number.class.isAssignableFrom(this.returnType)) {
            if (this.operator == Operator.DIVISION || this.operator == Operator.EXPONENTIATION) {
                this.returnType = Double.class;
            } else {
                boolean firstIsInt = false;
                boolean secondIsInt = false;
                for (Class<Object> clazz : INTEGER_CLASSES) {
                    firstIsInt |= clazz.isAssignableFrom(this.first.getReturnType());
                    secondIsInt |= clazz.isAssignableFrom(this.second.getReturnType());
                }
                Class clazz = this.returnType = firstIsInt && secondIsInt ? Long.class : Double.class;
            }
        }
        if (this.first instanceof ExprArithmetic && !this.leftGrouped) {
            this.chain.addAll(((ExprArithmetic)this.first).chain);
        } else {
            this.chain.add(this.first);
        }
        this.chain.add((Object)this.operator);
        if (this.second instanceof ExprArithmetic && !this.rightGrouped) {
            this.chain.addAll(((ExprArithmetic)this.second).chain);
        } else {
            this.chain.add(this.second);
        }
        this.arithmeticGettable = ArithmeticChain.parse(this.chain);
        return this.arithmeticGettable != null || this.error(firstClass, secondClass);
    }

    @Override
    protected T[] get(Event event) {
        T result = this.arithmeticGettable.get(event);
        Object[] one = (Object[])Array.newInstance(result == null ? this.returnType : result.getClass(), 1);
        one[0] = result;
        return one;
    }

    private boolean error(Class<?> firstClass, Class<?> secondClass) {
        ClassInfo<?> first = Classes.getSuperClassInfo(firstClass);
        ClassInfo<?> second = Classes.getSuperClassInfo(secondClass);
        if (first.getC() != Object.class && second.getC() != Object.class) {
            Skript.error(this.operator.getName() + " can't be performed on " + first.getName().withIndefiniteArticle() + " and " + second.getName().withIndefiniteArticle());
        }
        return false;
    }

    @Override
    public Class<? extends T> getReturnType() {
        return this.returnType;
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public String toString(@Nullable Event event, boolean debug) {
        String one = this.first.toString(event, debug);
        String two = this.second.toString(event, debug);
        if (this.leftGrouped) {
            one = '(' + one + ')';
        }
        if (this.rightGrouped) {
            two = '(' + two + ')';
        }
        return one + ' ' + (Object)((Object)this.operator) + ' ' + two;
    }

    @Override
    public Expression<? extends T> simplify() {
        if (this.first instanceof Literal && this.second instanceof Literal) {
            return new SimpleLiteral(this.getArray(null), this.getReturnType(), false);
        }
        return this;
    }

    static {
        Skript.registerExpression(ExprArithmetic.class, Object.class, ExpressionType.PATTERN_MATCHES_EVERYTHING, patterns.getPatterns());
    }

    private static class PatternInfo {
        public final Operator operator;
        public final boolean leftGrouped;
        public final boolean rightGrouped;

        public PatternInfo(Operator operator, boolean leftGrouped, boolean rightGrouped) {
            this.operator = operator;
            this.leftGrouped = leftGrouped;
            this.rightGrouped = rightGrouped;
        }
    }
}

