/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions.base;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAPIException;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.DefaultExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.localization.Noun;
import ch.njol.skript.log.ParseLogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.registrations.EventValues;
import ch.njol.skript.util.Getter;
import ch.njol.skript.util.Utils;
import ch.njol.util.Kleenean;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

public class EventValueExpression<T>
extends SimpleExpression<T>
implements DefaultExpression<T> {
    private final Map<Class<? extends Event>, Getter<? extends T, ?>> getters = new HashMap();
    private final Class<?> componentType;
    private final Class<? extends T> type;
    private @Nullable Changer<? super T> changer;
    private final boolean single;
    private final boolean exact;

    public static <T> void register(Class<? extends EventValueExpression<T>> expression, Class<T> type, String pattern) {
        Skript.registerExpression(expression, type, ExpressionType.EVENT, "[the] " + pattern);
    }

    public EventValueExpression(Class<? extends T> type) {
        this(type, null);
    }

    public EventValueExpression(Class<? extends T> type, boolean exact) {
        this(type, null, exact);
    }

    public EventValueExpression(Class<? extends T> type, @Nullable Changer<? super T> changer) {
        this(type, changer, false);
    }

    public EventValueExpression(Class<? extends T> type, @Nullable Changer<? super T> changer, boolean exact) {
        assert (type != null);
        this.type = type;
        this.exact = exact;
        this.changer = changer;
        this.single = !type.isArray();
        this.componentType = this.single ? type : type.getComponentType();
    }

    @Override
    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        if (expressions.length != 0) {
            throw new SkriptAPIException(this.getClass().getName() + " has expressions in its pattern but does not override init(...)");
        }
        return this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean init() {
        ParseLogHandler log = SkriptLogger.startParseLogHandler();
        try {
            boolean hasValue = false;
            Class<? extends Event>[] events = this.getParser().getCurrentEvents();
            if (events == null) {
                assert (false);
                boolean bl = false;
                return bl;
            }
            for (Class<? extends Event> event : events) {
                if (this.getters.containsKey(event)) {
                    hasValue = this.getters.get(event) != null;
                    continue;
                }
                if (EventValues.hasMultipleGetters(event, this.type, this.getTime()) == Kleenean.TRUE) {
                    Noun typeName = Classes.getExactClassInfo(this.componentType).getName();
                    log.printError("There are multiple " + typeName.toString(true) + " in " + Utils.a(this.getParser().getCurrentEventName()) + " event. You must define which " + typeName + " to use.");
                    boolean bl = false;
                    return bl;
                }
                Getter<Object, Object> getter = this.exact ? EventValues.getExactEventValueGetter(event, this.type, this.getTime()) : EventValues.getEventValueGetter(event, this.type, this.getTime());
                if (getter == null) continue;
                this.getters.put(event, getter);
                hasValue = true;
            }
            if (!hasValue) {
                log.printError("There's no " + Classes.getSuperClassInfo(this.componentType).getName().toString(!this.single) + " in " + Utils.a(this.getParser().getCurrentEventName()) + " event");
                boolean bl = false;
                return bl;
            }
            log.printLog();
            boolean bl = true;
            return bl;
        }
        finally {
            log.stop();
        }
    }

    @Override
    protected @Nullable T[] get(Event event) {
        T value = this.getValue(event);
        if (value == null) {
            return (Object[])Array.newInstance(this.componentType, 0);
        }
        if (this.single) {
            Object[] one = (Object[])Array.newInstance(this.type, 1);
            one[0] = value;
            return one;
        }
        Object[] dataArray = (Object[])value;
        Object[] array = (Object[])Array.newInstance(this.componentType, dataArray.length);
        System.arraycopy(dataArray, 0, array, 0, array.length);
        return array;
    }

    private <E extends Event> @Nullable T getValue(E event) {
        if (this.getters.containsKey(event.getClass())) {
            Getter<? extends T, ?> g = this.getters.get(event.getClass());
            return g == null ? null : (T)g.get(event);
        }
        for (Map.Entry<Class<Event>, Getter<T, ?>> p : this.getters.entrySet()) {
            if (!p.getKey().isAssignableFrom(event.getClass())) continue;
            this.getters.put(event.getClass(), p.getValue());
            return p.getValue() == null ? null : (T)p.getValue().get(event);
        }
        this.getters.put(event.getClass(), null);
        return null;
    }

    @Override
    public @Nullable Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (this.changer == null) {
            this.changer = Classes.getSuperClassInfo(this.componentType).getChanger();
        }
        return this.changer == null ? null : this.changer.acceptChange(mode);
    }

    @Override
    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (this.changer == null) {
            throw new SkriptAPIException("The changer cannot be null");
        }
        Changer.ChangerUtils.change(this.changer, this.getArray(event), delta, mode);
    }

    @Override
    public boolean setTime(int time) {
        Class<? extends Event>[] events = this.getParser().getCurrentEvents();
        if (events == null) {
            assert (false);
            return false;
        }
        for (Class<? extends Event> event : events) {
            assert (event != null);
            boolean has = this.exact ? EventValues.doesExactEventValueHaveTimeStates(event, this.type) : EventValues.doesEventValueHaveTimeStates(event, this.type);
            if (!has) continue;
            super.setTime(time);
            this.getters.clear();
            this.init();
            return true;
        }
        return false;
    }

    @Override
    public boolean isDefault() {
        return true;
    }

    @Override
    public boolean isSingle() {
        return this.single;
    }

    @Override
    public Class<? extends T> getReturnType() {
        return this.componentType;
    }

    @Override
    public String toString(@Nullable Event event, boolean debug) {
        if (!debug || event == null) {
            return "event-" + Classes.getSuperClassInfo(this.componentType).getName().toString(!this.single);
        }
        return Classes.getDebugMessage(this.getValue(event));
    }
}

