/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.LiteralList;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleLiteral;
import ch.njol.skript.registrations.Classes;
import ch.njol.util.Checker;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

public class ExpressionList<T>
implements Expression<T> {
    protected final Expression<? extends T>[] expressions;
    private final Class<T> returnType;
    protected boolean and;
    private final boolean single;
    private final @Nullable ExpressionList<?> source;
    private int time = 0;

    public ExpressionList(Expression<? extends T>[] expressions, Class<T> returnType, boolean and) {
        this(expressions, returnType, and, null);
    }

    protected ExpressionList(Expression<? extends T>[] expressions, Class<T> returnType, boolean and, @Nullable ExpressionList<?> source) {
        assert (expressions != null);
        this.expressions = expressions;
        this.returnType = returnType;
        this.and = and;
        if (and) {
            this.single = false;
        } else {
            boolean single = true;
            for (Expression<T> expression : expressions) {
                if (expression.isSingle()) continue;
                single = false;
                break;
            }
            this.single = single;
        }
        this.source = source;
    }

    @Override
    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        throw new UnsupportedOperationException();
    }

    @Override
    public @Nullable T getSingle(Event event) {
        if (!this.single) {
            throw new UnsupportedOperationException();
        }
        Expression<? extends T> expression = CollectionUtils.getRandom(this.expressions);
        return expression != null ? (T)expression.getSingle(event) : null;
    }

    @Override
    public T[] getArray(Event event) {
        if (this.and) {
            return this.getAll(event);
        }
        Expression<T> expression = CollectionUtils.getRandom(this.expressions);
        return expression != null ? expression.getArray(event) : (Object[])Array.newInstance(this.returnType, 0);
    }

    @Override
    public T[] getAll(Event event) {
        ArrayList<T> values = new ArrayList<T>();
        for (Expression<T> expression : this.expressions) {
            values.addAll(Arrays.asList(expression.getAll(event)));
        }
        return values.toArray((Object[])Array.newInstance(this.returnType, values.size()));
    }

    @Override
    public @Nullable Iterator<? extends T> iterator(final Event event) {
        if (!this.and) {
            Expression<T> expression = CollectionUtils.getRandom(this.expressions);
            return expression != null ? expression.iterator(event) : null;
        }
        return new Iterator<T>(){
            private int i = 0;
            private @Nullable Iterator<? extends T> current = null;

            @Override
            public boolean hasNext() {
                Iterator iterator = this.current;
                while (!(this.i >= ExpressionList.this.expressions.length || iterator != null && iterator.hasNext())) {
                    iterator = ExpressionList.this.expressions[this.i++].iterator(event);
                    this.current = iterator;
                }
                return iterator != null && iterator.hasNext();
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Iterator iterator = this.current;
                if (iterator == null) {
                    throw new NoSuchElementException();
                }
                Object value = iterator.next();
                assert (value != null) : this.current;
                return value;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public boolean isSingle() {
        return this.single;
    }

    @Override
    public boolean check(Event event, Checker<? super T> checker, boolean negated) {
        for (Expression<? super T> expression : this.expressions) {
            boolean result = expression.check(event, checker) ^ negated;
            if (this.and && !result) {
                return false;
            }
            if (this.and || !result) continue;
            return true;
        }
        return this.and;
    }

    @Override
    public boolean check(Event event, Checker<? super T> checker) {
        return this.check(event, checker, false);
    }

    @Override
    public <R> @Nullable Expression<? extends R> getConvertedExpression(Class<R> ... to) {
        Expression[] exprs = new Expression[this.expressions.length];
        Class[] returnTypes = new Class[this.expressions.length];
        for (int i = 0; i < exprs.length; ++i) {
            exprs[i] = this.expressions[i].getConvertedExpression(to);
            if (exprs[i] == null) {
                return null;
            }
            returnTypes[i] = exprs[i].getReturnType();
        }
        return new ExpressionList(exprs, Classes.getSuperClassInfo(returnTypes).getC(), this.and, this);
    }

    @Override
    public Class<T> getReturnType() {
        return this.returnType;
    }

    @Override
    public boolean getAnd() {
        return this.and;
    }

    public void invertAnd() {
        this.and = !this.and;
    }

    @Override
    public @Nullable Class<?>[] acceptChange(Changer.ChangeMode mode) {
        Class<?>[] exprClasses = this.expressions[0].acceptChange(mode);
        if (exprClasses == null) {
            return null;
        }
        ArrayList acceptedClasses = new ArrayList(Arrays.asList(exprClasses));
        for (int i = 1; i < this.expressions.length; ++i) {
            exprClasses = this.expressions[i].acceptChange(mode);
            if (exprClasses == null) {
                return null;
            }
            acceptedClasses.retainAll(Arrays.asList(exprClasses));
            if (!acceptedClasses.isEmpty()) continue;
            return null;
        }
        return acceptedClasses.toArray(new Class[0]);
    }

    @Override
    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) throws UnsupportedOperationException {
        for (Expression<T> expression : this.expressions) {
            expression.change(event, delta, mode);
        }
    }

    @Override
    public boolean setTime(int time) {
        boolean ok = false;
        for (Expression<T> expression : this.expressions) {
            ok |= expression.setTime(time);
        }
        if (ok) {
            this.time = time;
        }
        return ok;
    }

    @Override
    public int getTime() {
        return this.time;
    }

    @Override
    public boolean isDefault() {
        return false;
    }

    @Override
    public boolean isLoopOf(String input) {
        for (Expression<T> expression : this.expressions) {
            if (!expression.isLoopOf(input)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Expression<?> getSource() {
        ExpressionList<?> source = this.source;
        return source == null ? this : source;
    }

    @Override
    public String toString(@Nullable Event event, boolean debug) {
        StringBuilder result = new StringBuilder("(");
        for (int i = 0; i < this.expressions.length; ++i) {
            if (i != 0) {
                if (i == this.expressions.length - 1) {
                    result.append(this.and ? " and " : " or ");
                } else {
                    result.append(", ");
                }
            }
            result.append(this.expressions[i].toString(event, debug));
        }
        result.append(")");
        if (debug) {
            result.append("[").append(this.returnType).append("]");
        }
        return result.toString();
    }

    @Override
    public String toString() {
        return this.toString(null, false);
    }

    public Expression<? extends T>[] getExpressions() {
        return this.expressions;
    }

    @Override
    public Expression<T> simplify() {
        boolean isLiteralList = true;
        boolean isSimpleList = true;
        for (int i = 0; i < this.expressions.length; ++i) {
            this.expressions[i] = this.expressions[i].simplify();
            isLiteralList &= this.expressions[i] instanceof Literal;
            isSimpleList &= this.expressions[i].isSingle();
        }
        if (isLiteralList && isSimpleList) {
            Object[] values = (Object[])Array.newInstance(this.returnType, this.expressions.length);
            for (int i = 0; i < values.length; ++i) {
                values[i] = ((Literal)this.expressions[i]).getSingle();
            }
            return new SimpleLiteral<Object>(values, this.returnType, this.and);
        }
        if (isLiteralList) {
            Literal[] ls = (Literal[])Arrays.copyOf(this.expressions, this.expressions.length, Literal[].class);
            return new LiteralList<T>(ls, this.returnType, this.and);
        }
        return this;
    }
}

