/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang.util;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.registrations.Classes;
import ch.njol.util.Checker;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;
import org.skriptlang.skript.lang.converter.Converter;
import org.skriptlang.skript.lang.converter.ConverterInfo;
import org.skriptlang.skript.lang.converter.Converters;

public class ConvertedExpression<F, T>
implements Expression<T> {
    protected Expression<? extends F> source;
    protected Class<T> to;
    final Converter<? super F, ? extends T> converter;
    private final ConverterInfo<? super F, ? extends T> converterInfo;
    private @Nullable ClassInfo<? super T> returnTypeInfo;

    public ConvertedExpression(Expression<? extends F> source, Class<T> to, ConverterInfo<? super F, ? extends T> info) {
        this.source = source;
        this.to = to;
        this.converter = info.getConverter();
        this.converterInfo = info;
    }

    @SafeVarargs
    public static <F, T> @Nullable ConvertedExpression<F, T> newInstance(Expression<F> from, Class<T> ... to) {
        assert (!CollectionUtils.containsSuperclass(to, from.getReturnType()));
        for (Class<T> type : to) {
            assert (type != null);
            ConverterInfo<F, T> conv = Converters.getConverterInfo(from.getReturnType(), type);
            if (conv == null) continue;
            return new ConvertedExpression<F, T>(from, type, conv);
        }
        return null;
    }

    @Override
    public final boolean init(Expression<?>[] vars, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult matcher) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString(@Nullable Event event, boolean debug) {
        if (debug && event == null) {
            return "(" + this.source.toString(event, debug) + " >> " + this.converter + ": " + this.converterInfo + ")";
        }
        return this.source.toString(event, debug);
    }

    @Override
    public String toString() {
        return this.toString(null, false);
    }

    @Override
    public Class<T> getReturnType() {
        return this.to;
    }

    @Override
    public boolean isSingle() {
        return this.source.isSingle();
    }

    @Override
    public <R> @Nullable Expression<? extends R> getConvertedExpression(Class<R> ... to) {
        if (CollectionUtils.containsSuperclass(to, this.to)) {
            return this;
        }
        return this.source.getConvertedExpression(to);
    }

    @Override
    public @Nullable Class<?>[] acceptChange(Changer.ChangeMode mode) {
        Class<?>[] validClasses = this.source.acceptChange(mode);
        if (validClasses == null) {
            ClassInfo<T> returnTypeInfo = Classes.getSuperClassInfo(this.getReturnType());
            this.returnTypeInfo = returnTypeInfo;
            Changer<T> changer = returnTypeInfo.getChanger();
            return changer == null ? null : changer.acceptChange(mode);
        }
        return validClasses;
    }

    @Override
    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        ClassInfo<T> returnTypeInfo = this.returnTypeInfo;
        if (returnTypeInfo != null) {
            Changer<T> changer = returnTypeInfo.getChanger();
            if (changer != null) {
                changer.change(this.getArray(event), delta, mode);
            }
        } else {
            this.source.change(event, delta, mode);
        }
    }

    @Override
    public @Nullable T getSingle(Event event) {
        F value = this.source.getSingle(event);
        if (value == null) {
            return null;
        }
        return this.converter.convert(value);
    }

    @Override
    public T[] getArray(Event event) {
        return Converters.convert(this.source.getArray(event), this.to, this.converter);
    }

    @Override
    public T[] getAll(Event event) {
        return Converters.convert(this.source.getAll(event), this.to, this.converter);
    }

    @Override
    public boolean check(Event event, Checker<? super T> checker, boolean negated) {
        return negated ^ this.check(event, checker);
    }

    @Override
    public boolean check(Event event, Checker<? super T> checker) {
        return this.source.check(event, value -> {
            T convertedValue = this.converter.convert(value);
            if (convertedValue == null) {
                return false;
            }
            return checker.check((T)convertedValue);
        });
    }

    @Override
    public boolean getAnd() {
        return this.source.getAnd();
    }

    @Override
    public boolean setTime(int time) {
        return this.source.setTime(time);
    }

    @Override
    public int getTime() {
        return this.source.getTime();
    }

    @Override
    public boolean isDefault() {
        return this.source.isDefault();
    }

    @Override
    public boolean isLoopOf(String input) {
        return false;
    }

    @Override
    public @Nullable Iterator<T> iterator(Event event) {
        final Iterator<? extends F> iterator = this.source.iterator(event);
        if (iterator == null) {
            return null;
        }
        return new Iterator<T>(){
            @Nullable T next = null;

            @Override
            public boolean hasNext() {
                if (this.next != null) {
                    return true;
                }
                while (this.next == null && iterator.hasNext()) {
                    Object value = iterator.next();
                    this.next = value == null ? null : ConvertedExpression.this.converter.convert(value);
                }
                return this.next != null;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object n = this.next;
                this.next = null;
                assert (n != null);
                return n;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Expression<?> getSource() {
        return this.source;
    }

    @Override
    public Expression<? extends T> simplify() {
        Expression convertedExpression = this.source.simplify().getConvertedExpression(this.to);
        if (convertedExpression != null) {
            return convertedExpression;
        }
        return this;
    }

    @Override
    public @Nullable Object[] beforeChange(Expression<?> changed, @Nullable Object[] delta) {
        return this.source.beforeChange(changed, delta);
    }
}

