/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.patterns;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.UnparsedLiteral;
import ch.njol.skript.lang.parser.ParserInstance;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.patterns.LiteralPatternElement;
import ch.njol.skript.patterns.MatchResult;
import ch.njol.skript.patterns.PatternElement;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.Utils;
import ch.njol.util.Kleenean;
import ch.njol.util.NonNullPair;
import org.jetbrains.annotations.Nullable;

public class TypePatternElement
extends PatternElement {
    private final ClassInfo<?>[] classes;
    private final boolean[] isPlural;
    private final boolean isNullable;
    private final int flagMask;
    private final int time;
    private final int expressionIndex;

    public TypePatternElement(ClassInfo<?>[] classes, boolean[] isPlural, boolean isNullable, int flagMask, int time, int expressionIndex) {
        this.classes = classes;
        this.isPlural = isPlural;
        this.isNullable = isNullable;
        this.flagMask = flagMask;
        this.time = time;
        this.expressionIndex = expressionIndex;
    }

    public static TypePatternElement fromString(String s, int expressionIndex) {
        boolean isNullable = s.startsWith("-");
        if (isNullable) {
            s = s.substring(1);
        }
        int flagMask = -1;
        if (s.startsWith("*")) {
            s = s.substring(1);
            flagMask &= 0xFFFFFFFE;
        } else if (s.startsWith("~")) {
            s = s.substring(1);
            flagMask &= 0xFFFFFFFD;
        }
        if (!isNullable && (isNullable = s.startsWith("-"))) {
            s = s.substring(1);
        }
        int time = 0;
        int timeStart = s.indexOf("@");
        if (timeStart != -1) {
            time = Integer.parseInt(s.substring(timeStart + 1));
            s = s.substring(0, timeStart);
        }
        String[] classes = s.split("/");
        ClassInfo[] classInfos = new ClassInfo[classes.length];
        boolean[] isPlural = new boolean[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            NonNullPair<String, Boolean> p = Utils.getEnglishPlural(classes[i]);
            classInfos[i] = Classes.getClassInfo(p.getFirst());
            isPlural[i] = p.getSecond();
        }
        return new TypePatternElement(classInfos, isPlural, isNullable, flagMask, time, expressionIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public MatchResult match(String expr, MatchResult matchResult) {
        nextLiteral = null;
        nextLiteralIsWhitespace = false;
        if (this.next == null) {
            newExprOffset = expr.length();
        } else if (this.next instanceof LiteralPatternElement) {
            nextLiteral = this.next.toString();
            nextLiteralIsWhitespace = nextLiteral.trim().isEmpty();
            if (!nextLiteralIsWhitespace) {
                for (i = nextLength = nextLiteral.length(); i > 0; --i) {
                    if (nextLiteral.charAt(i - 1) == ' ') continue;
                    if (i == nextLength) break;
                    nextLiteral = nextLiteral.substring(0, i);
                    break;
                }
            }
            if ((newExprOffset = SkriptParser.nextOccurrence(expr, nextLiteral, matchResult.exprOffset, matchResult.parseContext, false)) == -1 && nextLiteralIsWhitespace) {
                nextLiteral = null;
                newExprOffset = SkriptParser.next(expr, matchResult.exprOffset, matchResult.parseContext);
            }
        } else {
            newExprOffset = SkriptParser.next(expr, matchResult.exprOffset, matchResult.parseContext);
        }
        if (newExprOffset == -1) {
            return null;
        }
        exprInfo = this.getExprInfo();
        matchBackup = null;
        loopLogHandlerBackup = null;
        expressionLogHandlerBackup = null;
        loopLogHandler = SkriptLogger.startParseLogHandler();
        while (true) {
            block30: {
                block37: {
                    block38: {
                        block39: {
                            block35: {
                                block36: {
                                    block33: {
                                        block34: {
                                            block31: {
                                                block32: {
                                                    try {
                                                        if (newExprOffset == -1) break;
                                                        loopLogHandler.clear();
                                                        matchResultCopy = matchResult.copy();
                                                        matchResultCopy.exprOffset = newExprOffset;
                                                        newMatchResult = this.matchNext(expr, matchResultCopy);
                                                        if (newMatchResult == null) break block30;
                                                        expressionLogHandler = SkriptLogger.startParseLogHandler();
                                                        expression = new SkriptParser(expr.substring(matchResult.exprOffset, newExprOffset), matchResult.flags & this.flagMask, matchResult.parseContext).parseExpression(exprInfo);
                                                        if (expression == null) break block30;
                                                        if (this.time == 0) ** GOTO lbl-1000
                                                        if (expression instanceof Literal) {
                                                            var15_19 = null;
                                                            expressionLogHandler.printError();
                                                            if (loopLogHandlerBackup == null) break block31;
                                                            loopLogHandler.restore(loopLogHandlerBackup);
                                                            if (TypePatternElement.$assertionsDisabled || expressionLogHandlerBackup != null) break block32;
                                                            throw new AssertionError();
                                                        }
                                                        ** GOTO lbl-1000
                                                    }
                                                    catch (Throwable var18_25) {
                                                        if (loopLogHandlerBackup != null) {
                                                            loopLogHandler.restore(loopLogHandlerBackup);
                                                            if (!TypePatternElement.$assertionsDisabled && expressionLogHandlerBackup == null) {
                                                                throw new AssertionError();
                                                            }
                                                            expressionLogHandlerBackup.printLog();
                                                        }
                                                        if (loopLogHandler.isStopped() != false) throw var18_25;
                                                        loopLogHandler.printError();
                                                        throw var18_25;
                                                    }
                                                }
                                                expressionLogHandlerBackup.printLog();
                                            }
                                            if (loopLogHandler.isStopped() != false) return var15_19;
                                            loopLogHandler.printError();
                                            return var15_19;
lbl-1000:
                                            // 1 sources

                                            {
                                                if (ParserInstance.get().getHasDelayBefore() != Kleenean.TRUE) ** GOTO lbl-1000
                                                Skript.error("Cannot use time states after the event has already passed", ErrorQuality.SEMANTIC_ERROR);
                                                var15_20 = null;
                                                expressionLogHandler.printError();
                                                if (loopLogHandlerBackup == null) break block33;
                                                loopLogHandler.restore(loopLogHandlerBackup);
                                                if (TypePatternElement.$assertionsDisabled || expressionLogHandlerBackup != null) break block34;
                                            }
                                            throw new AssertionError();
                                        }
                                        expressionLogHandlerBackup.printLog();
                                    }
                                    if (loopLogHandler.isStopped() != false) return var15_20;
                                    loopLogHandler.printError();
                                    return var15_20;
lbl-1000:
                                    // 1 sources

                                    {
                                        if (expression.setTime(this.time)) ** GOTO lbl-1000
                                        Skript.error(expression + " does not have a " + (this.time == -1 ? "past" : "future") + " state", ErrorQuality.SEMANTIC_ERROR);
                                        var15_21 = null;
                                        expressionLogHandler.printError();
                                        if (loopLogHandlerBackup == null) break block35;
                                        loopLogHandler.restore(loopLogHandlerBackup);
                                        if (TypePatternElement.$assertionsDisabled || expressionLogHandlerBackup != null) break block36;
                                    }
                                    throw new AssertionError();
                                }
                                expressionLogHandlerBackup.printLog();
                            }
                            if (loopLogHandler.isStopped() != false) return var15_21;
                            loopLogHandler.printError();
                            return var15_21;
lbl-1000:
                            // 2 sources

                            {
                                newMatchResult.expressions[this.expressionIndex] = expression;
                                hasUnparsedLiteral = false;
                                for (i = this.expressionIndex + 1; i < newMatchResult.expressions.length; ++i) {
                                    if (!(newMatchResult.expressions[i] instanceof UnparsedLiteral)) continue;
                                    v0 = hasUnparsedLiteral = Classes.parse(((UnparsedLiteral)newMatchResult.expressions[i]).getData(), Object.class, newMatchResult.parseContext) == null;
                                    if (hasUnparsedLiteral) break;
                                }
                                if (hasUnparsedLiteral) break block37;
                                expressionLogHandler.printLog();
                                loopLogHandler.printLog();
                                var16_23 = newMatchResult;
                                expressionLogHandler.printError();
                                if (loopLogHandlerBackup == null) break block38;
                                loopLogHandler.restore(loopLogHandlerBackup);
                                if (TypePatternElement.$assertionsDisabled || expressionLogHandlerBackup != null) break block39;
                            }
                            throw new AssertionError();
                        }
                        expressionLogHandlerBackup.printLog();
                    }
                    if (loopLogHandler.isStopped() != false) return var16_23;
                    loopLogHandler.printError();
                    return var16_23;
                }
                ** try [egrp 9[TRYBLOCK] [4 : 733->756)] { 
lbl117:
                // 1 sources

                if (matchBackup == null) {
                    matchBackup = newMatchResult;
                    loopLogHandlerBackup = loopLogHandler.backup();
                    expressionLogHandlerBackup = expressionLogHandler.backup();
                }
                break block30;
lbl122:
                // 1 sources

                finally {
                    expressionLogHandler.printError();
                }
            }
            if (nextLiteral != null) {
                oldNewExprOffset = newExprOffset;
                if ((newExprOffset = SkriptParser.nextOccurrence(expr, nextLiteral, newExprOffset + 1, matchResult.parseContext, false)) != -1 || !nextLiteralIsWhitespace) continue;
                nextLiteral = null;
                newExprOffset = SkriptParser.next(expr, oldNewExprOffset, matchResult.parseContext);
                continue;
            }
            newExprOffset = SkriptParser.next(expr, newExprOffset, matchResult.parseContext);
        }
        if (loopLogHandlerBackup != null) {
            loopLogHandler.restore(loopLogHandlerBackup);
            if (!TypePatternElement.$assertionsDisabled && expressionLogHandlerBackup == null) {
                throw new AssertionError();
            }
            expressionLogHandlerBackup.printLog();
        }
        if (loopLogHandler.isStopped() != false) return matchBackup;
        loopLogHandler.printError();
        return matchBackup;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("%");
        if (this.isNullable) {
            stringBuilder.append("-");
        }
        if (this.flagMask != -1) {
            if ((this.flagMask & 2) == 0) {
                stringBuilder.append("~");
            } else if ((this.flagMask & 1) == 0) {
                stringBuilder.append("*");
            }
        }
        for (int i = 0; i < this.classes.length; ++i) {
            String codeName = this.classes[i].getCodeName();
            if (this.isPlural[i]) {
                stringBuilder.append(Utils.toEnglishPlural(codeName));
            } else {
                stringBuilder.append(codeName);
            }
            if (i == this.classes.length - 1) continue;
            stringBuilder.append("/");
        }
        if (this.time != 0) {
            stringBuilder.append("@").append(this.time);
        }
        return stringBuilder.append("%").toString();
    }

    private SkriptParser.ExprInfo getExprInfo() {
        SkriptParser.ExprInfo exprInfo = new SkriptParser.ExprInfo(this.classes.length);
        for (int i = 0; i < this.classes.length; ++i) {
            exprInfo.classes[i] = this.classes[i];
            exprInfo.isPlural[i] = this.isPlural[i];
        }
        exprInfo.isOptional = this.isNullable;
        exprInfo.flagMask = this.flagMask;
        exprInfo.time = this.time;
        return exprInfo;
    }
}

