/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.sections;

import ch.njol.skript.Skript;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.entity.EntityType;
import ch.njol.skript.lang.EffectSection;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.registrations.EventValues;
import ch.njol.skript.util.Direction;
import ch.njol.skript.util.Getter;
import ch.njol.skript.variables.Variables;
import ch.njol.util.Kleenean;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Spawn")
@Description(value={"Spawn a creature. This can be used as an effect and as a section.", "If it is used as a section, the section is run before the entity is added to the world.", "You can modify the entity in this section, using for example 'event-entity' or 'cow'. ", "Do note that other event values, such as 'player', won't work in this section."})
@Examples(value={"spawn 3 creepers at the targeted block", "spawn a ghast 5 meters above the player", "spawn a zombie at the player:", "\tset name of the zombie to \"\""})
@Since(value="1.0, 2.6.1 (with section)")
public class EffSecSpawn
extends EffectSection {
    private Expression<Location> locations;
    private Expression<EntityType> types;
    @Nullable
    private Expression<Number> amount;
    @Nullable
    public static Entity lastSpawned;
    @Nullable
    private Trigger trigger;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult, @Nullable SectionNode sectionNode, @Nullable List<TriggerItem> triggerItems) {
        this.amount = matchedPattern == 0 ? null : exprs[0];
        this.types = exprs[matchedPattern];
        this.locations = Direction.combine(exprs[1 + matchedPattern], exprs[2 + matchedPattern]);
        if (sectionNode != null) {
            AtomicBoolean delayed = new AtomicBoolean(false);
            Runnable afterLoading = () -> delayed.set(!this.getParser().getHasDelayBefore().isFalse());
            this.trigger = this.loadCode(sectionNode, "spawn", afterLoading, SpawnEvent.class);
            if (delayed.get()) {
                Skript.error("Delays can't be used within a Spawn Effect Section");
                return false;
            }
        }
        return true;
    }

    @Override
    @Nullable
    protected TriggerItem walk(Event event) {
        Integer numberAmount;
        lastSpawned = null;
        Consumer<Entity> consumer = this.trigger != null ? o -> {
            lastSpawned = o;
            SpawnEvent spawnEvent = new SpawnEvent((Entity)o);
            Variables.setLocalVariables(spawnEvent, Variables.copyLocalVariables(event));
            TriggerItem.walk(this.trigger, spawnEvent);
            Variables.setLocalVariables(event, Variables.copyLocalVariables(spawnEvent));
            Variables.removeLocals(spawnEvent);
        } : null;
        Number number = numberAmount = this.amount != null ? (Number)this.amount.getSingle(event) : (Number)1;
        if (numberAmount != null) {
            double amount = ((Number)numberAmount).doubleValue();
            EntityType[] types = this.types.getArray(event);
            for (Location location : this.locations.getArray(event)) {
                for (EntityType type : types) {
                    double typeAmount = amount * (double)type.getAmount();
                    int i = 0;
                    while ((double)i < typeAmount) {
                        if (consumer != null) {
                            type.data.spawn(location, consumer);
                        } else {
                            lastSpawned = type.data.spawn(location);
                        }
                        ++i;
                    }
                }
            }
        }
        return super.walk(event, false);
    }

    @Override
    public String toString(@Nullable Event event, boolean debug) {
        return "spawn " + (this.amount != null ? this.amount.toString(event, debug) + " of " : "") + this.types.toString(event, debug) + " " + this.locations.toString(event, debug);
    }

    static {
        Skript.registerSection(EffSecSpawn.class, "(spawn|summon) %entitytypes% [%directions% %locations%]", "(spawn|summon) %number% of %entitytypes% [%directions% %locations%]");
        EventValues.registerEventValue(SpawnEvent.class, Entity.class, new Getter<Entity, SpawnEvent>(){

            @Override
            public Entity get(SpawnEvent spawnEvent) {
                return spawnEvent.getEntity();
            }
        }, 0);
    }

    public static class SpawnEvent
    extends Event {
        private final Entity entity;

        public SpawnEvent(Entity entity) {
            this.entity = entity;
        }

        public Entity getEntity() {
            return this.entity;
        }

        @NotNull
        public HandlerList getHandlers() {
            throw new IllegalStateException();
        }
    }
}

