/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util;

import ch.njol.skript.bukkitutil.WorldUtils;
import ch.njol.util.Math2;
import ch.njol.util.NullableChecker;
import ch.njol.util.coll.iterator.StoppableIterator;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.util.BlockIterator;
import org.bukkit.util.Vector;
import org.eclipse.jdt.annotation.Nullable;

public class BlockLineIterator
extends StoppableIterator<Block> {
    public BlockLineIterator(final Block start, final Block end) throws IllegalStateException {
        super(new BlockIterator(start.getWorld(), BlockLineIterator.fitInWorld(start.getLocation().add(0.5, 0.5, 0.5), end.getLocation().subtract(start.getLocation()).toVector()), end.equals(start) ? new Vector(1, 0, 0) : end.getLocation().subtract(start.getLocation()).toVector(), 0.0, 0), new NullableChecker<Block>(){
            private final double overshotSq;
            {
                this.overshotSq = Math.pow(start.getLocation().distance(end.getLocation()) + 2.0, 2.0);
            }

            @Override
            public boolean check(@Nullable Block block) {
                assert (block != null);
                if (block.getLocation().distanceSquared(start.getLocation()) > this.overshotSq) {
                    throw new IllegalStateException("BlockLineIterator missed the end block!");
                }
                return block.equals(end);
            }
        }, true);
    }

    public BlockLineIterator(final Location start, Vector direction, final double distance) throws IllegalStateException {
        super(new BlockIterator(start.getWorld(), BlockLineIterator.fitInWorld(start, direction), direction, 0.0, 0), new NullableChecker<Block>(){
            private final double distSq;
            {
                this.distSq = distance * distance;
            }

            @Override
            public boolean check(@Nullable Block b) {
                return b != null && b.getLocation().add(0.5, 0.5, 0.5).distanceSquared(start) >= this.distSq;
            }
        }, false);
    }

    public BlockLineIterator(Block start, Vector direction, double distance) throws IllegalStateException {
        this(start.getLocation().add(0.5, 0.5, 0.5), direction, distance);
    }

    private static Vector fitInWorld(Location location, Vector direction) {
        int lowest = WorldUtils.getWorldMinHeight(location.getWorld());
        int highest = location.getWorld().getMaxHeight();
        Vector vector = location.toVector();
        int y = location.getBlockY();
        if (y >= lowest && y <= highest) {
            return vector;
        }
        double newY = Math2.fit((double)lowest, location.getY(), (double)highest);
        return new Vector(location.getX(), newY, location.getZ());
    }
}

