/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util;

import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.bukkitutil.EnchantmentUtils;
import ch.njol.skript.localization.Language;
import ch.njol.skript.util.Utils;
import ch.njol.yggdrasil.YggdrasilSerializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.bukkit.enchantments.Enchantment;
import org.eclipse.jdt.annotation.Nullable;

public class EnchantmentType
implements YggdrasilSerializable {
    private static final String LANGUAGE_NODE = "enchantments";
    private final Enchantment type;
    private final int level;
    private static final Map<Enchantment, String> NAMES = new HashMap<Enchantment, String>();
    private static final Map<String, Enchantment> PATTERNS = new HashMap<String, Enchantment>();
    private static final Pattern pattern;

    private EnchantmentType() {
        this.type = null;
        this.level = -1;
    }

    public EnchantmentType(Enchantment type) {
        assert (type != null);
        this.type = type;
        this.level = -1;
    }

    public EnchantmentType(Enchantment type, int level) {
        assert (type != null);
        this.type = type;
        this.level = level;
    }

    public int getLevel() {
        return this.level == -1 ? 1 : this.level;
    }

    public int getInternalLevel() {
        return this.level;
    }

    public @Nullable Enchantment getType() {
        return this.type;
    }

    @Deprecated
    public boolean has(ItemType item) {
        return item.hasEnchantments(this.type);
    }

    public String toString() {
        return EnchantmentType.toString(this.type) + (this.level == -1 ? "" : " " + this.level);
    }

    public static String toString(Enchantment e) {
        return NAMES.get(e);
    }

    public static String toString(Enchantment e, int flags) {
        return NAMES.get(e);
    }

    public static @Nullable EnchantmentType parse(String s) {
        if (pattern.matcher(s).matches()) {
            String name = s.substring(0, s.lastIndexOf(32));
            assert (name != null);
            Enchantment ench = EnchantmentType.parseEnchantment(name);
            if (ench == null) {
                return null;
            }
            String level = s.substring(s.lastIndexOf(32) + 1);
            assert (level != null);
            return new EnchantmentType(ench, Utils.parseInt(level));
        }
        Enchantment ench = EnchantmentType.parseEnchantment(s);
        if (ench == null) {
            return null;
        }
        return new EnchantmentType(ench, -1);
    }

    public static @Nullable Enchantment parseEnchantment(String s) {
        return PATTERNS.get(s.toLowerCase(Locale.ENGLISH));
    }

    public static Collection<String> getNames() {
        return NAMES.values();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.level;
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnchantmentType)) {
            return false;
        }
        EnchantmentType other = (EnchantmentType)obj;
        if (this.level != other.level) {
            return false;
        }
        return this.type.equals(other.type);
    }

    static {
        Language.addListener(() -> {
            NAMES.clear();
            for (Enchantment e : Enchantment.values()) {
                assert (e != null);
                String[] names = Language.getList("enchantments.names." + EnchantmentUtils.getKey(e));
                NAMES.put(e, names[0]);
                for (String name : names) {
                    PATTERNS.put(name.toLowerCase(Locale.ENGLISH), e);
                }
            }
        });
        pattern = Pattern.compile(".+ \\d+");
    }
}

