/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util;

import ch.njol.skript.Skript;
import ch.njol.skript.localization.GeneralWords;
import ch.njol.skript.localization.Language;
import ch.njol.skript.localization.LanguageChangeListener;
import ch.njol.skript.localization.Noun;
import ch.njol.skript.util.Utils;
import ch.njol.util.NonNullPair;
import ch.njol.util.coll.CollectionUtils;
import ch.njol.yggdrasil.YggdrasilSerializable;
import java.util.HashMap;
import java.util.Locale;
import org.eclipse.jdt.annotation.Nullable;
import org.jetbrains.annotations.ApiStatus;

public class Timespan
implements YggdrasilSerializable,
Comparable<Timespan> {
    private static final Noun m_tick = new Noun("time.tick");
    private static final Noun m_second = new Noun("time.second");
    private static final Noun m_minute = new Noun("time.minute");
    private static final Noun m_hour = new Noun("time.hour");
    private static final Noun m_day = new Noun("time.day");
    private static final Noun m_week = new Noun("time.week");
    private static final Noun m_month = new Noun("time.month");
    private static final Noun m_year = new Noun("time.year");
    static final Noun[] names = new Noun[]{m_tick, m_second, m_minute, m_hour, m_day, m_week, m_month, m_year};
    static final long[] times = new long[]{50L, 1000L, 60000L, 3600000L, 86400000L, 604800000L, 2592000000L, 31536000000L};
    static final HashMap<String, Long> parseValues = new HashMap();
    private final long millis;
    static final NonNullPair<Noun, Long>[] simpleValues;

    public static @Nullable Timespan parse(String s) {
        if (s.isEmpty()) {
            return null;
        }
        long t = 0L;
        boolean minecraftTime = false;
        boolean isMinecraftTimeSet = false;
        if (s.matches("^\\d+:\\d\\d(:\\d\\d)?(\\.\\d{1,4})?$")) {
            String[] ss = s.split("[:.]");
            long[] times = new long[]{3600000L, 60000L, 1000L, 1L};
            int offset = ss.length == 3 && !s.contains(".") || ss.length == 4 ? 0 : 1;
            for (int i = 0; i < ss.length; ++i) {
                t += times[offset + i] * Utils.parseLong("" + ss[i]);
            }
        } else {
            String[] subs = s.toLowerCase(Locale.ENGLISH).split("\\s+");
            for (int i = 0; i < subs.length; ++i) {
                Long d;
                String sub = subs[i];
                if (sub.equals(GeneralWords.and.toString())) {
                    if (i != 0 && i != subs.length - 1) continue;
                    return null;
                }
                double amount = 1.0;
                if (Noun.isIndefiniteArticle(sub)) {
                    if (i == subs.length - 1) {
                        return null;
                    }
                    amount = 1.0;
                    sub = subs[++i];
                } else if (sub.matches("^\\d+(\\.\\d+)?$")) {
                    if (i == subs.length - 1) {
                        return null;
                    }
                    try {
                        amount = Double.parseDouble(sub);
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("invalid timespan: " + s);
                    }
                    sub = subs[++i];
                }
                if (CollectionUtils.contains(Language.getList("time.real"), sub)) {
                    if (i == subs.length - 1 || isMinecraftTimeSet && minecraftTime) {
                        return null;
                    }
                    sub = subs[++i];
                } else if (CollectionUtils.contains(Language.getList("time.minecraft"), sub)) {
                    if (i == subs.length - 1 || isMinecraftTimeSet && !minecraftTime) {
                        return null;
                    }
                    minecraftTime = true;
                    sub = subs[++i];
                }
                if (sub.endsWith(",")) {
                    sub = sub.substring(0, sub.length() - 1);
                }
                if ((d = parseValues.get(sub.toLowerCase(Locale.ENGLISH))) == null) {
                    return null;
                }
                if (minecraftTime && d != times[0]) {
                    amount /= 72.0;
                }
                t += Math.round(amount * (double)d.longValue());
                isMinecraftTimeSet = true;
            }
        }
        return new Timespan(t);
    }

    public Timespan() {
        this.millis = 0L;
    }

    public Timespan(long millis) {
        if (millis < 0L) {
            throw new IllegalArgumentException("millis must be >= 0");
        }
        this.millis = millis;
    }

    public static Timespan fromTicks(long ticks) {
        return new Timespan(ticks * 50L);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static Timespan fromTicks_i(long ticks) {
        return new Timespan(ticks * 50L);
    }

    public long getMilliSeconds() {
        return this.millis;
    }

    public long getTicks() {
        return Math.round((double)this.millis / 50.0);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public long getTicks_i() {
        return Math.round((double)this.millis / 50.0);
    }

    public String toString() {
        return Timespan.toString(this.millis);
    }

    public String toString(int flags) {
        return Timespan.toString(this.millis, flags);
    }

    public static String toString(long millis) {
        return Timespan.toString(millis, 0);
    }

    public static String toString(long millis, int flags) {
        for (int i = 0; i < simpleValues.length - 1; ++i) {
            if (millis < simpleValues[i].getSecond()) continue;
            double second = 1.0 * (double)(millis % simpleValues[i].getSecond()) / (double)simpleValues[i + 1].getSecond().longValue();
            if (!"0".equals(Skript.toString(second))) {
                return Timespan.toString(Math.floor(1.0 * (double)millis / (double)simpleValues[i].getSecond().longValue()), simpleValues[i], flags) + " " + GeneralWords.and + " " + Timespan.toString(second, simpleValues[i + 1], flags);
            }
            return Timespan.toString(1.0 * (double)millis / (double)simpleValues[i].getSecond().longValue(), simpleValues[i], flags);
        }
        return Timespan.toString(1.0 * (double)millis / (double)simpleValues[simpleValues.length - 1].getSecond().longValue(), simpleValues[simpleValues.length - 1], flags);
    }

    private static String toString(double amount, NonNullPair<Noun, Long> p, int flags) {
        return p.getFirst().withAmount(amount, flags);
    }

    @Override
    public int compareTo(@Nullable Timespan o) {
        long d;
        long l = d = o == null ? this.millis : this.millis - o.millis;
        return d > 0L ? 1 : (d < 0L ? -1 : 0);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.millis / Integer.MAX_VALUE);
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Timespan)) {
            return false;
        }
        Timespan other = (Timespan)obj;
        return this.millis == other.millis;
    }

    static {
        Language.addListener(new LanguageChangeListener(){

            @Override
            public void onLanguageChange() {
                for (int i = 0; i < names.length; ++i) {
                    parseValues.put(names[i].getSingular().toLowerCase(Locale.ENGLISH), times[i]);
                    parseValues.put(names[i].getPlural().toLowerCase(Locale.ENGLISH), times[i]);
                }
            }
        });
        simpleValues = new NonNullPair[]{new NonNullPair<Noun, Long>(m_day, 86400000L), new NonNullPair<Noun, Long>(m_hour, 3600000L), new NonNullPair<Noun, Long>(m_minute, 60000L), new NonNullPair<Noun, Long>(m_second, 1000L)};
    }
}

